import time

import yt.wrapper as yt

from projects.ml_handler_availability.pivot_keys_constant import PIVOT_KEYS


def get_pivot_keys():
    result = PIVOT_KEYS
    return [[one_key for one_key in keys] for keys in result]



def create_dyn_table_from_usual(from_yt_path, to_yt_path, table_key):
    if yt.exists(to_yt_path):
        yt.remove(to_yt_path)

    schema = yt.get_attribute(from_yt_path, 'schema')

    start = time.time()
    yt.create(
        'table',
        to_yt_path,
        attributes={
            'optimize_for': yt.get_attribute(
                from_yt_path, 'optimize_for', default='lookup',
            ),
            'schema': schema,
        },
    )
    schema.attributes['unique_keys'] = True
    print('created', time.time() - start)

    yt.run_merge(
        from_yt_path,
        to_yt_path,
        mode='sorted',
        spec={
            'job_io': {
                'table_writer': {
                    'block_size': 256 * 2 ** 10,
                    'desired_chunk_size': 100 * 2 ** 20,
                },
            },
            'force_transform': True,
        },
    )
    print('merged', time.time() - start)
    # Sort table. Resulting table schema has unique_keys=True.
    yt.run_sort(
        to_yt_path,
        yt.TablePath(to_yt_path, attributes={'schema': schema}),
        sort_by=[table_key],
        spec={
            'partition_job_io': {
                'table_writer': {'block_size': 256 * 2 ** 10},
            },
            'merge_job_io': {'table_writer': {'block_size': 256 * 2 ** 10}},
            'sort_job_io': {'table_writer': {'block_size': 256 * 2 ** 10}},
        },
    )
    print('run_sorted', time.time() - start)

    # it s goint to be tried
    yt.alter_table(to_yt_path, dynamic=True, schema=schema)
    print('altered', time.time() - start)
    # # Restore tablet structure.
    yt.reshard_table(to_yt_path, sync=True, pivot_keys=get_pivot_keys())
    # Table is ordered; must provide tablet count
    print('resharded', time.time() - start)
    yt.mount_table(to_yt_path, sync=True)
    print('mounted', time.time() - start)
    # it s goint to be tried