import argparse
import time

import datetime
from nile.api.v1 import extractors as ne
from nile.api.v1 import filters as nf
from nile.api.v1 import Record
from qb2.api.v1 import typing as qt
from qb2.api.v1 import filters as qf
import yt.wrapper as yt

from projects.data_sources.data_context.raworders_dmorders_sessions import \
    DataContext as OrdersSessionsLogsDataContext
from projects.efficiency_metrics.project_config import get_project_cluster
from projects.ml_handler_availability.dynamic_tables_util import create_dyn_table_from_usual
from projects.ml_handler_availability.launcher import get_schema


def default_mapper_courier(records):
    for record in records:

        courier_info_from = record.to_dict()

        courier_info_to = {}
        for k, v in courier_info_from.items():
            if (v is not None) and (k != 'dbid_uuid'):
                courier_info_to[str(k)] = float(v)

        yield Record(
            dbid_uuid=record.dbid_uuid,
            courier_info=courier_info_to
        )


if __name__ == '__main__':

    parser = argparse.ArgumentParser()
    parser.add_argument('--yt-proxy', default='Hahn')
    parser.add_argument(
        '--dyn-features-table-yt-path',
        default='',
    )
    parser.add_argument(
        '--usual-features-table-yt-path',
        default=''
    )
    parser.add_argument(
        '--type-of-dyn-table',
        default=''
    )
    parser.add_argument(
        '--dttm',
        default=''
    )
    args = parser.parse_args()

    start = time.time()
    print(args.usual_features_table_yt_path,
        args.dyn_features_table_yt_path)

    yt.config.set_proxy(args.yt_proxy)
    cluster = get_project_cluster(proxy=args.yt_proxy)

    utc_datetime = datetime.datetime.utcnow()

    RUSLAN_FEATURES = [
        "ar",
        "ar_claim",
        "ar_eda",
        "cr",
        "cr_claim",
        "cr_eda",
        "executor_profile_id",
        "orders",
        "orders_claim",
        "orders_eda",
        "seens",
        "seens_claim",
        "seens_eda",
        "tariff_class_courier_any",
        "tariff_class_courier_last",
        "tariff_class_econom_any",
        "tariff_class_econom_last",
        "tariff_class_express_any",
        "tariff_class_express_last",
        "thermobag_any",
        "thermobag_last"
    ]
    # schema
    type_of_dyn_table = args.type_of_dyn_table

    # START:
    schema = get_schema(type_of_dyn_table)
    print(schema)

    custom_extractors = {}
    for ce_key in schema.keys():
        custom_extractors[ce_key] = ne.custom(lambda x: x, ce_key)

    job = cluster.job('Couriers collection' + str(time.time()))
    job = job.env(
        bytes_decode_mode='strict',
        yt_spec_defaults={'max_failed_job_count': 1000}
    )

    orders_d_c = OrdersSessionsLogsDataContext(
        job,
        (utc_datetime - datetime.timedelta(days=21)),
        utc_datetime,
        ['atlas_drivers', 'light_order_proc', 'sessions']
    )

    all_profiles = orders_d_c.get_sessions().filter(
        qf.defined('enabled_tariff_class_code_list'),
        nf.custom(
            lambda x: ('courier' in x) or ('express' in x),
            'enabled_tariff_class_code_list'
        )
    ).project(
        'dbid_uuid', 'driver_uuid', 'park_taximeter_id'
    ).unique(
        'dbid_uuid', 'driver_uuid', 'park_taximeter_id'
    )

    job.table('//home/eda-analytics/rukireev/drivers_features').project(
        *RUSLAN_FEATURES
    ).join(
        all_profiles,
        by_left='executor_profile_id',
        by_right='driver_uuid',
        type='inner'
    ).project(
        ne.all(['driver_uuid', 'park_taximeter_id', 'executor_profile_id'])
    ).filter(
        qf.defined('dbid_uuid')
    ).map(
        default_mapper_courier
    ).project(**custom_extractors).sort('dbid_uuid').put(
        args.usual_features_table_yt_path,
        schema=schema
    )

    job.run()

    # START: load dyn table from usual table
    create_dyn_table_from_usual(
        args.usual_features_table_yt_path,
        args.dyn_features_table_yt_path,
        type_of_dyn_table
    )

