import argparse
import sys
import time

import datetime
import geohash as gh
import numpy as np

from nile.api.v1 import extractors as ne
from nile.api.v1 import filters as nf
from nile.api.v1 import Record
from qb2.api.v1 import filters as qf
from qb2.api.v1 import typing as qt

from projects.burnt_orders_research.ld_parsing_nile_block import \
    LogEntrySegmentDetector
from projects.burnt_orders_research.nile_blocks.main import (
    calc_different_stats, dup_mapper, main_reducer, get_all_waybills_by_segment,
    claim_ld_stages_mapper, claims_pattern_ld_stages_reducer
)
from projects.burnt_orders_research.nile_blocks.propositions import(
    proposition_reducer,
)
from projects.common.nile.dates import range_selector
from projects.data_sources.data_context.eda_logs import \
    DataContext as EdaOrdersDataContext
from projects.data_sources.data_context.raw_services_logs import \
    DataContext as RawLogs
from projects.data_sources.data_context.cargo import \
    DataContext as CargoLogsDataContext
from projects.data_sources.data_context.raworders_dmorders_sessions import \
    DataContext as TaxiOrdersDataContext
from projects.efficiency_metrics.project_config import get_project_cluster
from projects.burnt_orders_research.ld_parsing_nile_block import \
    LogEntrySegmentDetector


MOSCOW_ZONES = [
            "obuhovo",
            "vniissok",
            "monino",
            "korolev",
            "losino-petrovsky_district",
            "ramenskoe",
            "shcherbinka",
            "schelkovsky_district",
            "domodedovo",
            "udelnaya",
            "msk",
            "lytkarino",
            "aprelevka",
            "dolgoprudniy",
            "ivanteevka",
            "pushkino",
            "vidnoe_district",
            "zavety_il'icha",
            "klimovsk",
            "losino_petrovsky",
            "troitsky_district",
            "himki",
            "elektrougli",
            "nakhabino",
            "lobnya_district",
            "kalininec",
            "pravdinskij",
            "rodniki_mo",
            "krasnogorsk",
            "moscow",
            "zhukovskiy",
            "dedovsk",
            "kratovo",
            "pushkinsky_district",
            "bolshie_vyazyomy",
            "istra_district",
            "ivanteyevka_district",
            "odincovo",
            "reutov",
            "korolev_district",
            "malahovka",
            "odincovo_district",
            "svo",
            "lesnoj_gorodok",
            "vko",
            "staraja_kupavna",
            "ilinskiy",
            "balashikha_district",
            "dme",
            "shelkovo",
            "skolkovo",
            "zhukovsky_district",
            "krasnogorsky_district",
            "shodnya",
            "anti_strike_1",
            "kotelniki",
            "boryasvo",
            "fryazino",
            "troick",
            "domodedovo_district",
            "selyatino",
            "mytishchi_district",
            "sverdlovsky",
            "balashiha",
            "golicyno",
            "mytishchi",
            "bykovo",
            "oktyabrsky_mo",
            "lytkarino_district",
            "ramensky_district",
            "dzerzhinsky",
            "zheleznodorozhny",
            "odintsovskii_district",
            "lvovskij",
            "vidnoe",
            "krasnogorsk_district",
            "fryazino_district",
            "andreevka",
            "zelenogradsk_district",
            "vlasiha",
            "dolgoprudniy_district",
            "mendeleevo",
            "dzerzhinsky_district",
            "tomilino",
            "krasnoznamensk",
            "kraskovo",
            "lobnja",
            "podolsk",
            "nekrasovskij",
            "podolsk_district",
            "lyberci",
            "zelenograd"
          ]


def get_table_with_claims(job, from_date, to_date):

    cargo_d_c = CargoLogsDataContext(job, from_date, to_date)

    claims = cargo_d_c.get_claims().project(
        'taxi_order_id', 'uuid_id', 'is_delayed', 'due', 'timestamp',
        'idempotency_token'
    )
    segments = cargo_d_c.get_segments()

    return (
        claims.join(
            segments,
            by_left='uuid_id', by_right='claim_id', type='left',
        ).project(
            ne.all(),
            utc_date=ne.custom(
                lambda x:
                datetime.datetime.utcfromtimestamp(x).strftime('%Y-%m-%d'),
                'timestamp'
            ),
            utc_date_hour=ne.custom(
                lambda x:
                datetime.datetime.utcfromtimestamp(x).strftime('%Y-%m-%d %H'),
                'timestamp'
            )
        ).filter(
            nf.custom(lambda x: x >= from_date.strftime('%Y-%m-%d'), 'utc_date'),
            nf.custom(lambda x: x < to_date.strftime('%Y-%m-%d'), 'utc_date')
        ).project(
            "claim_id",
            "due",
            "is_delayed",
            "s_timestamp",
            "segment_id",
            'employer',
            'utc_date',
            'utc_date_hour'
        )
    )


def get_sec_till_performer_found(timeline, is_delayed, due, dispatch_zone_id, created_ts):
    # 4decd14f25424e8b82b6d3e4f56d23b2, 87cda4c03d60416bb522e83fe24b3d50

    # еда, не москва
    # "build_interval_seconds": 900,
    # если soon, сколько ищем от момента создания
    # если due, от (due-300) до
    # "create_before_due_seconds": 300

    # еда, москва
    # "build_interval_seconds": 2820,
    # "create_before_due_seconds": -1200

    assignment_timestamp = None
    for el in timeline:
        if el[0] == 'assignment':
            assignment_timestamp = el[1]


    eats_ld_starts_timestamp = None
    delivery_ld_starts_timestamp = None

    # ?
    # для due заказов поиск по-другому происходит
    # if is_delayed == True:
    if due is not None:
        # eats_ld_starts_timestamp = max(
        #     due - (300 if dispatch_zone_id not in MOSCOW_ZONES else -1200) - 30 * 60,
        #     created_ts# timeline[0][1]
        # )
        # delivery_ld_starts_timestamp = max(
        #     due - (300 if dispatch_zone_id not in MOSCOW_ZONES else -1200) - 1 * 60,
        #     created_ts # timeline[0][1]
        # )
        eats_ld_starts_timestamp = max(
            due - (35 * 60 if dispatch_zone_id not in MOSCOW_ZONES else 55 * 60),
            created_ts# timeline[0][1]
        )
        delivery_ld_starts_timestamp = max(
            due - (6 * 60 if dispatch_zone_id not in MOSCOW_ZONES else 6 * 60),
            created_ts # timeline[0][1]
        )
    else:
        eats_ld_starts_timestamp = created_ts # timeline[0][1]
        delivery_ld_starts_timestamp = created_ts + (
            14 * 60 if dispatch_zone_id not in MOSCOW_ZONES else 38 * 60
        )

    return [
        (assignment_timestamp - eats_ld_starts_timestamp) if
        (assignment_timestamp is not None) else None,

        (assignment_timestamp - delivery_ld_starts_timestamp) if
        (assignment_timestamp is not None) and
        (delivery_ld_starts_timestamp) else None,
    ]


def calc(sec_till_performer_found_eats_tmp, sec_till_performer_found_delivery_tmp):
    if sec_till_performer_found_eats_tmp is None:
        if sec_till_performer_found_delivery_tmp is None:
            return None
        elif sec_till_performer_found_delivery_tmp is not None:
            return sec_till_performer_found_delivery_tmp

    if sec_till_performer_found_delivery_tmp < 0:
        return sec_till_performer_found_eats_tmp
    elif sec_till_performer_found_delivery_tmp < sec_till_performer_found_eats_tmp:
        return sec_till_performer_found_delivery_tmp
    else:
        return sec_till_performer_found_eats_tmp

def get_ld_basic_stats_and_timeline(job, from_date, to_date):

    raw_logs_dc = RawLogs(
        job,
        from_date,
        to_date
    )
    (
    #     raw_logs_dc.get_ld_dispatch().filter(
    #         qf.defined('segment_id')
    #     ).map(
    #         LogEntrySegmentDetector()
    #     ).filter(
    #         qf.defined('segment_id')
    #     ).groupby(
    #         'segment_id'
    #     ).sort(
    #         'timestamp_ld'
    #     ).reduce(
    #         calc_different_stats
    #     ).join(
    #         get_table_with_claims(job, from_date, to_date), by='segment_id', type='inner'
    #     ).filter(
    #         nf.custom(lambda x: x in [
    #             "4decd14f25424e8b82b6d3e4f56d23b2",
    #             "87cda4c03d60416bb522e83fe24b3d50"
    #         ], 'corp_client_id')
    #     ).put(
    #         yt_path_to.format(to_date.strftime('%Y-%m-%d') + '_')
    #     )

        job.table(yt_path_to.format(to_date.strftime('%Y-%m-%d') + '_')).project(
            ne.all(),
            tmp=ne.custom(
                lambda x, y, z, a, b: get_sec_till_performer_found(x, y, z, a, b),
                'timeline', 'is_delayed', 'due', 'dispatch_zone_id', 's_timestamp'
                #(timeline, is_delayed, due, dispatch_zone_id, created_ts), 'timeline'
            )
        ).project(
            ne.all(),
            sec_till_performer_found_eats_tmp=ne.custom(lambda x: x[0], 'tmp'),
            sec_till_performer_found_delivery_tmp=ne.custom(lambda x: x[1], 'tmp')
        ).project(
            ne.all(['sec_till_performer_found_eats_tmp', 'sec_till_performer_found_delivery_tmp']),
            sec_till_performer_found_eats=ne.custom(
                lambda x, y: calc(x, y)
                , 'sec_till_performer_found_eats_tmp', 'sec_till_performer_found_delivery_tmp'
            ),
            sec_till_performer_found_delivery=ne.custom(
                lambda x, y: calc(x, y)
                , 'sec_till_performer_found_eats_tmp', 'sec_till_performer_found_delivery_tmp'
            ),

        ).put(
            yt_path_to.format(to_date)
            # yt_path_to.format('calc_different_stats_{}'.format(to_date.strftime('%Y-%m-%d')))
        )
    )
    return job


if __name__ == '__main__':

    parser = argparse.ArgumentParser()
    parser.add_argument('--yt-proxy', type=str, default='Hahn')
    parser.add_argument('--from-date', type=str, required=True)
    parser.add_argument('--to-date', type=str, required=True)

    args = parser.parse_args()

    cluster = get_project_cluster()

    # from_date = '2021-04-12'
    # from_date = '2021-05-05'
    # from_date = '2021-05-12'
    # to_date = '2021-05-26'
    from_date = datetime.datetime.strptime(args.from_date, '%Y-%m-%d')
    to_date = datetime.datetime.strptime(args.to_date, '%Y-%m-%d')

    yt_path_to = '//home/taxi-delivery/analytics/production/ml_handler/targets/{}'

    job = cluster.job('LD metrics' + str(time.time()))
    job = job.env(bytes_decode_mode='strict')

    job = get_ld_basic_stats_and_timeline(job, from_date, to_date)

    job.run()