import argparse
from collections import Counter
from itertools import chain
import time
import re

import datetime
import six
from nile.api.v1 import aggregators as na
from nile.api.v1 import extractors as ne
from nile.api.v1 import filters as nf
from nile.api.v1 import Record
from qb2.api.v1 import filters as qf
from qb2.api.v1 import typing as qt


from projects.batching.batching_custom_params import (
    YARCHE_ADDRESSES, VV_ADDRESSES_TMP
)
from projects.data_sources.data_context.cargo import \
    DataContext as CargoLogsDataContext
from projects.data_sources.data_context.raworders_dmorders_sessions import \
    DataContext as OrdersSessionsLogsDataContext
from projects.data_sources.data_context.raw_services_logs import \
    DataContext as RawServicesLogsDataContext
from projects.efficiency_metrics.project_config import get_project_cluster
from projects.batching.nile_blocks.corps import calc_a_density_reducer
from projects.common.gp_transfer import transfer_from_yt_2_gp

from projects.batching.launcher_2 import calc_time_till_cancell



if __name__ == '__main__':

    parser = argparse.ArgumentParser()
    parser.add_argument('--yt-proxy', type=str, default='Hahn')
    parser.add_argument(
        '--yt-path-dir-to', type=str,
        default='//home/taxi_ml/dev/ml_handler/target/{}'
    )
    parser.add_argument('--start-date', type=str)
    parser.add_argument('--finish-date', type=str)

    args = parser.parse_args()

    cluster = get_project_cluster()

    yt_path_dir_to = args.yt_path_dir_to
    start_date = args.start_date
    finish_date = args.finish_date

    job = cluster.job('Couriers collection' + str(time.time()))
    job = job.env(
        bytes_decode_mode='strict',
        yt_spec_defaults={'max_failed_job_count': 1000}
    )
    #
    # cargo_d_c = CargoLogsDataContext(
    #     job,
    #     datetime.datetime.strptime(
    #         start_date, '%Y-%m-%d')
    #     ,
    #     datetime.datetime.strptime(
    #         finish_date, '%Y-%m-%d'
    #     ),
    # )
    #
    # claims = cargo_d_c.get_claims().project(
    #     'taxi_order_id','uuid_id',#'timestamp', 'final_price',
    #     'corp_client_id',
    #     'status',
    #     'zone_id', #'dispatch_flow', 'final_pricing_calc_id',
    #     'is_delayed', #'due', 'eta', 'currency',
    #     # 'last_status_change_ts',
    #     'claim_kind',
    #     claim_id='id',
    #     utc_date=ne.custom(
    #         lambda x:
    #         datetime.datetime.utcfromtimestamp(x).strftime('%Y-%m-%d'),
    #         'timestamp'
    #     ),
    # )
    #
    # claims_log_statuses = cargo_d_c.get_claims_change_log().project(
    #     ne.all(['claim_id']), uuid_id='claim_id'
    # ).groupby(
    #     'uuid_id'
    # ).sort(
    #     'updated_ts'
    # ).reduce(
    #     calc_time_till_cancell
    # ).filter(
    #     qf.defined('new_ts')
    # ).project(
    #     'uuid_id', 'status',
    #     sec_till_performer_lookup=ne.custom(
    #         lambda x, y: ((x or 0) - y) if (x is not None) else None,
    #         'performer_lookup_ts', 'new_ts'
    #     ),
    #     sec_till_cancelled=ne.custom(
    #         lambda x, y: ((x or 0) - y) if (x is not None) else None,
    #         'cancelled_ts', 'new_ts'
    #     ),
    #     sec_till_performer_found = ne.custom(
    #         lambda x, y: ((x or 0) - y) if (x is not None) else None,
    #         'performer_found_ts', 'new_ts'
    #     ),
    #     sec_till_delivered_returned = ne.custom(
    #         lambda x, y: ((x or 0) - y) if (x is not None) else None,
    #         'delivered_returned_ts', 'new_ts'
    #     ),
    #     sec_till_delivered=ne.custom(
    #         lambda x, y: ((x or 0) - y) if (x is not None) else None,
    #         'delivered_ts', 'new_ts'
    #     )
    #
    # ).join(
    #     claims, by_left='uuid_id', by_right='uuid_id', type='inner'
    # ).put(
    #     yt_path_dir_to.format(
    #         '{}'.format(finish_date))
    # )

    job.table(yt_path_dir_to.format('{}'.format(finish_date))).project(
        ne.all(),
        diff_btw=ne.custom(
            lambda x, y: (x - y) if
            ((x is not None) and (y is not None))
            else None, 'sec_till_performer_found', 'sec_till_performer_lookup')
    ).put(
        yt_path_dir_to.format('{}'.format(finish_date)) + '_tmp'
    )


    # job.table(yt_path_dir_to.format(
    #         '{}'.format(finish_date))).filter(
    #     nf.custom(lambda x: x == '4decd14f25424e8b82b6d3e4f56d23b2','corp_client_id'),
    #     nf.custom(lambda x: x != 'platform_usage', 'claim_kind')
    #
    # ).put(
    #     yt_path_dir_to.format(
    #         '{}_eda_only_log_supply'.format(finish_date))
    # )

    job.run()



