function calculate (common_context, order_context, candidate_context, trace) {

//     {
//   "express_supply_bonus": {
//     "bonus": 600
//   }
// }

    const zone = order_context.order_from_request.nearest_zone;
    if (zone === undefined)
        return 0.0;

    const tags = candidate_context.tags;
    if (tags.length === 0)
        return 0.0;

    const auto_courier = tags.includes('auto_courier');
    if (!auto_courier)
        return 0.0;

    let bonus = 420.0;
    const bonus_params = order_context.dispatch_settings.SCRIPT_BONUS_PARAMS;
    if (bonus_params !== undefined) {
        const express_supply_bonus = bonus_params.express_supply_bonus;
        if (express_supply_bonus !== undefined) {
            const bonus_param = express_supply_bonus.bonus;
            if (bonus_param !== undefined) {
                bonus = bonus_param;
            }
        }
    }

    return bonus;
}

function calculate (common_context, order_context, candidate_context, trace) {

    const zone = order_context.order_from_request.nearest_zone;
    if (zone === undefined)
      return 0.0;

    const tags = candidate_context.tags;
    if (tags.length === 0) {
      // Return early for performance
      return 0.0;
    }



    // TODO: ?? make it in config
    const router_type = candidate_context.candidate_from_request.route_info.type
    if (router_type == 'pedestrian') {
      switch (zone) {
        case 'moscow': return 1200.0;
        case 'spb': return 1200.0;
        default: return 1200.0;
      }
    }

    // TODO: ??

    // {
    //   "express_supply_bonus": {
    //     "auto_courier_bonus": 600,
    //     "taxi_express_bonus":
    //   }
    // }
    let auto_courier_bonus = 420.0;
    let taxi_express_bonus = -300.0
    const bonus_params = order_context.dispatch_settings.SCRIPT_BONUS_PARAMS;
    if (bonus_params !== undefined) {
        const express_supply_bonus = bonus_params.express_supply_bonus;
        if (express_supply_bonus !== undefined) {
            const bonus_param = express_supply_bonus.bonus;
            if (bonus_param !== undefined) {
                bonus = bonus_param;
            }
        }
    }

    switch (zone) {
      case 'moscow':
        for (let i = 0; i < tags.length; ++i) {
          switch (tags[i]) {
            case 'auto_courier': return 600.0;
            case 'taxi_express': return -300.0;
            default: break;
          }
        }
        break;
      case 'spb':
        for (let i = 0; i < tags.length; ++i) {
          switch (tags[i]) {
            case 'auto_courier': return 600.0;
            case 'taxi_express': return -300.0;
            default: break;
          }
        }
        break;
      case 'sochi':
        for (let i = 0; i < tags.length; ++i) {
          switch (tags[i]) {
            case 'auto_courier': return 1200.0;
            case 'taxi_express': return -1200.0;
            default: break;
          }
        }
        break;
      default:
        for (let i = 0; i < tags.length; ++i) {
          switch (tags[i]) {
            case 'auto_courier': return 420.0;
            case 'taxi_express': return -300.0;
            default: break;
          }
        }
        break;
    }

    return 0.0;
}
