drop table if exists ru_geo_hierarchy;
create temp table ru_geo_hierarchy as
select geo.tariff_zone,
       geo.tz_aggl_name_en,
       coalesce(
               coalesce(mow.name_en, case when spb.region = 'SPb and SPb region' then 'SPb region' else spb.region end),
               geo.name_en) as region
from core_cdm_geo.v_dim_full_geo_hierarchy as geo
         left join (select distinct tariff_zone, name_en
                    from core_cdm_geo.v_dim_full_geo_hierarchy
                    where name_en in ('Moscow (Middle Region)',
                                      'Moscow (Near Region)',
                                      'Moscow (adm)',
                                      'Far Moscow Region')) as mow
                   on geo.tariff_zone = mow.tariff_zone
         left join (select min(name_en) as region,
                           tariff_zone
                    from core_cdm_geo.v_dim_full_geo_hierarchy
                    where name_en in ('SPb and SPb region', 'Saint-Petersburg (adm)')
                    group by tariff_zone) as spb
                   on geo.tariff_zone = spb.tariff_zone
where geo.tag_list = '{federal district}'
;

-- FULL HIERARCHY WITH RUSSIAN REGIONS
drop table if exists regions_geo;
create temp table regions_geo as
select h.tariff_zone, h.name_en as tz_aggl_name_en, h.tz_country_name_en, coalesce(region, h.tz_country_name_en) as region_name_en, total_population, population_group
from core_cdm_geo.v_dim_full_geo_hierarchy h
         left join ru_geo_hierarchy r
                   on r.tariff_zone = h.tariff_zone
where h.node_type = 'agglomeration'
  and h.root_node_id = 'br_root'
;

drop table if exists subsidy_supply_type;
create temp table subsidy_supply_type as
select lcl_order_created_dttm::date                             as dt
--      , e.unique_driver_id                       as unique_driver_id
     , courier_type
     , tariff_class_code
     , tariff_geo_zone_code
     , sum(subsidy_do_x_get_y_value * currency_rate)            as subsidy_do_x_get_y_value
     , sum(subsidy_guarantee_booking_geo_value * currency_rate) as subsidy_guarantee_booking_geo_value
     , sum(subsidy_mfg_geo_value * currency_rate)               as subsidy_mfg_geo_value
     , sum(subsidy_mfg_value * currency_rate)                   as subsidy_mfg_value
     , sum(subsidy_misc_value * currency_rate)                  as subsidy_misc_value
     , sum(subsidy_nmfg_value * currency_rate)                  as subsidy_nmfg_value
     , sum(subsidy_on_top_value * currency_rate)                as subsidy_on_top_value
     , sum(subsidy_personal_do_x_get_y_value * currency_rate)   as subsidy_personal_do_x_get_y_value
--     , sum(subsidy_other_value * currency_rate)                 as subsidy_other_value
     , sum(subsidy_on_top_booking_geo_value * currency_rate)    as subsidy_on_top_booking_geo_value
     , sum((subsidy_do_x_get_y_value + subsidy_guarantee_booking_geo_value + subsidy_mfg_geo_value + subsidy_mfg_value +
           subsidy_misc_value + subsidy_nmfg_value + subsidy_on_top_value + subsidy_personal_do_x_get_y_value +
           subsidy_on_top_booking_geo_value) * currency_rate)                 as subsidy_total

from taxi_cdm_finance.fct_order_subsidy_by_type as f
         left join taxi_cdm_supply.dm_executor_profile_act as e on f.executor_profile_sk = e.executor_profile_sk
         left join snb_delivery.logvinenko_supply_for_subsidy as s on e.unique_driver_id = s.unique_driver_id
    and f.lcl_order_created_dttm::date = s.lcl_order_created_dt::date
where lcl_order_created_dttm >= (current_date - interval '7 month')
  and tariff_class_code in ('courier', 'express', 'cargo', 'cargocorp', 'night', 'ubernight')
group by dt
--        , e.unique_driver_id
       , courier_type
       , tariff_class_code
       , tariff_geo_zone_code;

drop table if exists gmv_supply_type;
create temp table gmv_supply_type as
select fct.lcl_order_created_dt as dt,
       courier_type,
       tariff_geo_zone_code,
       tariff_class_code,
       sum(gmv_amt * currency_rate) as gmv
from taxi_cdm_marketplace.fct_order_metric as fct
         left join snb_delivery.logvinenko_supply_for_subsidy as s on fct.unique_driver_id = s.unique_driver_id
    and fct.lcl_order_created_dt = s.lcl_order_created_dt::date
where 1 = 1
  and fct.lcl_order_created_dttm >= (current_date - interval '7 month')
  and tariff_class_code in ('cargo', 'cargocorp', 'courier', 'express', 'night', 'ubernight')
  and not mqc_order_flg
  and success_order_flg
  --and fct.lcl_order_created_dt >= (current_date - interval '12 month')
group by dt
       , courier_type
       , tariff_geo_zone_code
       , tariff_class_code;


drop table if exists subsidy_with_supply;
create temp table subsidy_with_supply as
select coalesce(s.dt, g.dt)                                     as dt
     , coalesce(s.courier_type, g.courier_type)                 as courier_type
     , coalesce(s.tariff_geo_zone_code, g.tariff_geo_zone_code) as tariff_geo_zone_code
     , coalesce(s.tariff_class_code, g.tariff_class_code)       as tariff_class_code
     , coalesce(gmv, 0)                                         as gmv
     , coalesce(subsidy_do_x_get_y_value, 0)                    as subsidy_do_x_get_y_value
     , coalesce(subsidy_guarantee_booking_geo_value, 0)         as subsidy_guarantee_booking_geo_value
     , coalesce(subsidy_mfg_geo_value, 0)                       as subsidy_mfg_geo_value
     , coalesce(subsidy_mfg_value, 0)                           as subsidy_mfg_value
     , coalesce(subsidy_misc_value, 0)                          as subsidy_misc_value
     , coalesce(subsidy_nmfg_value, 0)                          as subsidy_nmfg_value
     , coalesce(subsidy_on_top_value, 0)                        as subsidy_on_top_value
     , coalesce(subsidy_personal_do_x_get_y_value, 0)           as subsidy_personal_do_x_get_y_value
--     , coalesce(subsidy_other_value, 0)                         as subsidy_other_value
     , coalesce(subsidy_on_top_booking_geo_value,0)             as subsidy_on_top_booking_geo_value
     , coalesce(subsidy_total, 0)                               as subsidy_total
from subsidy_supply_type as s
         full join gmv_supply_type as g on s.dt = g.dt and s.courier_type = g.courier_type and
                                           s.tariff_geo_zone_code = g.tariff_geo_zone_code and
                                           s.tariff_class_code = g.tariff_class_code;

drop table if exists snb_delivery.logvinenko_subsidy_with_supply;
create table snb_delivery.logvinenko_subsidy_with_supply as
select s.*
     , region_name_en
     , tz_country_name_en
     , tz_aggl_name_en
     , split_part(population_group, '_', 1) as country_code
     , split_part(population_group, '_', 2) as population
     , now()::date as today
from subsidy_with_supply as s
         left join regions_geo as b
                   on s.tariff_geo_zone_code = b.tariff_zone;

GRANT SELECT ON snb_delivery.logvinenko_subsidy_with_supply TO public;
