

import argparse
from collections import Counter
import time
import re

import datetime
from nile.api.v1 import aggregators as na
from nile.api.v1 import extractors as ne
from nile.api.v1 import filters as nf
from nile.api.v1 import Record
from qb2.api.v1 import filters as qf
import numpy as np


from projects.batching.batching_custom_params import (
    VKUSVILL_CORP_CLIENT_ID, VV_ADDRESSES, VV_ADDRESSES_IDS,
    YARCHE_CORP_CLIENT_ID, YARCHE_ADDRESSES
)
from projects.data_sources.data_context.cargo import \
    DataContext as CargoLogsDataContext
from projects.data_sources.data_context.raworders_dmorders_sessions import \
    DataContext as OrdersSessionsLogsDataContext

from projects.data_sources.data_context.raw_services_logs import \
    DataContext as RawServicesLogsDataContext
from projects.efficiency_metrics.project_config import get_project_cluster
from projects.batching.nile_blocks.corps import calc_a_density_reducer



if __name__ == '__main__':

    parser = argparse.ArgumentParser()
    parser.add_argument('--yt-proxy', type=str, default='Hahn')
    parser.add_argument(
        '--yt-path-dir-to', type=str,
        default='//home/taxi-delivery/analytics/dev/batching/dead/{}'
    )
    parser.add_argument('--start-date', type=str)
    parser.add_argument('--finish-date', type=str)

    args = parser.parse_args()

    cluster = get_project_cluster()

    yt_path_dir_to = args.yt_path_dir_to
    start_date = args.start_date
    finish_date = args.finish_date

    job = cluster.job('Couriers collection' + str(time.time()))
    job = job.env(
        bytes_decode_mode='strict',
        yt_spec_defaults={'max_failed_job_count': 1000}
    )

    # Москва, Спб, Воронеж, Омск, Красноярск, Челябинск, Самара, Пермь, Волгоград, Краснодар, Казань, Ростов-на-Дону, Новосибирск, Екатеринбург

    # job.table('//home/taxi_ml/production/users/features/2021-03-28').filter(
    #     nf.custom(lambda x: x in [
    #         'moscow', 'spb', 'voronezh', 'omsk', 'krasnoyarsk', 'chelyabinsk',
    #         'samara', 'perm', 'volgograd', 'krasnodar', 'kazan', 'rostovondon',
    #         'ekb', 'novosibirsk'
    #     ], 'tariff_zone_28_most_common')
    #
    # ).put(
    #     '//home/taxi_ml/production/users/features/2021-03-28_filtered'
    # )#.groupby(
    # #     ''
    # # )

    # job.table('//home/taxi_ml/production/users/features/2021-03-28_filtered').project(
    #     ne.all(),
    #     n_trips=ne.custom(lambda x: [v for k, v in x.items() if k not in [
    #         'express', 'courier'
    #     ]], 'order_tariff_28_cat_distribution')
    # ).filter(
    #     nf.custom(lambda x: len(x) > 0, 'n_trips')
    # ).project(
    #     ne.all(),
    #     n_trips_cnt=ne.custom(lambda x: sum(x), 'n_trips')
    # ).aggregate(
    #     n_trips_cnt_sum=na.sum('n_trips_cnt')
    # ).put(
    #     '//home/taxi_ml/production/users/features/2021-03-28_filtered_expr_cour'
    # )

    import hashlib

    import six


    def hash_string(value, salt):
        return hashlib.md5(
            six.ensure_binary(value, 'utf-8') + six.ensure_binary(salt,
                                                                  'utf-8'),
        ).hexdigest()


    def get_prob_via_hash(value, salt):
        prob = (int(hash_string(value, salt), base=16) % 10000) / 10000.0
        return prob

    # salt = '2021-03-31-tariff_less'
    #
    # job.table(
    #     '//home/taxi_ml/production/users/features/2021-03-28_filtered'
    # ).project(
    #     ne.all(),
    #     prob=ne.custom(
    #         lambda x: get_prob_via_hash(str(x), salt), 'phone_pd_id'
    #     )
    # ).put(
    #     '//home/taxi_ml/production/users/features/2021-03-28_filtered_expr_cour_prob'
    # )

    tmp = job.table(
        '//home/taxi_ml/production/users/features/2021-03-28_filtered_expr_cour_prob[#0:#900000]'
    ).project(
        'phone_pd_id', 'prob'
    ).join(
        job.table('//home/taxi-dwh/ods/mdb/user_phone/user_phone').project(
            'phone_pd_id', 'user_phone_id'
        ),
        by='phone_pd_id', type='inner'
    ).join(
        job.table('//home/taxi-dwh/summary/dm_order/2021-03').filter(
            nf.custom(lambda x: x == False, 'corp_order_flg')
        ).project(
            'user_phone_id'#, 'corp_order_flg'
        ).unique('user_phone_id'),
        type='inner', by='user_phone_id'
    )

    tmp.filter(
        nf.custom(lambda x: x <= 0.333, 'prob')
    ).put(
        '//home/taxi-delivery/analytics/production/tariff_cut/groups/group_0'
    )

    tmp.filter(
        nf.custom(lambda x: 0.333 < x <= 0.666, 'prob')
    ).put(
        '//home/taxi-delivery/analytics/production/tariff_cut/groups/group_1'
    )

    tmp.filter(
        nf.custom(lambda x: x > 0.666, 'prob')
    ).put(
        '//home/taxi-delivery/analytics/production/tariff_cut/groups/group_2'
    )

    job.run()