#!/bin/bash

set -ex

if [[ -z "$VIRTUAL_ENV" ]]; then
    echo "Need to activate some virtualenv"
    exit 1
fi

if [[ "$OSTYPE" == "darwin"* ]]; then
    READLINK=greadlink
else
    READLINK=readlink
fi

TOOLS_DIR=$(dirname "$(${READLINK} -f "$0")")
ROOT_DIR="$(dirname ${TOOLS_DIR})"
CONSTRAINTS="${ROOT_DIR}/venv-constraints.txt"
PIP_TIMEOUT=60 # to avoid errors due PR checks

### helper functions
install_develop() {
    cd $1
    python setup.py develop -i https://pypi.yandex-team.ru/simple
    cd -
}

pip_install_develop() {
    pip install --default-timeout=$PIP_TIMEOUT -i https://pypi.yandex-team.ru/simple -e $1 -c ${CONSTRAINTS}
}


### action functions
install_projects() {
    pip_install_develop ${ROOT_DIR}/projects
}

install_requirements() {
    pip install -r ${ROOT_DIR}/projects/requirements.txt -c ${CONSTRAINTS}
}

install_dev_requirements() {
    pip install -i https://pypi.yandex-team.ru/simple -r ${ROOT_DIR}/dev-requirements.txt -c ${CONSTRAINTS}
}

downgrade_pip() {
    pip install pip==20.1
}

### install according to mode

MODE=all

for i in "$@"
do
case $i in
    -m=*|--mode=*)
    MODE="${i#*=}"
    shift # past argument=value
    ;;
    *)
          # unknown option
    ;;
esac
done


case $MODE in
    all)
    downgrade_pip
    install_projects
    install_dev_requirements
    ;;
    online-dev)
    downgrade_pip
    install_requirements
    install_dev_requirements
    ;;
    online-deps)
    downgrade_pip
    install_requirements
    ;;
    *)
    echo 'Unsupported mode'
    exit 1
    ;;
esac