#!/bin/bash

set -ex

if [[ -z "${VIRTUAL_ENV}" ]]; then
    echo "Need to activate some virtualenv"
    exit 1
fi

if pip freeze | grep junk -q ; then
    echo "ALERT! junk is found in virtualenv"
    exit 1
fi


# pkg-resources: Ubuntu bug https://stackoverflow.com/questions/39577984/what-is-pkg-resources-0-0-0-in-output-of-pip-freeze-command
# appnope: Mac OS only
# Pillow: to avoid conflict with custom version in deps-py3 https://github.yandex-team.ru/taxi/deps-py3/pull/265
pip freeze --exclude-editable \
  | grep -v pkg-resources \
  | grep -v appnope \
  | grep -v Pillow \
  > ./venv-constraints.txt