
=encoding UTF-8
=cut

=head1 Название

Application::Model::API::BK - реализация API баннерокрутилки.

=head1 Описание

Базовый класс: L<QBit::Application::Model>.

L<Документация|http://wiki.yandex-team.ru/Testirovanie/FuncTesting/AdvTechnologies/BK/piTest>.

=head1 Исключения

=head2 Exception::BK

Базовое исключение.

=cut

package Exception::BK;

use base qw(Exception);

=head2 Exception::BK::BadArgument

Появляется при вызове методов с неправильными параметрами.

=cut

package Exception::BK::BadArgument;

use base qw(Exception::BK);

package QBit::Application::Model::API::Yandex::BK;

use qbit;
use base qw(QBit::Application::Model::API::SOAP);

=head1 Методы

=head2 create_or_update_campaigns

B<Параметры:>

=over

=item B<$data> - указатель на массив хешей или указатель на хеш, информация о площадках:

=over

=item B<page_id> - число, если не указано, то заводится новая площадка.

=item B<client_id> - число, ID партнёра в билинге.

=item B<name> - строка, название площадки.

=item B<places> - хеш, ID и параметры продуктов ({542 => {}, 755 => '240x400'}).

=item B<state> - строка, статус площадки (test, work, stopped).

=item B<description> - строка, описание площадки.

=item B<domain> - строка, домен площадки.

=item B<mirrors> - массив строк, зеркала площадки.

=item B<target_type> - число, тип площадки (2 - поисковая, 3 - контекстная, 8 - дистрибуция, 9 - форма поиска).

=item B<banners_count> - число, количество объявлений.

=item B<cpa> - число от 0 до 100, коэффициент качества.

=item B<options> - хеш, дополнительные параметры:

=over

=item B<distrdownloads> - 0|1, указывает, что площадка является "загрузками дистрибуции".

=item B<dontshowbehavior> - 0|1, не показывать поведенческий.

=item B<dontshowsex> - 0|1, семейный фильтр.

=item B<notaggr> - 0|1, ???.

=item B<BlockNew> - 0|1, убрать ссылку "Стать парнёром".

=item B<BlockAll> - 0|1, убрать ссылку "Все объявления".

=item B<BlockTitle> - строка, название над блоком.

=back

=item B<disabled_flags> - массив строк, не показывать банеры с этими флагами.

=item B<excluded_domains> - массив строк, не показывать рекламодателей с доменами или телефонами из этого списка
(телефоны должны быть в формате 0123456789.phone).

=item B<target_categories> - массив чисел, ID категорий 2-го уровня, по которым показывать рекламу.

=back

=back

B<Возвращаемое значение: >указатель на массив указателей на хеши вида {PageID => 0, Error => 0, ErrorStr => ''}.

=cut

sub create_or_update_campaigns {
    my ($self, $data) = @_;

    $data = [$data] if ref($data) ne 'ARRAY';

    my %bk_data;
    my $i = 0;

    foreach my $campaign (@$data) {
        if (exists($campaign->{'state'})) {
            my %states = (
                work    => 1,
                test    => 0,
                stopped => -1,
            );
            throw Exception::BK::BadArgument gettext("Parameter 'state' = '%s'", $campaign->{'state'})
              unless exists($states{$campaign->{'state'}});

            $campaign->{'state'} = $states{$campaign->{'state'}};
        }

        $campaign->{'places'} = SOAP::Data->type(SOAPStruct => {})
          if !defined($campaign->{'places'}) || (ref($campaign->{'places'}) eq 'HASH' && !keys($campaign->{'places'}));

        $campaign->{'rtb_video'}{'Contents'} = SOAP::Data->type(SOAPStruct => {})
          if exists($campaign->{'rtb_video'})
              && (
                  !defined($campaign->{'rtb_video'}{'Contents'})
                  || (ref($campaign->{'rtb_video'}{'Contents'}) eq 'HASH'
                      && !keys(%{$campaign->{'rtb_video'}{'Contents'}}))
                 );

        $campaign->{'mirrors'} = join(',', @{$campaign->{'mirrors'}}) if exists($campaign->{'mirrors'});

        if (exists($campaign->{'options'})) {
            $campaign->{'options'} = join(';',
                map    {"$_=$campaign->{'options'}{$_}"}
                  grep {$campaign->{'options'}{$_}}
                  qw(distrdownloads dontshowbehavior dontshowsex notaggr BlockNew BlockAll BlockTitle ReloadTimeout));
        }

        $campaign->{'disabled_flags'} = join(',', @{$campaign->{'disabled_flags'}})
          if exists($campaign->{'disabled_flags'});

        $campaign->{'excluded_domains'} = join(',',
            @{$campaign->{'excluded_domains'} // []},
            (map {s/[^0-9]//g; "$_.phone"} @{clone($campaign->{'excluded_phones'} // [])}))
          if exists($campaign->{'excluded_domains'}) || exists($campaign->{'excluded_phones'});

        $campaign->{'target_categories'} = join(',', @{$campaign->{'target_categories'}})
          if exists($campaign->{'target_categories'});

        $campaign->{'is_yandex_page'} = $campaign->{'client_id'} == 944028 ? 1 : 0;

        $campaign->{'banners_count'} //= 9;

        $bk_data{$i++} = {
            hash_transform(
                $campaign,
                [],
                {
                    page_id           => 'PageID',
                    client_id         => 'PartnerID',
                    name              => 'Name',
                    places            => 'Places',
                    state             => 'State',
                    description       => 'Description',
                    domain            => 'Domain',
                    mirrors           => 'Mirrors',
                    target_type       => 'TargetType',
                    banners_count     => 'PPCTotal',
                    cpa               => 'CPA',
                    options           => 'Options',
                    disabled_flags    => 'DisabledFlags',
                    excluded_domains  => 'excludeddomains',
                    target_categories => 'TargetCategory',
                    dsp_info          => 'DSPInfo',
                    pictures_enabled  => 'PicturesEnabled',
                    direct_blocks     => 'DirectBlocks',
                    rtb_blocks        => 'RtbBlocks',
                    banner_language   => 'BannerLang',
                    is_yandex_page    => 'IsYandexPage',
                    mobile_app        => 'MobileApp',
                    rtb_video         => 'RtbVideo',
                }
            )
        };
    }

    my $res_hs = $self->call('EditPage', \%bk_data);

    return [map {$res_hs->[0]{$_}} (0 .. $i - 1)];
}

sub set_conversion {
    my ($self, $data) = @_;

    my $res_hs = $self->call('SetConversion', $data);

    return;
}

TRUE;
