
=encoding UTF-8
=cut

=head1 Название

QBit::Application::Model::API::BK::FakeSoap - реализация тестового API баннерокрутилки.

=head1 Описание

У БК нет тестового инстанса с которым можно экспеременитрвать. Поэтому
появился этот модуль для тестирования работы Application::Model::API::BK

Система дергает метод EditPage, а в методе result ожидает увидеть тезультат
работы. Так же в методе fault содержится ошибка или undef, если все хорошо.

Сейчас методы в качестве результат просто отправляют те же данные что они и
получили.

=cut

package QBit::Application::Model::API::Yandex::BK::FakeSoap;

use qbit;

use base qw(QBit::Class);

our $LAST_PAGE_ID;

=head1 Методы

=head2 call

=cut

sub call {
    my ($self, $method, @params) = @_;

    my %result;

    foreach my $data (@params) {
        $result{$_} = {
            PageID => $data->{$_}{'PageID'} || $self->_get_new_page_id(),
            Error => 0,
            ErrorStr => '',
        } foreach keys(%$data);
    }

    $self->log(
        {
            proxy_url => $self->get_option('url'),
            uri       => $self->get_option('uri'),
            method    => $method,
            params    => \@params,
            content   => \%result,
            error     => undef
        }
    ) if $self->can('log');

    $self->_add_result(\%result);

    return $self;
}

sub _get_new_page_id {
    $LAST_PAGE_ID //= time();

    return $LAST_PAGE_ID++;
}

sub _add_result {
    my ($self, $result) = @_;

    $self->{'__RESULT__'} = $result;
}

sub result {
    my ($self) = @_;

    return $self->{'__RESULT__'};
}

sub fault {FALSE}

TRUE;
