package Exception::BannerStore;
use base qw(Exception);

package QBit::Application::Model::API::Yandex::BannerStore;

use qbit;
use base qw(QBit::Application::Model::API::XMLRPC);

sub init {
    my ($self) = @_;

    $self->SUPER::init();

    $self->{__RPC__}->{_serializer}->{_typelookup} = {string => [2, sub {1}, 'as_string']};
}

sub create_customer {
    my ($self, %opts) = @_;

    throw Exception::BadArguments("Expected 'login', 'pass' and 'company_name'")
      if grep {!$opts{$_}} qw(login pass company_name);

    my $result =
      $self->call('BannerStore.CreateCustomer', map {$opts{$_}} qw(login pass first_name last_name company_name));

    throw Exception::BannerStore gettext('Customer don\'t created in BannerStore')
      if $result->[0] == 0;

    return TRUE;
}

TRUE;
