package QBit::Application::Model::API::Yandex::Captcha;

use qbit;

use base qw(QBit::Application::Model::API::HTTP);

sub generate {
    my ($self, %opts) = @_;

    my $xml = $self->call('generate', hash_transform(\%opts, [qw(type checks)]));

    if ($xml =~ /<number(\s([^>]*))?>(.*)<\/number>/io) {
        my $key    = $3;
        my $params = $2;
        my $url;
        if ($params =~ /url=["'](.*?)["']/) {
            $url = $1;
        }

        return {key => $key, url => $url};
    } else {
        throw gettext('Cannot parse CAPTCHA XML:\n%s\n', $xml);
    }
}

sub check {
    my ($self, $key, $value, %opts) = @_;

    return FALSE unless defined($key) && defined($value);

    return $self->call('check', key => $key, rep => $value, hash_transform(\%opts, [qw(type)])) =~ />ok</i;
}

TRUE;
