package Exception::PI;
use base qw(Exception);

package QBit::Application::Model::API::Yandex::HTTPPI;

use qbit;

use base qw(QBit::Application::Model::API::HTTP);

=pod

    Параметр $state отвечает за вкл/выкл DSP на всех площадках РСЯ

    Если $state = TRUE, то включаем

    Если $state = FALSE, то выключаем

=cut

sub state_dsp_on_all_platforms {
    my ($self, $dsp_id, $state) = @_;

    throw Exception::BadArguments(gettext('Expected that DSP ID is defined')) unless defined($dsp_id);

    my $data = $self->call('api_pi2', dsp_id => $dsp_id, cmd => 'dsp_state_set', state => $state ? 'on' : 'off');

    my $result = from_json($data);

    throw Exception::PI $result->{'error'}{'msg'} if $result->{'error'};

    return $result;
}

TRUE;
