
=encoding UTF-8
=cut

=head1 Название

QBit::Application::Model::API::Yandex::Jira

=head1 Описание

На тестовом хосте https://jira.test.tools.yandex-team.ru для SOAP API используется нестандартный урл
https://jira.test.tools.yandex-team.ru/rpc/soap/jirasoapservice-v2-yandex вместо
https://jira.test.tools.yandex-team.ru/rpc/soap/jirasoapservice-v2

Модуль JIRA::Client, который мы используем, принимает только https://jira.test.tools.yandex-team.ru

Поэтому мы не можем его использовать на тестовом серваке не пропатчив.

При попытке авторизации по стандартному урлу, получаем ошибку "certificate verify failed".
Поддержка обещала это исправить, но не в ближайшее время...

Временное решение - на тестовом сервере, возвращем методом create_issue фэйковый ID тикета

=cut

package QBit::Application::Model::API::Yandex::Jira;

use qbit;

use base qw(QBit::Application::Model);

use JIRA::Client;

sub jira_client {
    my ($self) = @_;

    $self->{__JIRA__} =
      JIRA::Client->new($self->get_option('url'), $self->get_option('login'), $self->get_option('password'),)
      unless $self->{__JIRA__};

    return $self->{__JIRA__};
}

sub create_issue {
    my ($self, $issue_data) = @_;

    return $issue_data->{'project'} . '-' . int(rand(100500)) if $self->get_option('test');

    if (exists($issue_data->{cc}) && @{$issue_data->{cc}} > 0) {
        $issue_data->{customFieldValues} = SOAP::Data->type(
            ArrayOf_tns1_RemoteCustomFieldValue => [
                SOAP::Data->type(
                    RemoteCustomFieldValue => {
                        customfieldId => SOAP::Data->type(string             => 'customfield_10170'),
                        values        => SOAP::Data->type(ArrayOf_xsd_string => $issue_data->{cc}),
                    }
                ),
            ]
        );
        delete($issue_data->{cc});
    }

    my $issue = $self->jira_client->create_issue($issue_data);

    return $issue->{key};
}

TRUE;
