
=encoding UTF-8

=head1 Название

QBit::Application::Model::API::Yandex::MFAS - реализация API поисковой спамобороны.

=head1 Описание

Базовый класс: L<QBit::Application::Model::API::HTTP>

=cut

package QBit::Application::Model::API::Yandex::MFAS;

use qbit;

use base qw(QBit::Application::Model::API::HTTP);

__PACKAGE__->model_accessors(memcached => 'QBit::Application::Model::Memcached');

__PACKAGE__->register_rights(
    [
        {
            name        => 'mfas',
            description => sub {gettext('Rights for MFAS')},
            rights      => {mfas_get_domain_info => sub {gettext('Right to get info about domain from MFAS')},},
        }
    ]
);

=head1 Методы

=head2 check_verification

Возвращает информацию о домене

B<Параметры:>

$domain - строка, домен.

B<Возвращаемое значение:> указатель на хеш

=cut

sub get_info {
    my ($self, $domain) = @_;

    throw Exception::Denied unless $self->check_rights('mfas_get_domain_info');

    $domain = get_domain($domain, ascii => 1);
    my $data;

    unless ($data = $self->memcached->get('mfas' => $domain)) {
        $data = $self->call('get', h => $domain);
        $self->memcached->set('mfas' => $domain => $data, 60 * 60 * 24 * 5);
    }

    my %ths = map {my @t = split('=', $_); $t[0] => $t[1]} split("\n", $data);

    $ths{'name'} = get_domain($ths{'name'});
    $ths{$_} = $ths{$_} eq 'y' ? TRUE : FALSE foreach (qw(clickunder popunder yaca));

    my %class_names = (
        h => gettext('Not spam'),
        g => gettext('Suspicion of spam'),
        s => gettext('Spam'),
    );
    $ths{'class_name'} = $class_names{$ths{'class'}} // gettext('Unknown');

    return \%ths;
}

1;
