package Exception::API::SearchForSite;
use base qw(Exception::API);

=encoding UTF-8

=head1 Название

QBit::Application::Model::API::Yandex::SearchForSite - реализация API Яндекс.Поиск

=head1 Описание

Базовый класс: L<QBit::Application::Model::API::HTTP>

http://site.yandex.ru/
http://wiki.yandex-team.ru/JandeksPoisk/Jekosistema/PoiskPoSajjtu
http://wiki.yandex-team.ru/JandeksPoisk/Jekosistema/PoiskPoSajjtu/Razrabotka/SearchManager


NB: при логической ошибке API отдает 503 ошибку + тело сообщения со статусом ошибки

=cut

package QBit::Application::Model::API::Yandex::SearchForSite;

use qbit;

use base qw(QBit::Application::Model::API::HTTP);

use XML::Simple;

sub init {
    my $self = shift;
    $self->SUPER::init();
    $self->{xml_parser} = XML::Simple->new(ForceArray => [qw(error)]);
}

=head1 Методы

=head2 reserve_distrib_id

резервирует SEARCH_ID (для дистрибуции ППС)

B<Параметры:>

$user_id - id парнтера

$search_name - название поиска

$search_type - 'PPSD' | 'PPSDPLUS'

B<Возвращаемое значение:> $search_id - число

=cut

sub reserve_distrib_id {
    my ($self, $search_name, $user_id, $search_type) = @_;

    throw Exception::API::SearchForSite gettext("Wrong search_type [%s]", $search_type)
      unless in_array($search_type, ['PPSD', 'PPSDPLUS']);

    my $ret =
      $self->call('reserveDistribSearchId', name => $search_name, uid => $user_id, distribution_type => $search_type);
    my $sid = $self->_parse_result($ret)->{id};
    throw Exception::API::SearchForSite gettext('Api error. No id') unless $sid;
    return $sid;
}

=head2 reserve_id

резервирует SEARCH_ID (для дистрибуции - большой и мобильный поиск)

B<Параметры:>

$user_id - id парнтера

$search_name - название поиска

B<Возвращаемое значение:> $search_id - число

=cut

sub reserve_id {
    my ($self, $search_name, $user_id) = @_;

    my $ret = $self->call('reserveSearchId', name => $search_name, uid => $user_id);
    my $sid = $self->_parse_result($ret)->{id};
    throw Exception::API::SearchForSite gettext('Api error. No id') unless $sid;
    return $sid;
}

sub call {
    my ($self, $name, %opts) = @_;

    my $ret;
    try {
        $ret = $self->SUPER::call($name, %opts);
    }
    catch Exception::API::HTTP with {
        my ($ex) = @_;
        # при логической ошибка статус == 503 (обычно не обрабатывается)
        if ($ex->{response}->code() == 503 && $ex->{response}->content) {
            $ret = $ex->{response}->decoded_content();
        } else {
            throw Exception::API::HTTP $ex->{text};
        }
    };
    return $ret;
}

sub _parse_result {
    my ($self, $data, %opts) = @_;
    utf8::decode($data);
    my $hash;
    eval {$hash = $self->{xml_parser}->XMLin($data, %opts);};
    throw Exception::API::SearchForSite gettext('Transport. Bad XML data') if (!$hash || ref($hash) ne 'HASH');
    if (defined($hash->{errors})) {
        if (defined($hash->{errors}{error})) {
            if (ref($hash->{errors}{error}) eq '') {
                throw Exception::API::SearchForSite $hash->{errors}{error};
            } else {
                throw Exception::API::SearchForSite gettext(
                    'Logical error: %s - %s',
                    $hash->{errors}{error}->[0]->{code}->[1],
                    $hash->{errors}{error}->[0]->{message}
                );
            }
        } else {
            throw Exception::API::SearchForSite gettext('Unknown error');
        }
    }
    throw Exception::API::SearchForSite gettext('No search data') unless defined($hash->{'search'});
    throw Exception::API::SearchForSite gettext('Bad search data') unless ref($hash->{'search'}) eq 'HASH';

    return $hash->{'search'};
}

1;
