
=encoding UTF-8
=cut

=head1 Название

Application::Model::API::WebMaster - реализация API вебмастера

=head1 Описание

Базовый класс: L<QBit::Application::Model>

L<Документация|http://wiki.yandex-team.ru/JandeksPoisk/Interfejjsy/CentrVebmastera/dev/internal>


=head1 Исключения

=head2 Exception::API::WebMaster

Внутренняя ошибка вебмастера (фатальная ошибка. Не зависит от вызова.)

=cut

package Exception::API::WebMaster;

use base qw(Exception::API);

=head2 Exception::API::WebMaster::Logical

Логическая ошибка вебмастера (неверный парамтр, невозможноть операции для данных параметров итд)

=cut

package Exception::API::WebMaster::Logical;

use base qw(Exception::API::WebMaster);

=head1 Методы

=cut

package QBit::Application::Model::API::Yandex::WebMaster;

use qbit;

use base qw(QBit::Application::Model::API::HTTP);

=head2 check_verification

Проверяет принадлежность домена пользователю.

В дев. режиме может принимать всех подряд.

B<Параметры:>

$uid - число, юид пльзователя

$domain - строка, домен.

B<Возвращаемое значение:>

1(0) - если домен (не)принадлежит (подтвержден) пользователю

B<Исключения>

L<Exception::API::WebMaster> - в случае ошибки вебмастера

B<Пример ответа wmc>:

 <data servant="wmcviewer" version="1.0-618" host="wmconsole.dev.yandex.net" actions="[checkVerification]" executing-time="[3]">
   <verified>false</verified>
 </data>

=cut

sub check_verification {
    my ($self, $user_id, $domain) = @_;

    return 1 if $domain =~ /q-bit\.ru/;
    return $self->get_option('test') && rand(1) < $self->get_option('test_accept_all')
      if $self->get_option('test_accept_all');

    my $method = $self->get_option('methods')->{'check_verification'};
    my $res_raw = $self->call($method, uid => $user_id, hostname => $domain, use_main_mirror => 'True')
      || throw Exception::API::WebMaster gettext('No response from the service');

    return lc($1) eq 'true' if $res_raw && $res_raw =~ /<verified>(true|false)<\/verified>/is;

    throw Exception::API::WebMaster gettext('Incorrect response from the service');
}

=head2 add_domain

Оптравляет запрос в WMC на добавление домена пользователю. После этого пользователь на стороне WMC увидит этот домен в списке на подтверждение.

В случае неглавного зеркала добавляется главное.

B<Параметры:>

$uid - число, юид пльзователя

$domain - строка, домен.

B<Возвращаемое значение:>

в случае успеха - {} с данными
 {
    wmc_host_id => \d+,     # wmc_host_id (ид хоста на стороне wmc)
   [main_mirror => 'name',] # признак, что добавилось главное зеркало к запрошенному сайту
 }

в случае логической ошибки (хотс уже в очереди итд) присутвует ключ 'error'
 {
    wmc_host_id => undef,
    error   => {
        code => 'HOST_NOT_AVAILABLE', # [ HOST_NOT_AVAILABLE || HOST_ALREADY_ADDED ]
    }
 }

B<Исключения>

L<Exception::API::WebMaster> - в случае ошибки вебмастера

B<Пример ответа wmc>:

 <data servant="wmcviewer_ailyin_ailyin" version="0" host="wmconsole.dev.yandex.net" actions="[externalAddHost]" executing-time="[7]">
   <host id="88528">
     <name>krasmana.org</name>
   </host>
 </data>

 <data servant="wmcviewer_ailyin_ailyin" version="0" host="wmconsole.dev.yandex.net" actions="[externalAddHost]" executing-time="[28]">
   <errors>
     <error code="">
       <code>HOST_IS_MIRROR</code>
       <message>Host is a mirror of www.rbc.ru!</message>
       <alt>www.rbc.ru</alt>
       <exception>ru.yandex.wmtools.common.error.UserException: Host is a mirror of www.rbc.ru!</exception>
     </error>
   </errors>
 </data>

=cut

sub add_domain {
    my ($self, $uid, $domain) = @_;
    my @data = ();
    my $is_recursive = (caller(1))[3] eq __PACKAGE__ . '::add_domain';

    return $self->get_option('test') && rand(1) < $self->get_option('test_accept_all')
      if $self->get_option('test_accept_all');

    my $method = $self->get_option('methods')->{'add_domain'};
    my $res_raw = $self->call($method, uid => $uid, hostname => $domain)
      || throw Exception::API::WebMaster gettext('No response from the service');

    # add main mirror (recursive, only once)
    return $self->add_domain($uid, $1)
      if $res_raw =~ /<code>HOST_IS_MIRROR</is && $res_raw =~ /<alt>(.+?)<\/alt>/is && !$is_recursive;

    my $ret = {
        wmc_host_id     => undef,
        wmc_main_mirror => undef,
    };
    if ($res_raw =~ /host\s+id=['"](\d+)['"]/is) {

        # ok
        $ret->{wmc_host_id} = $1;
        $ret->{wmc_main_mirror} = $domain if ($is_recursive);
        return $ret;
    } elsif ($res_raw =~ /<code>(HOST_NOT_AVAILABLE|HOST_ALREADY_ADDED)<\/code>/is) {

        # error
        throw Exception::API::WebMaster::Logical $1;
    } else {

        # interntal error
        throw Exception::API::WebMaster gettext('Incorrect response from the service');
    }

}

1;
