package QBit::Application::Model::Yandex::CBB;

use qbit;

use base qw(QBit::Application::Model);

use LWP::UserAgent;
use LWP::Simple;
use Fcntl ':flock';
use Net::Patricia;
use Socket qw(AF_INET AF_INET6);
use Socket6 qw();

sub get_remote_change_dates {
    my ($self, @flags) = @_;

    my $dates = get('http://cbb.yandex.net/cgi-bin/check_flag.pl?flag=' . join(',', @flags))
      // throw gettext('Cannot get check_flag.pl');

    return split(',', $dates);
}

sub update {
    my ($self, @flags) = @_;

    my $filename = $self->get_option('filename') // throw gettext('Missed required parameter "filename" in config');

    my $need_update = TRUE;

    my $r_change_date;
    if (-e $filename) {
        $r_change_date = array_n_max($self->get_remote_change_dates(@flags));
        my ($mtime) = (stat($filename))[9];
        $need_update = $r_change_date > $mtime;
    }

    if ($need_update) {
        my $ua = LWP::UserAgent->new();

        my $response = $ua->get('http://cbb.yandex.net/cgi-bin/get_netblock.pl?flag=' . join(',', @flags),
            'Accept-Encoding' => 'gzip');

        throw gettext('Cannot get get_netblock.pl: %s', $response->status_line) unless $response->is_success();

        my $data = $response->decoded_content();

        if (open(my $fh, -e $filename ? "+<" : ">", $filename)) {
            flock($fh, LOCK_EX);
            truncate($fh, 0);
            seek($fh, 0, 0);
            print $fh $data;
            flock($fh, LOCK_UN);
            close($fh);

            utime(0, $r_change_date, $filename) if defined($r_change_date);
        } else {
            utf8::decode($!);
            throw gettext('Cannot open "%s": %s', $filename, $!);
        }
    }
}

sub check_ip_flag {
    my ($self, $ip, $flag) = @_;

    $self->timelog->start('Checking ip flag in CBB');

    $self->_load();

    my $ip_v = $self->_get_ip_version($ip) // return FALSE;

    my $res =
      exists($self->{'__PATRICIAS__'}{$flag}{$ip_v}) && !!$self->{'__PATRICIAS__'}{$flag}{$ip_v}->match_string($ip);
    $self->timelog->finish();

    return $res;
}

sub _load {
    my ($self) = @_;

    my $filename = $self->get_option('filename') // throw gettext('Missed required parameter "filename" in config');

    unless (-f $filename) {
        l gettext('CBB file "%s" does not exists', $filename);
        $self->{'__PATRICIAS__'} //= {};
        return;
    }

    my ($mtime) = (stat($filename))[9];

    return if ($self->{'__MTIME__'} || 0) >= $mtime;

    $self->{'__MTIME__'} = $mtime;

    if (open(my $fh, "<", $filename)) {
        $self->timelog->start('Loading CBB data') if $self->timelog;

        $self->{'__PATRICIAS__'} = {};

        flock($fh, LOCK_SH);

        while (my $str = <$fh>) {
            my ($ip, $mask, $flag) = split('; ', $str);

            next unless defined($ip) && defined($mask) && $mask =~ /^\d+$/ && defined($flag) && $flag =~ /^\d+$/;
            my $ip_v = $self->_get_ip_version($ip) || next;

            my $cur_patricia = $self->{'__PATRICIAS__'}{$flag}{$ip_v} //=
              Net::Patricia->new($ip_v == 4 ? AF_INET : AF_INET6);

            $cur_patricia->add($ip, $mask, TRUE);
        }

        flock($fh, LOCK_UN);
        close($fh);

        $self->timelog->finish() if $self->timelog;
    } else {
        utf8::decode($!);
        throw gettext('Cannot open "%s": %s', $filename, $!);
    }
}

sub _get_ip_version {
    my ($self, $ip) = @_;

    return defined(Socket::inet_aton($ip)) ? 4 : Socket6::inet_pton(AF_INET6, $ip) ? 6 : undef;
}

TRUE;
