package QBit::WebInterface::Controller::BEMHTML;

use qbit;

use base qw(QBit::WebInterface::Controller);

use JavaScript::V8;

use QBit::WebInterface::Controller::BEMHTML::Form;
use QBit::WebInterface::Controller::BEMHTML::Wizard;

my $V8Context;

sub MODIFY_CODE_ATTRIBUTES {
    my ($package, $sub, @attrs) = @_;

    my @unknown_attrs = ();

    foreach my $attr (@attrs) {
        if ($attr =~ /^WIZARDCMD$/) {
            $package->_register_cmd($sub, 'WIZARD', '_process_wizard');
        } else {
            push(@unknown_attrs, $attr);
        }
    }

    return $package->SUPER::MODIFY_CODE_ATTRIBUTES($sub, @unknown_attrs);
}

sub from_bem_template {
    my ($self, $template, %opts) = @_;

    my $bem_json = $self->_process_bem_template($template, %opts);

    if ($self->request->param('show_bem_json') || $opts{'show_bem_json'}) {
        return $self->as_json($self->_bemjson2data($$bem_json));
    }

    $self->_create_v8_context_if_required();

    $self->timelog->start(gettext('Generating HTML'));

    my $lang = $self->get_option('locale', '');

    my $html = $V8Context->{'bem'}->eval(
        qq{
            var lang = '$lang';
            if (lang) {BEM.I18N.lang(lang)};
            var BEMJSON_DATA = $$bem_json;
            BEMHTML.apply(BEMJSON_DATA);
        }
    );
    throw gettext("Error in BEMJSON: %s\n%s", $@, $$bem_json) if !defined($html);

    $self->timelog->finish();

    $self->response->data(\$html);

    return 1;
}

sub _create_v8_context_if_required {
    my ($self) = @_;

    my $template_path = $self->get_option('ApplicationPath') . '/common.priv.js';

    if (!exists($V8Context->{'bem'})
        || (defined($V8Context->{'bem_mtime'}) && $V8Context->{'bem_mtime'} < [stat($template_path)]->[9]))
    {
        $self->timelog->start(gettext('Creating V8 context'));

        $V8Context->{'bem'} = JavaScript::V8::Context->new();
        $V8Context->{'bem'}->bind(
            console => {
                log => sub {
                    grep {ref($_)} @_ ? ldump(@_) : l(@_);
                  }
            }
        );

        $V8Context->{'bem'}->eval(readfile($template_path));
        $V8Context->{'bem_mtime'} = [stat($template_path)]->[9];

        $self->timelog->finish;
    }
}

sub _process_bem_template {
    my ($self, $template, %opts) = @_;

    $self->timelog->start(gettext('Generating BEMJSON'));
    $self->{'FILTERS'}->{bem} = \&_bem_encode;
    my $bem_json = $self->_process_template($template, %opts, pre_process => ['common/page.bem.tt2'],);
    $self->timelog->finish();

    return $bem_json;
}

sub _process_form {
    my ($self, %opts) = @_;

    QBit::WebInterface::Controller::BEMHTML::Form->new(%opts, controller => $self)->process();
}

sub _process_wizard {
    my ($self, %opts) = @_;

    QBit::WebInterface::Controller::BEMHTML::Wizard->new(%opts, controller => $self)->process();
}

sub _bem_encode {
    for ($_[0]) {
        s/(['"\\])/\\$1/g;
        s/\r\n|[\r\n]/\\n/g;
    }
    return $_[0];
}

sub _bemjson2data {
    my ($self, $json) = @_;

    unless (exists($V8Context->{'small'})) {
        $V8Context->{'small'} = JavaScript::V8::Context->new();
    }

    $json =~ s/,\s*$//;
    my $data = $V8Context->{'small'}->eval("t = $json");
    throw gettext("Error in BEMJSON: %s\n%s", $@, $json) if !defined($data);

    return $data;
}

1;
