BEM.DOM.decl('b-form-input', {

    showError: function (text) {
        this.setMod('notification', 'error');

        this.showNotification(text);
    },

    showHint: function (text) {
        this.setMod('notification', 'hint');

        this.showNotification(text);
    },

    showNotification: function (text) {
        var _this = this;

        if (!this._error_popup) {
            this._error_popup = this.findBlockInside('notification', 'b-popupa');
        }

        if (text && this._error_popup) {
            this._error_popup.setContent(text);
        }

        if (this._error_popup) {
            this._error_popup.show(this.elem('input'));
        }

        this._form = this.findBlockOutside('b-form');

        this._onRedraw = function onRedraw () {
                if ( _this.hideError ) {
                    _this.hideError();
                }
            }

        if ( this._form != null ) {
            this._form.on( 'redraw', this._onRedraw );
        }

        if ( !this.hasMod( 'prevent-hide-notification-on-change', 'yes' ) ) {
            this.on( 'change', function onChange () {
                this.hideError();
                this.unbindFrom( this.elem('input'), 'change', onChange );
            });
        }
    },

    hideError: function() {
        if (this._error_popup) {
            this._error_popup.hide();
        }

        if ( this._form != null ) {
            this._form.un( 'redraw', this._onRedraw );
        }

        this.delMod('notification');
    },

    hideNotification: function () {
        return this.hideError();
    },

    hideHint: function () {
        return this.hideError();
    },

    destruct: function () {
        if (this._error_popup) {
            this._error_popup.destruct();
        }
        this.__base.apply(this, arguments);
    }

});
