/*jslint bitwise: true, plusplus: true, nomen:true*/
/*globals jQuery, BEM*/

(function (BEM, $, undefined) {
    'use strict';

    BEM.DOM.decl({block: 'b-form-input', modName: 'pattern', modVal: 'yes'}, {
        onSetMod: {
            js: function () {
                this.__base.apply(this, arguments);
                this.validate = $.proxy(this.validate, this);
                this._pattern = new RegExp(this.params.pattern);
                this.on('change', this.validate);
            },

            disabled: function (modName, modVal) {
                this.__base.apply(this, arguments);
                if (modVal === 'yes') {
                    this._clearError();
                } else {
                    this.validate();
                }
            }
        },

        isValid: function () {
            return this._pattern.test(this.val());
        },

        validate: function () {
            if (this.isValid() || this.hasMod('disabled', 'yes')) {
                this._clearError();
            } else {
                this._setError(this.params.errorMsg || '');
            }
        },

        _setError: function (errorMsg) {
            this.setMod('error', 'yes');
            this.showError(errorMsg);
        },

        _clearError: function () {
            this.delMod('error');
            this.hideError();
        }
    });

})(BEM, jQuery);
