/**
 * This block shows several b-form-input block to allow you
 * to edit all translates at the same time.
 **/
(function () {

    function isEqual(a, b) {
        if (typeof a === typeof b) {
            return a === b;
        }
        if (typeof a === 'number' || typeof b === 'number') {
            return Number(a) === Number(b);
        }
        return false;
    }

    /**
     * @param {array:b-form-input} bFormInput
     **/
    function Inputs(bFormInputList) {
        // {array:b-form-input}
        this._bFormInputList = bFormInputList || [];
        // {object}
        this._value = this._getValue();

        if (!$.isArray(this._bFormInputList)) {
            this._bFormInputList = [this._bFormInputList];
        }
    }

    /**
     * @param {string} [value] - {name.en, name.ru}
     **/
    Inputs.prototype.val = function (value) {
        if (value !== undefined && value !== 'undefined') {
            this._setValue(value);
        } else {
            return this._getValue();
        }
    };

    Inputs.prototype.trim = function () {
        this._bFormInputList.forEach(function (input) {
            input.val($.trim(input.val()));
        });
    };

    /**
     * @return {string}
     **/
    Inputs.prototype.displayVal = function (name) {
        return this._getValue()[name];
    };

    Inputs.prototype.focus = function () {
        var bFormInput = this._bFormInputList[0];
        if (bFormInput) {
            bFormInput.setMod('focused', 'yes');
        }
    };

    /**
     * @param {boolean} idDisabled
     **/
    Inputs.prototype.setDisabled = function (isDisabled) {
        function disable(block) {
            if (isDisabled) {
                block.setMod('disabled', 'yes');
            } else {
                block.delMod('disabled');
            }
        }
        this._bFormInputList.forEach(disable);
    };

    /**
     * @param {object} value - {name.en, name.ru}
     **/
    Inputs.prototype._setValue = function (value) {
        function setValue(block) {
            block.val(value[block.name()]);
        }
        this._bFormInputList.forEach(setValue);
    };

    /**
     * @return {object}
     **/
    Inputs.prototype._getValue = function () {
        function getValue(value, block) {
            value[block.name()] = block.val();
            return value;
        }

        return this._bFormInputList.reduce(getValue, {});
    };

    // block
    BEM.DOM.decl('b-form-multilang', {
        onSetMod: {
            js: function () {
                this._initBlock();
            },
            disabled: {
                yes: function () {
                    if (this._inputs) {
                        this._inputs.setDisabled(true);
                    }
                },

                '': function () {
                    if (this._inputs) {
                        this._inputs.setDisabled(false);
                    }
                }
            }
        },

        /**
         * Set or get value
         *
         * @param {string} [value]
         * @return {string|undefined} - undefined if something was passed
         **/
        val: function (value) {
            return this._inputs.val(value);
        },

        trim: function () {
            return this._inputs.trim();
        },

        /**
         * Return name
         *
         * @return {string}
         **/
        name: function () {
            return this.domElem.attr('data-name');
        },

        /**
         * Return text of the selected option
         *
         * @return {string}
         **/
        displayVal: function () {
            return this._inputs.displayVal(this._getLocaleName());
        },

        /**
         * @param {string} [locale] - en|ru|...
         **/
        _getLocaleName: function (locale) {
            locale = locale || this.params.currentLocale;
            return this.name() + '.' + locale;
        },

        _initBlock: function () {
            var bFormInputList = this.findBlocksOn('item', 'b-form-input');
            this._inputs = new Inputs(bFormInputList);
            this.afterCurrentEvent(this._inputs.focus, this._inputs);
        }
    });
})();
