package ru.yandex.direct.api.v5;

import java.util.Locale;

import com.google.common.collect.ImmutableSet;

public final class ApiConstants {
    public static final Locale DEFAULT_LOCALE = new Locale("en");
    public static final ImmutableSet<Locale> SUPPORTED_LOCALES = ImmutableSet.of(
            DEFAULT_LOCALE,
            new Locale("ru"),
            new Locale("tr"),
            new Locale("uk"));

    // множитель для денег, для выдачи в API в целых единицах
    public static final long MONEY_MULTIPLIER = 1_000_000;
    // показатель степени десяти для масшабирования денег для получения из API в целых единицах
    public static final int MONEY_SCALE = 6;

    private ApiConstants() {
    }
}
