package ru.yandex.direct.api.v5;

import java.io.Serializable;

import ru.yandex.direct.i18n.I18NBundle;
import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.i18n.bundle.MessageFormatStub;
import ru.yandex.direct.i18n.bundle.TranslationBundle;
import ru.yandex.direct.i18n.bundle.TranslationStub;

public interface ApiFaultTranslations extends TranslationBundle, Serializable {

    ApiFaultTranslations INSTANCE = I18NBundle.implement(ApiFaultTranslations.class);

    @TranslationStub("Сервис временно недоступен")
    Translatable serviceUnavailable();

    @TranslationStub("Ошибка инициализации сервиса")
    Translatable serviceInitializationError();

    @TranslationStub("OAuth-токен не указан")
    Translatable absentOauthToken();

    @TranslationStub("Неверный формат OAuth-токена")
    Translatable invalidOauthTokenFormat();

    @TranslationStub("Недействительный OAuth-токен")
    Translatable expiredOauthToken();

    @TranslationStub("Ошибка авторизации")
    Translatable badCredentials();

    @TranslationStub("Незавершенная регистрация")
    Translatable noRegistration();

    @TranslationStub("Сервер авторизации временно недоступен")
    Translatable authenticationServiceUnavailable();

    @TranslationStub("В HTTP-заголовке Client-Login необходимо указать логин рекламодателя")
    Translatable notClientInClientLogin();

    @TranslationStub("В HTTP-заголовке Client-Login указан несуществующий логин")
    Translatable unknownLoginInClientLogin();

    @TranslationStub("В HTTP-заголовке Fake-Login указан несуществующий логин")
    Translatable unknownLoginInFakeLogin();

    @TranslationStub("Превышено ограничение на количество соединений")
    Translatable concurrentConnectionsLimitExceeded();

    @TranslationStub("Превышен лимит запросов метода")
    Translatable rateLimitExceeded();

    @TranslationStub("Недостаточно баллов")
    Translatable notEnoughUnits();

    @TranslationStub("Недостаточно баллов для выполнения операции")
    Translatable notEnoughUnitsDetailed();

    @TranslationStub("Некорректный запрос")
    Translatable incorrectRequest();

    @MessageFormatStub("Неверный формат запроса")
    Translatable detailedIncorrectRequestFormat();

    @TranslationStub("Операция не найдена")
    Translatable operationNotFound();

    @TranslationStub("Токен не найден")
    Translatable detailedTokenNotFound();

    @TranslationStub("Пользователь с указанным Fake-логином не найден")
    Translatable detailedFakeUserNotFound();

    @TranslationStub("Доступ блокирован")
    Translatable detailedAccessBlocked();

    @TranslationStub("Аккаунт пользователя блокирован")
    Translatable detailedAccountBlocked();

    @TranslationStub("Ваш логин не подключен к Яндекс.Директу")
    Translatable userUnknown();

    @TranslationStub("Необходимо заполнить для приложения заявку на доступ " +
            "в интерфейсе Директа и дождаться её подтверждения")
    Translatable detailedNoRegistration();

    @TranslationStub("Client-Login не соответствует авторизационному токену")
    Translatable detailedTokenNotMatchToLogin();

    @TranslationStub("Необходимо указать Client-Login")
    Translatable detailedClientLoginRequred();

    @TranslationStub("Client-Login не должен быть указан для запроса в агентский сервис")
    Translatable detailedClientLoginNotEmpty();

    @TranslationStub("Client-Login должен быть логином клиента или субклиента")
    Translatable detailedLoginIsNotClient();

    @TranslationStub("Client-Login должен быть логином агентства")
    Translatable detailedLoginIsNotAgency();

    @TranslationStub("Нет доступа к API")
    Translatable accessToApiDenied();

    @TranslationStub("Нет прав на указанного пользователя")
    Translatable detailedNoRightsForUser();

    @TranslationStub("Нет прав на указанного клиента")
    Translatable detailedNoRightsForClient();

    @TranslationStub("Нет прав для доступа в агентский сервис")
    Translatable detailedNoRightsForAgencyService();

    @TranslationStub("Невозможно обработать JSON/XML")
    Translatable detailedUnableToParse();

    @TranslationStub("Указано неверное значение ключа method при запросе "
            + "в формате JSON или некорректный SOAPAction")
    Translatable detailedIncorrectOperation();

    @MessageFormatStub("Указан неизвестный параметр {0}")
    Translatable detailedUnknownParameter(String path);

    @MessageFormatStub("Элемент массива {0} содержит неизвестный параметр {1}")
    Translatable detailedUnknownParameterInArray(String arrayPath, String field);

    @MessageFormatStub("Массив {0} содержит null")
    Translatable detailedArrayContainsNull(String arrayPath);

    @MessageFormatStub("Неправильный тип {0}, ожидается {1}")
    Translatable detailedInvalidFormat(String path, String targetType);

    @MessageFormatStub("{0} должен содержать целочисленное значение")
    Translatable detailedInvalidFormatExpectedInteger(String path);

    @MessageFormatStub("Элемент массива {0} должен содержать целочисленное значение")
    Translatable detailedInvalidFormatExpectedIntegerInArray(String path);

    @MessageFormatStub("{0} должен содержать строку")
    Translatable detailedInvalidFormatExpectedString(String path);

    @MessageFormatStub("Элемент массива {0} должен содержать строку")
    Translatable detailedInvalidFormatExpectedStringInArray(String path);

    @MessageFormatStub("{0} содержит неверное значение перечисления, ожидается одно из значений: {1}")
    Translatable detailedInvalidFormatExpectedEnum(String path, String values);

    @MessageFormatStub("Элемент массива {0} содержит неверное значение перечисления, ожидается одно из значений: {1}")
    Translatable detailedInvalidFormatExpectedEnumInArray(String arrayPath, String values);

    @MessageFormatStub("Некорректное значение для {0}")
    Translatable detailedIncorrectValue(String path);

    @MessageFormatStub("{0} не может иметь значение null")
    Translatable detailedMustNotBeNull(String path);

    @MessageFormatStub("{0} должен содержать массив")
    Translatable detailedIncorrectValueFieldShouldBeArray(String path);

    @MessageFormatStub("{0} не может содержать массив")
    Translatable detailedIncorrectValueFieldShouldNotBeArray(String path);

    @MessageFormatStub("Отсутствует обязательное поле {0}")
    Translatable detailedMissingValueOrNull(String path);

    @MessageFormatStub("Отсутствует обязательный параметр {0}")
    Translatable detailedMissingParameter(String parameterName);

    @MessageFormatStub("В элементе массива {0} отсутствует обязательное поле {1}")
    Translatable detailedMissingValueOrNullInArray(String arrayPath, String fieldName);

    @MessageFormatStub("Количество элементов в массиве {0} должно быть не менее {1}")
    Translatable detailedInvalidMinSize(String path, int min);

    @MessageFormatStub("Количество элементов в массиве {0} должно быть не более {1}")
    Translatable detailedInvalidMaxSize(String path, int max);

    @MessageFormatStub("Количество элементов в массиве {0} должно быть не менее {1} и не более {2}")
    Translatable detailedInvalidSize(String path, int min, int max);

    @TranslationStub("Отсутствуют обязательные параметры для запроса")
    Translatable requiredParamsMissed();

    @TranslationStub("Доступ к API закрыт на время перевода кампаний в валюту")
    Translatable clientConvertingToCurrencySoon();

    @TranslationStub("Доступ к API закрыт до конвертации в валюту")
    Translatable clientHasToConvertToCurrency();

    @TranslationStub("Использование HTTP-заголовка Use-Operator-Units доступно только агентствам")
    Translatable detailedClientMustBeAnAgencyToUseOperatorUnits();

    @TranslationStub("Некорректное содержимое заголовка Authorization")
    Translatable detailedIncorrectAuthorizationHeader();

    @MessageFormatStub("Поддерживаются только следующие значения для поля {0}: {1}")
    Translatable detailedUnsupportedFieldValues(String field, String allowedValues);

    @MessageFormatStub("В параметре {0} должна быть указана дата в формате YYYY-MM-DDThh:mm:ssZ")
    Translatable detailedInvalidDateFormat(String field);

    @MessageFormatStub("В параметре {0} должна быть указана корректная дата")
    Translatable detailedIncorrectDate(String field);

    @TranslationStub("Пользователь запретил доступ с данного IP-адреса")
    Translatable accessToApiDeniedNotAllowedIpAddress();

    @TranslationStub("Доступ к API закрыт на время перевода кампаний в валюту")
    Translatable accessToApiDeniedWhileConvertingCurrency();

    @TranslationStub("Доступ для пользователей услуги Настройка Яндекс.Директа запрещен")
    Translatable accessToApiDeniedForYaAgency();
}
