package ru.yandex.direct.api.v5;

import java.util.Locale;

import org.slf4j.Logger;

import ru.yandex.direct.common.jetty.JettyConfig;
import ru.yandex.direct.common.jetty.JettyLauncher;
import ru.yandex.direct.config.DirectConfig;
import ru.yandex.direct.config.DirectConfigFactory;
import ru.yandex.direct.jcommander.ParserWithHelp;
import ru.yandex.direct.logging.LoggingInitializer;
import ru.yandex.direct.logging.LoggingInitializerParams;

import static ru.yandex.direct.api.v5.ApiConstants.DEFAULT_LOCALE;

public class YandexDirectApiV5Application {
    private static final Logger logger = LoggingInitializer.getLogger(YandexDirectApiV5Application.class);

    public static void main(String[] args) throws Exception {
        Locale.setDefault(DEFAULT_LOCALE);
        LoggingInitializerParams loggingParams = new LoggingInitializerParams();
        ParserWithHelp.parse(YandexDirectApiV5Application.class.getCanonicalName(), args, loggingParams);
        LoggingInitializer.initialize(loggingParams, "direct.api5");

        DirectConfig conf = DirectConfigFactory.getConfig();

        JettyConfig jettyConfig = new JettyConfig(conf.getBranch("jetty"));

        logger.info("start jetty server with config: {}", jettyConfig);

        JettyLauncher.server(jettyConfig)
                .withDefaultWebApp(YandexDirectApiV5Application.class.getClassLoader(), "")
                .run();
    }
}
