package ru.yandex.direct.api.v5.common;

import java.util.Map;

import com.google.common.collect.ImmutableMap;
import com.yandex.direct.api.v5.adextensiontypes.AdExtensionSetting;
import com.yandex.direct.api.v5.adextensiontypes.AdExtensionSettingItem;
import com.yandex.direct.api.v5.ads.TextAdUpdateBase;
import com.yandex.direct.api.v5.dynamicfeedadtargets.DynamicFeedAdTargetAddItem;
import com.yandex.direct.api.v5.keywordsresearch.DeduplicateRequestItem;
import com.yandex.direct.api.v5.promotedcontent.PromotedContentAddItem;

import ru.yandex.direct.core.entity.addition.callout.model.Callout;
import ru.yandex.direct.core.entity.banner.model.BannerWithBannerImage;
import ru.yandex.direct.core.entity.banner.model.BannerWithButton;
import ru.yandex.direct.core.entity.banner.model.BannerWithHref;
import ru.yandex.direct.core.entity.banner.model.BannerWithLogo;
import ru.yandex.direct.core.entity.banner.model.BannerWithMobileContent;
import ru.yandex.direct.core.entity.banner.model.BannerWithPixels;
import ru.yandex.direct.core.entity.banner.model.BannerWithSystemFields;
import ru.yandex.direct.core.entity.banner.model.ContentPromotionBanner;
import ru.yandex.direct.core.entity.banner.model.ImageBanner;
import ru.yandex.direct.core.entity.banner.model.TextBanner;
import ru.yandex.direct.core.entity.bids.container.SetAutoBidItem;
import ru.yandex.direct.core.entity.bids.container.SetAutoNetworkByCoverage;
import ru.yandex.direct.core.entity.bids.container.SetAutoSearchByPosition;
import ru.yandex.direct.core.entity.bids.container.SetAutoSearchByTrafficVolume;
import ru.yandex.direct.core.entity.bids.container.SetBidItem;
import ru.yandex.direct.core.entity.campaign.model.BroadMatch;
import ru.yandex.direct.core.entity.campaign.model.CommonCampaign;
import ru.yandex.direct.core.entity.campaign.model.CpmBannerCampaign;
import ru.yandex.direct.core.entity.campaign.model.DbStrategy;
import ru.yandex.direct.core.entity.campaign.model.MeaningfulGoal;
import ru.yandex.direct.core.entity.campaign.model.StrategyData;
import ru.yandex.direct.core.entity.campaign.model.TextCampaign;
import ru.yandex.direct.core.entity.client.model.AddAgencyClientRequest;
import ru.yandex.direct.core.entity.creative.model.Creative;
import ru.yandex.direct.core.entity.dynamictextadtarget.model.DynamicFeedAdTarget;
import ru.yandex.direct.core.entity.dynamictextadtarget.model.DynamicFeedRule;
import ru.yandex.direct.core.entity.dynamictextadtarget.model.DynamicTextAdTarget;
import ru.yandex.direct.core.entity.dynamictextadtarget.model.WebpageRule;
import ru.yandex.direct.core.entity.feed.model.Feed;
import ru.yandex.direct.core.entity.minuskeywordspack.model.MinusKeywordsPack;
import ru.yandex.direct.core.entity.performancefilter.model.PerformanceFilter;
import ru.yandex.direct.core.entity.performancefilter.model.PerformanceFilterCondition;
import ru.yandex.direct.core.entity.retargeting.container.RetargetingSelection;
import ru.yandex.direct.core.entity.retargeting.model.Goal;
import ru.yandex.direct.core.entity.retargeting.model.RetargetingCondition;
import ru.yandex.direct.core.entity.retargeting.model.Rule;
import ru.yandex.direct.core.entity.retargeting.model.TargetInterest;
import ru.yandex.direct.core.entity.strategy.model.AutobudgetRoi;
import ru.yandex.direct.core.entity.time.model.TimeInterval;
import ru.yandex.direct.core.entity.user.model.User;
import ru.yandex.direct.organizations.swagger.OrganizationInfo;
import ru.yandex.direct.validation.result.MappingPathConverter;
import ru.yandex.direct.validation.result.PathConverter;

import static com.yandex.direct.api.v5.dynamictextadtargets.WebpageAddItem.PropInfo.CONDITIONS;
import static ru.yandex.direct.api.v5.entity.keywordsresearch.delegate.HasSearchVolumeDelegate.KEYWORDS_KEY;
import static ru.yandex.direct.api.v5.entity.keywordsresearch.delegate.HasSearchVolumeDelegate.REGIONIDS_KEY;
import static ru.yandex.direct.core.entity.banner.type.href.BannerWithHrefUtils.FIELD_TRACKING_URL;

public class ApiPathConverter {
    private static final Map<String, String> commonDict = ImmutableMap.of(
            "ids", "SelectionCriteria.Ids",
            "limit", "Page.Limit",
            "offset", "Page.Offset");

    private static final Map<String, String> bannerPriceDict = ImmutableMap.of(
            "price", "Price",
            "priceOld", "OldPrice",
            "currency", "PriceCurrency",
            "prefix", "PriceQualifier"
    );

    private static final PathConverter RETARGETING_LISTS_PATH_CONVERTER;
    private static final PathConverter AUDIENCE_TARGETS_PATH_CONVERTER;
    private static final PathConverter DYNAMIC_TEXT_AD_TARGETS_PATH_CONVERTER;
    private static final PathConverter DYNAMIC_FEED_AD_TARGETS_PATH_CONVERTER;
    private static final PathConverter DYNAMIC_FEED_AD_TARGETS_SET_BIDS_PATH_CONVERTER;
    private static final PathConverter KEYWORDS_RESEARCH_PATH_CONVERTER;
    private static final PathConverter BIDS_SET_PATH_CONVERTER;
    private static final PathConverter CREATIVES_PATH_CONVERTER;
    private static final PathConverter KEYWORD_BIDS_SET_PATH_CONVERTER;
    private static final PathConverter BIDS_SET_AUTO_PATH_CONVERTER;
    private static final PathConverter KEYWORD_BIDS_SET_AUTO_PATH_CONVERTER;
    private static final PathConverter CLIENTS_UPDATE_PATH_CONVERTER;
    private static final PathConverter AGENCY_CLIENTS_ADD_PATH_CONVERTER;
    private static final PathConverter AD_EXTENSIONS_PATH_CONVERTER;
    private static final PathConverter ADS_PATH_CONVERTER;
    private static final PathConverter CAMPAIGNS_PATH_CONVERTER;
    private static final PathConverter CAMPAIGNS_EXT_PATH_CONVERTER;
    private static final PathConverter NEGATIVE_KEYWORD_SHARED_SETS_PATH_CONVERTER;
    private static final PathConverter BUSINESSES_PATH_CONVERTER;
    private static final PathConverter SMARTADTARGETS_PATH_CONVERTER;
    private static final PathConverter SMARTADTARGETS_SET_BIDS_PATH_CONVERTER;
    private static final PathConverter PROMOTED_CONTENT_PATH_CONVERTER;
    private static final PathConverter FEEDS_PATH_CONVERTER;
    private static final PathConverter AD_VIDEOS_PATH_CONVERTER;

    static {
        RETARGETING_LISTS_PATH_CONVERTER =
                MappingPathConverter.builder(ApiPathConverter.class, "RetargetingLists")
                        .add(commonDict)
                        .add("retargetingConditions", "RetargetingLists")
                        .add(RetargetingCondition.NAME.name(), "Name")
                        .add(RetargetingCondition.DESCRIPTION.name(), "Description")
                        .add(RetargetingCondition.RULES.name(), "Rules")
                        .add(Rule.GOALS.name(), "Arguments")
                        .add(Rule.TYPE.name(), "Operator")
                        .add(Goal.ID.name(), "ExternalId")
                        .add(Goal.TIME.name(), "MembershipLifeSpan")
                        .add(Goal.UNION_WITH_ID.name(), "UnionWithExternalId")
                        .build();

        AUDIENCE_TARGETS_PATH_CONVERTER =
                MappingPathConverter.builder(ApiPathConverter.class, "AudienceTargets")
                        .add(commonDict)
                        .add(TargetInterest.AD_GROUP_ID.name(), "AdGroupId")
                        .add(TargetInterest.ID.name(), "Id")
                        .add(TargetInterest.PRICE_CONTEXT.name(), "ContextBid")
                        .add(TargetInterest.AUTOBUDGET_PRIORITY.name(), "StrategyPriority")
                        .add(TargetInterest.RETARGETING_CONDITION_ID.name(), "RetargetingListId")
                        .add(TargetInterest.INTEREST_ID.name(), "InterestId")
                        .add(RetargetingSelection.ADGROUP_IDS.name(), "SelectionCriteria.AdGroupIds")
                        .add(RetargetingSelection.CAMPAIGN_IDS.name(), "SelectionCriteria.CampaignIds")
                        .add(RetargetingSelection.RETARGETING_LIST_IDS.name(), "SelectionCriteria.RetargetingListIds")
                        .add(RetargetingSelection.INTEREST_IDS.name(), "SelectionCriteria.InterestIds")
                        .add(SetBidItem.CAMPAIGN_ID.name(), "CampaignId")
                        .build();

        DYNAMIC_TEXT_AD_TARGETS_PATH_CONVERTER =
                MappingPathConverter.builder(ApiPathConverter.class, "DynamicTextAdTargets")
                        .add(commonDict)
                        .add(DynamicTextAdTarget.ID.name(), "Id")
                        .add(DynamicTextAdTarget.CAMPAIGN_ID.name(), "CampaignId")
                        .add(DynamicTextAdTarget.AD_GROUP_ID.name(), "AdGroupId")
                        .add(DynamicTextAdTarget.PRICE.name(), "Bid")
                        .add(DynamicTextAdTarget.CONDITION.name(), "Condition")
                        .add(DynamicTextAdTarget.CONDITION_NAME.name(), "Name")
                        .add(WebpageRule.KIND.name(), "Kind")
                        .add(WebpageRule.TYPE.name(), "Type")
                        .add(WebpageRule.VALUE.name(), "Value")
                        .add(CONDITIONS.propertyName, "Conditions")
                        .add(SetBidItem.PRICE_SEARCH.name(), "Bid")
                        .add(SetBidItem.PRICE_CONTEXT.name(), "ContextBid")
                        .add(SetBidItem.AUTOBUDGET_PRIORITY.name(), "StrategyPriority")
                        .build();

        DYNAMIC_FEED_AD_TARGETS_PATH_CONVERTER =
                MappingPathConverter.builder(ApiPathConverter.class, "DynamicFeedAdTargets")
                        .add(commonDict)
                        .add(DynamicFeedAdTarget.ID.name(), "Id")
                        .add(DynamicFeedAdTarget.CAMPAIGN_ID.name(), "CampaignId")
                        .add(DynamicFeedAdTarget.AD_GROUP_ID.name(), "AdGroupId")
                        .add(DynamicFeedAdTarget.PRICE.name(), "Bid")
                        .add(DynamicFeedAdTarget.PRICE_CONTEXT.name(), "ContextBid")
                        .add(DynamicFeedAdTarget.CONDITION.name(), "Condition")
                        .add(DynamicFeedAdTarget.CONDITION_NAME.name(), "Name")
                        .add(DynamicFeedRule.PARSED_VALUE, "Arguments")
                        .add(DynamicFeedRule.STRING_VALUE.name(), "Arguments")
                        .add(DynamicFeedRule.OPERATOR.name(), "Operator")
                        .add(DynamicFeedRule.FIELD_NAME.name(), "Operand")
                        .add(DynamicFeedAdTargetAddItem.PropInfo.CONDITIONS.propertyName, "Conditions")
                        .build();

        DYNAMIC_FEED_AD_TARGETS_SET_BIDS_PATH_CONVERTER =
                MappingPathConverter.builder(ApiPathConverter.class, "DynamicFeedAdTargetsSetBids")
                        .add(commonDict)
                        .add(SetBidItem.ID.name(), "Id")
                        .add(SetBidItem.AD_GROUP_ID.name(), "AdGroupId")
                        .add(SetBidItem.CAMPAIGN_ID.name(), "CampaignId")
                        .add(SetBidItem.PRICE_SEARCH.name(), "Bid")
                        .add(SetBidItem.PRICE_CONTEXT.name(), "ContextBid")
                        .build();

        KEYWORDS_RESEARCH_PATH_CONVERTER =
                MappingPathConverter.builder(ApiPathConverter.class, "KeywordsResearch")
                        .add(commonDict)
                        .add(KEYWORDS_KEY, KEYWORDS_KEY)
                        .add(REGIONIDS_KEY, REGIONIDS_KEY)
                        .add(DeduplicateRequestItem.PropInfo.ID.propertyName,
                                DeduplicateRequestItem.PropInfo.ID.schemaName.getLocalPart())
                        .add(DeduplicateRequestItem.PropInfo.KEYWORD.propertyName,
                                DeduplicateRequestItem.PropInfo.KEYWORD.schemaName.getLocalPart())
                        .add(DeduplicateRequestItem.PropInfo.WEIGHT.propertyName,
                                DeduplicateRequestItem.PropInfo.WEIGHT.schemaName.getLocalPart())
                        .build();

        CLIENTS_UPDATE_PATH_CONVERTER =
                MappingPathConverter.builder(ApiPathConverter.class, "ClientsUpdate")
                        .add(User.EMAIL.name(), "Notification.Email")
                        .add(User.PHONE.name(), "Phone")
                        .add(User.FIO.name(), "ClientInfo")
                        .build();

        AGENCY_CLIENTS_ADD_PATH_CONVERTER =
                MappingPathConverter.builder(ApiPathConverter.class, "AgencyClientsAdd")
                        .add(AddAgencyClientRequest.LOGIN.name(), "Login")
                        .add(AddAgencyClientRequest.FIRST_NAME.name(), "FirstName")
                        .add(AddAgencyClientRequest.LAST_NAME.name(), "LastName")
                        .add(AddAgencyClientRequest.NOTIFICATION_EMAIL.name(), "Notification.Email")
                        .add(AddAgencyClientRequest.CURRENCY.name(), "Currency")
                        .add(AddAgencyClientRequest.ALLOW_IMPORT_XLS.name(), "Grants.IMPORT_XLS")
                        .add(AddAgencyClientRequest.ALLOW_EDIT_CAMPAIGNS.name(), "Grants.EDIT_CAMPAIGNS")
                        .add(AddAgencyClientRequest.ALLOW_TRANSFER_MONEY.name(), "Grants.TRANSFER_MONEY")
                        .add(AddAgencyClientRequest.SHARED_ACCOUNT_ENABLED.name(), "Settings.SHARED_ACCOUNT_ENABLED")
                        .build();

        BIDS_SET_PATH_CONVERTER = MappingPathConverter.builder(ApiPathConverter.class, "BidsSet")
                .add(commonDict)
                .add(SetBidItem.ID.name(), "KeywordId")
                .add(SetBidItem.AD_GROUP_ID.name(), "AdGroupId")
                .add(SetBidItem.CAMPAIGN_ID.name(), "CampaignId")
                .add(SetBidItem.PRICE_SEARCH.name(), "Bid")
                .add(SetBidItem.PRICE_CONTEXT.name(), "ContextBid")
                .add(SetBidItem.AUTOBUDGET_PRIORITY.name(), "StrategyPriority")
                .build();

        CREATIVES_PATH_CONVERTER = MappingPathConverter.builder(ApiPathConverter.class, "Creatives")
                .add(commonDict)
                .add(Creative.ID.name(), "Id")
                .add(Creative.NAME.name(), "Name")
                .add(Creative.TYPE.name(), "Type")
                .add(Creative.PREVIEW_URL.name(), "PreviewUrl")
                .add(Creative.WIDTH.name(), "Width")
                .add(Creative.HEIGHT.name(), "Height")
                .add(Creative.LIVE_PREVIEW_URL.name(), "ThumbnailUrl")
                .build();

        KEYWORD_BIDS_SET_PATH_CONVERTER = MappingPathConverter.builder(ApiPathConverter.class, "BidsSet")
                .add(commonDict)
                .add(SetBidItem.ID.name(), "KeywordId")
                .add(SetBidItem.AD_GROUP_ID.name(), "AdGroupId")
                .add(SetBidItem.CAMPAIGN_ID.name(), "CampaignId")
                .add(SetBidItem.PRICE_SEARCH.name(), "SearchBid")
                .add(SetBidItem.PRICE_CONTEXT.name(), "NetworkBid")
                .add(SetBidItem.AUTOBUDGET_PRIORITY.name(), "StrategyPriority")
                .build();

        BIDS_SET_AUTO_PATH_CONVERTER = MappingPathConverter.builder(ApiPathConverter.class, "BidsSetAuto")
                .add(commonDict)
                .add(SetAutoBidItem.ID.name(), "KeywordId")
                .add(SetAutoBidItem.AD_GROUP_ID.name(), "AdGroupId")
                .add(SetAutoBidItem.CAMPAIGN_ID.name(), "CampaignId")
                .ignore(SetAutoBidItem.SEARCH_BY_POSITION.name())
                .ignore(SetAutoBidItem.NETWORK_BY_COVERAGE.name())
                .add(SetAutoSearchByPosition.POSITION.name(), "Position")
                .add(SetAutoSearchByPosition.INCREASE_PERCENT.name(), "IncreasePercent")
                .add(SetAutoSearchByPosition.CALCULATED_BY.name(), "CalculatedBy")
                .add(SetAutoSearchByPosition.MAX_BID.name(), "MaxBid")
                .add(SetAutoNetworkByCoverage.CONTEXT_COVERAGE.name(), "ContextCoverage")
                // тут нет SetAutoNetworkByCoverage.INCREASE_PERCENT и SetAutoNetworkByCoverage.MAX_BID,
                // потому что "increasePercent" и "maxBid" уже есть от SetAutoSearchByPosition
                .add(SetAutoBidItem.SCOPE.name(), "Scope")
                .build();

        KEYWORD_BIDS_SET_AUTO_PATH_CONVERTER = MappingPathConverter.builder(ApiPathConverter.class, "BidsSetAuto")
                .add(commonDict)
                .add(SetAutoBidItem.ID.name(), "KeywordId")
                .add(SetAutoBidItem.AD_GROUP_ID.name(), "AdGroupId")
                .add(SetAutoBidItem.CAMPAIGN_ID.name(), "CampaignId")
                .add(SetAutoBidItem.SCOPE.name(), "BiddingRule")
                .add(SetAutoBidItem.SEARCH_BY_TRAFFIC_VOLUME.name(), "BiddingRule.SearchByTrafficVolume")
                .add(SetAutoBidItem.NETWORK_BY_COVERAGE.name(), "BiddingRule.NetworkByCoverage")
                .add(SetAutoSearchByTrafficVolume.TARGET_TRAFFIC_VOLUME.name(), "TargetTrafficVolume")
                .add(SetAutoSearchByTrafficVolume.INCREASE_PERCENT.name(), "IncreasePercent")
                .add(SetAutoSearchByTrafficVolume.MAX_BID.name(), "BidCeiling")
                .add(SetAutoNetworkByCoverage.CONTEXT_COVERAGE.name(), "TargetCoverage")
                // тут нет SetAutoNetworkByCoverage.INCREASE_PERCENT и SetAutoNetworkByCoverage.MAX_BID,
                // потому что "increasePercent" и "maxBid" уже есть от SetAutoSearchByPosition
                .build();

        AD_EXTENSIONS_PATH_CONVERTER = MappingPathConverter.builder(ApiPathConverter.class, "AdExtensions")
                .add(commonDict)
                .add(Callout.TEXT.name(), "CalloutText")
                .build();

        ADS_PATH_CONVERTER = MappingPathConverter.builder(ApiPathConverter.class, "Ads")
                .add(commonDict)
                .add(BannerWithSystemFields.ID.name(), "Id")
                .add(BannerWithSystemFields.AD_GROUP_ID.name(), "AdGroupId")
                .add(BannerWithSystemFields.CAMPAIGN_ID.name(), "CampaignId")
                .add(BannerWithHref.HREF.name(), "Href")
                .add(BannerWithSystemFields.FLAGS.name(), "AgeLabel")

                .add(TextBanner.VCARD_ID.name(), "VCardId")
                .add(TextBanner.SITELINKS_SET_ID.name(), "SitelinkSetId")
                .add(BannerWithBannerImage.IMAGE_HASH.name(), "AdImageHash")
                .add(BannerWithLogo.LOGO_IMAGE_HASH.name(), "LogoExtensionHash")
                .add(TextBanner.CALLOUT_IDS.name(), "AdExtensionIds")
                .add(TextBanner.IS_MOBILE.name(), "Mobile")
                .add(TextBanner.TITLE.name(), "Title")
                .add(TextBanner.TITLE_EXTENSION.name(), "Title2")
                .add(TextBanner.BODY.name(), "Text")
                .add(TextBanner.DISPLAY_HREF.name(), "DisplayUrlPath")
                .add(TextBanner.DISPLAY_HREF_PREFIX.name(), "DutPrefix")
                .add(TextBanner.DISPLAY_HREF_SUFFIX.name(), "DutSuffix")
                .add(TextBanner.BANNER_PRICE.name(), "PriceExtension")
                .add(TextBanner.TURBO_LANDING_ID.name(), "TurboPageId")
                .add(TextBanner.PERMALINK_ID.name(), "BusinessId")
                .add(TextBanner.PHONE_ID.name(), "TrackingPhoneId")
                .add(TextBanner.PREFER_V_CARD_OVER_PERMALINK.name(), "PreferVCardOverBusiness")
                .add(TextBanner.LEADFORM_HREF.name(), "LfHref")
                .add(TextBanner.LEADFORM_BUTTON_TEXT.name(), "LfButtonText")
                .add(TextBanner.SHOW_TITLE_AND_BODY.name(), "VideoExtension.ShowTitleAndBody")
                .add(bannerPriceDict)

                .add(ImageBanner.CREATIVE_ID.name(), "CreativeId")

                .add(TextAdUpdateBase.PropInfo.CALLOUT_SETTING.propertyName, "CalloutSetting")
                .add(AdExtensionSetting.PropInfo.AD_EXTENSIONS.propertyName, "AdExtensions")
                .add(AdExtensionSettingItem.PropInfo.AD_EXTENSION_ID.propertyName, "AdExtensionId")
                .add(BannerWithPixels.PIXELS.name(), "TrackingPixels")
                .add(FIELD_TRACKING_URL, "TrackingUrl")

                .add(ContentPromotionBanner.CONTENT_PROMOTION_ID.name(), "PromotedContentId")
                .add(ContentPromotionBanner.VISIT_URL.name(), "VisitHref")

                .add(BannerWithMobileContent.IMPRESSION_URL.name(), "ImpressionUrl")

                .add(BannerWithButton.BUTTON_ACTION.name(), "ButtonExtension.Action")
                .add(BannerWithButton.BUTTON_CAPTION.name(), "ButtonExtension.CustomActionText")
                .add(BannerWithButton.BUTTON_HREF.name(), "ButtonExtension.Href")

                .build();

        CAMPAIGNS_PATH_CONVERTER = MappingPathConverter.builder(ApiPathConverter.class, "Campaigns")
                .add(commonDict)
                .ignore(CommonCampaign.ID.name())
                .add(CommonCampaign.NAME.name(), "Name")
                .ignore(CommonCampaign.STATUS_SHOW.name())
                .add(TextCampaign.DISABLED_DOMAINS.name(), "ExcludedSites")
                .add(TextCampaign.DISABLED_SSP.name(), "ExcludedSites")
                .add(TextCampaign.DISABLED_IPS.name(), "BlockedIps")
                .add(TextCampaign.METRIKA_COUNTERS.name(), "CounterIds")
                .ignore(TextCampaign.STRATEGY.name())
                .ignore(DbStrategy.STRATEGY_DATA.name())
                .ignore(DbStrategy.STRATEGY_NAME.name())
                .add(StrategyData.LIMIT_CLICKS.name(), "ClicksPerWeek")
                .add(StrategyData.GOAL_ID.name(), "GoalId")
                .add(StrategyData.AVG_BID.name(), "AverageCpc")
                .add(StrategyData.AVG_CPI.name(), "AverageCpi")
                .add(StrategyData.AVG_CPA.name(), "AverageCpa")
                .add(StrategyData.AVG_CPM.name(), "AverageCpm")
                .add(StrategyData.AVG_CPV.name(), "AverageCpv")
                .add(StrategyData.BID.name(), "BidCeiling")
                .add(StrategyData.SUM.name(), "WeeklySpendLimit")
                .add(StrategyData.START.name(), "StartDate")
                .add(StrategyData.FINISH.name(), "EndDate")
                .add(StrategyData.BUDGET.name(), "SpendLimit")
                .add(StrategyData.CRR.name(), "Crr")
                .add(StrategyData.FILTER_AVG_CPA.name(), "Cpa")
                .add(StrategyData.FILTER_AVG_BID.name(), "Bid")
                .ignore(StrategyData.PAY_FOR_CONVERSION.name())
                .add(TextCampaign.DAY_BUDGET.name(), "DailyBudget")
                .add(TextCampaign.START_DATE.name(), "StartDate")
                .add(TextCampaign.END_DATE.name(), "EndDate")
                .add(TextCampaign.IMPRESSION_RATE_COUNT.name(), "Impressions")
                .add(TextCampaign.IMPRESSION_RATE_INTERVAL_DAYS.name(), "PeriodDays")
                .add(TextCampaign.FIO.name(), "ClientInfo")
                .add(TextCampaign.EMAIL.name(), "Email")
                .ignore(TextCampaign.BROAD_MATCH.name()) //  "RelevantKeywords"
                .ignore(BroadMatch.BROAD_MATCH_FLAG.name())
                .add(BroadMatch.BROAD_MATCH_LIMIT.name(), "BudgetPercent")
                .add(BroadMatch.BROAD_MATCH_GOAL_ID.name(), "OptimizeGoalId")
                .add(TextCampaign.CONTEXT_LIMIT.name(), "LimitPercent")
                .ignore(TextCampaign.ENABLE_PAUSED_BY_DAY_BUDGET_EVENT.name())
                .ignore(TextCampaign.ATTRIBUTION_MODEL.name())
                .ignore(TextCampaign.IS_SERVICE_REQUESTED.name())
                .ignore(TextCampaign.ENABLE_OFFLINE_STAT_NOTICE.name())
                .add(TextCampaign.BANNER_HREF_PARAMS.name(), "TrackingParams")
                .add(TextCampaign.MINUS_KEYWORDS.name(), "NegativeKeywords")
                .add(TextCampaign.MEANINGFUL_GOALS.name(), "PriorityGoals")
                .add(TextCampaign.STRATEGY_ID.name(), "StrategyId")
                .add(MeaningfulGoal.CONVERSION_VALUE.name(), "Value")
                .add(MeaningfulGoal.IS_METRIKA_SOURCE_OF_VALUE.name(), "IsMetrikaSourceOfValue")
                .add(TextCampaign.WARNING_BALANCE.name(), "WarningBalance")
                .ignore(TextCampaign.SMS_TIME.name())
                .add(TimeInterval.START_HOUR.name(), "TimeFrom")
                .add(TimeInterval.START_MINUTE.name(), "TimeFrom")
                .add(TimeInterval.END_HOUR.name(), "TimeTo")
                .add(TimeInterval.END_MINUTE.name(), "TimeTo")
                .add(TextCampaign.DAY_BUDGET_SHOW_MODE.name(), "Mode")
                .add(CpmBannerCampaign.ESHOWS_SETTINGS.name(), "EshowsSettings")
                .add(AutobudgetRoi.RESERVE_RETURN.name(), "ReserveReturn")
                .add(AutobudgetRoi.ROI_COEF.name(), "RoiCoef")
                .add(StrategyData.PROFITABILITY.name(), "Profitability")
                .add(TextCampaign.AB_SEGMENT_GOAL_IDS.name(), "AbSegmentGoalIds")
                .add(TextCampaign.AB_SEGMENT_STATISTIC_RETARGETING_CONDITION_ID.name(),
                        "AbSegmentStatisticRetargetingConditionId")
                .add(TextCampaign.SECTION_IDS.name(), "SectionId")
                .add(TextCampaign.USE_CURRENT_REGION.name(), "UseCurrentRegion")
                .add(TextCampaign.USE_REGULAR_REGION.name(), "UseRegularRegion")
                .add(TextCampaign.IS_ORDER_PHRASE_LENGTH_PRECEDENCE_ENABLED.name(),
                        "IsOrderPhraseLengthPrecedenceEnabled")
                .build();

        CAMPAIGNS_EXT_PATH_CONVERTER = MappingPathConverter.builder(ApiPathConverter.class, "CampaignsExt")
                .add(commonDict)
                .add(CommonCampaign.NAME.name(), "Name")
                .add(TextCampaign.DISABLED_DOMAINS.name(), "ExcludedSites")
                .add(TextCampaign.DISABLED_SSP.name(), "ExcludedSites")
                .add(TextCampaign.DISABLED_IPS.name(), "BlockedIps")
                .add(TextCampaign.METRIKA_COUNTERS.name(), "CounterIds")
                .ignore(TextCampaign.STRATEGY.name())
                .ignore(DbStrategy.STRATEGY_DATA.name())
                .ignore(DbStrategy.STRATEGY_NAME.name())
                .add(StrategyData.LIMIT_CLICKS.name(), "ClicksPerWeek")
                .add(StrategyData.GOAL_ID.name(), "GoalId")
                .add(StrategyData.AVG_BID.name(), "AverageCpc")
                .add(StrategyData.AVG_CPI.name(), "AverageCpi")
                .add(StrategyData.AVG_CPA.name(), "AverageCpa")
                .add(StrategyData.AVG_CPM.name(), "AverageCpm")
                .add(StrategyData.AVG_CPV.name(), "AverageCpv")
                .add(StrategyData.BID.name(), "BidCeiling")
                .add(StrategyData.SUM.name(), "WeeklySpendLimit")
                .add(StrategyData.START.name(), "StartDate")
                .add(StrategyData.FINISH.name(), "EndDate")
                .add(StrategyData.BUDGET.name(), "SpendLimit")
                .ignore(StrategyData.PAY_FOR_CONVERSION.name())
                .add(TextCampaign.DAY_BUDGET.name(), "DailyBudget")
                .add(TextCampaign.START_DATE.name(), "StartDate")
                .add(TextCampaign.END_DATE.name(), "EndDate")
                .add(TextCampaign.IMPRESSION_RATE_COUNT.name(), "Impressions")
                .add(TextCampaign.IMPRESSION_RATE_INTERVAL_DAYS.name(), "PeriodDays")
                .add(TextCampaign.FIO.name(), "ClientInfo")
                .add(TextCampaign.EMAIL.name(), "Email")
                .ignore(TextCampaign.BROAD_MATCH.name()) //  "RelevantKeywords"
                .ignore(BroadMatch.BROAD_MATCH_FLAG.name())
                .add(BroadMatch.BROAD_MATCH_LIMIT.name(), "BudgetPercent")
                .add(BroadMatch.BROAD_MATCH_GOAL_ID.name(), "OptimizeGoalId")
                .add(TextCampaign.CONTEXT_LIMIT.name(), "LimitPercent")
                .ignore(TextCampaign.ENABLE_PAUSED_BY_DAY_BUDGET_EVENT.name())
                .ignore(TextCampaign.ATTRIBUTION_MODEL.name())
                .ignore(TextCampaign.IS_SERVICE_REQUESTED.name())
                .ignore(TextCampaign.ENABLE_OFFLINE_STAT_NOTICE.name())
                .add(TextCampaign.BANNER_HREF_PARAMS.name(), "TrackingParams")
                .add(TextCampaign.MINUS_KEYWORDS.name(), "NegativeKeywords")
                .add(TextCampaign.MEANINGFUL_GOALS.name(), "PriorityGoals")
                .add(TextCampaign.STRATEGY_ID.name(), "StrategyId")
                .add(MeaningfulGoal.CONVERSION_VALUE.name(), "Value")
                .add(MeaningfulGoal.IS_METRIKA_SOURCE_OF_VALUE.name(), "IsMetrikaSourceOfValue")
                .add(TextCampaign.WARNING_BALANCE.name(), "WarningBalance")
                .ignore(TextCampaign.SMS_TIME.name())
                .add(TimeInterval.START_HOUR.name(), "TimeFrom")
                .add(TimeInterval.START_MINUTE.name(), "TimeFrom")
                .add(TimeInterval.END_HOUR.name(), "TimeTo")
                .add(TimeInterval.END_MINUTE.name(), "TimeTo")
                .add(TextCampaign.DAY_BUDGET_SHOW_MODE.name(), "Mode")
                .add(CpmBannerCampaign.ESHOWS_SETTINGS.name(), "EshowsSettings")
                .add(AutobudgetRoi.RESERVE_RETURN.name(), "ReserveReturn")
                .add(AutobudgetRoi.ROI_COEF.name(), "RoiCoef")
                .add(StrategyData.PROFITABILITY.name(), "Profitability")
                .add(TextCampaign.AB_SEGMENT_GOAL_IDS.name(), "AbSegmentGoalIds")
                .add(TextCampaign.SECTION_IDS.name(), "SectionId")
                .add(TextCampaign.AB_SEGMENT_STATISTIC_RETARGETING_CONDITION_ID.name(),
                        "AbSegmentStatisticRetargetingConditionId")
                .add(TextCampaign.USE_CURRENT_REGION.name(), "UseCurrentRegion")
                .add(TextCampaign.USE_REGULAR_REGION.name(), "UseRegularRegion")
                .add(TextCampaign.IS_ORDER_PHRASE_LENGTH_PRECEDENCE_ENABLED.name(),
                        "IsOrderPhraseLengthPrecedenceEnabled")
                .build();

        NEGATIVE_KEYWORD_SHARED_SETS_PATH_CONVERTER = MappingPathConverter.builder(ApiPathConverter.class,
                        "NegativeKeywordSharedSets")
                .add(commonDict)
                .add(MinusKeywordsPack.ID.name(), "Id")
                .add(MinusKeywordsPack.NAME.name(), "Name")
                .add(MinusKeywordsPack.MINUS_KEYWORDS.name(), "NegativeKeywords")
                .build();

        BUSINESSES_PATH_CONVERTER = MappingPathConverter.builder(ApiPathConverter.class, "Businesses")
                .add(commonDict)
                .add(OrganizationInfo.PERMALINK_ID.name(), "Id")
                .build();

        SMARTADTARGETS_PATH_CONVERTER = MappingPathConverter.builder(ApiPathConverter.class, "Smartadtargets")
                .add(commonDict)
                .add(PerformanceFilter.ID.name(), "Id")
                .add(PerformanceFilter.PID.name(), "AdGroupId")
                .add(PerformanceFilter.PRICE_CPC.name(), "AverageCpc")
                .add(PerformanceFilter.PRICE_CPA.name(), "AverageCpa")
                .add(PerformanceFilter.AUTOBUDGET_PRIORITY.name(), "StrategyPriority")
                .add(PerformanceFilter.CONDITIONS.name(), "Conditions")
                .add(PerformanceFilterCondition.PARSED_VALUE, "Arguments")
                .add(PerformanceFilterCondition.STRING_VALUE.name(), "Arguments")
                .add(PerformanceFilterCondition.OPERATOR.name(), "Operator")
                .add(PerformanceFilterCondition.FIELD_NAME.name(), "Operand")
                .add(PerformanceFilter.TARGET_FUNNEL.name(), "Audience")
                .add(PerformanceFilter.IS_DELETED.name(), "State")
                .add(PerformanceFilter.IS_SUSPENDED.name(), "State")
                .build();

        SMARTADTARGETS_SET_BIDS_PATH_CONVERTER =
                MappingPathConverter.builder(ApiPathConverter.class, "SmartadtargetsSetBids")
                        .add(commonDict)
                        .add(SetBidItem.ID.name(), "Id")
                        .add(SetBidItem.AD_GROUP_ID.name(), "AdGroupId")
                        .add(SetBidItem.CAMPAIGN_ID.name(), "CampaignId")
                        .add(SetBidItem.AUTOBUDGET_PRIORITY.name(), "StrategyPriority")
                        .add(SetBidItem.PRICE_CONTEXT.name(), "AverageCpa")
                        .add(SetBidItem.PRICE_SEARCH.name(), "AverageCpc")
                        .build();

        PROMOTED_CONTENT_PATH_CONVERTER = MappingPathConverter.builder(ApiPathConverter.class, "PromotedContent")
                .add(commonDict)
                .add(PromotedContentAddItem.PropInfo.TYPE.propertyName, "Type")
                .add(PromotedContentAddItem.PropInfo.URL.propertyName, "Url")
                .build();

        FEEDS_PATH_CONVERTER = MappingPathConverter.builder(ApiPathConverter.class, "Feeds")
                .add(commonDict)
                .add(Feed.ID.name(), "Id")
                .add(Feed.NAME.name(), "Name")
                .add(Feed.BUSINESS_TYPE.name(), "BusinessType")
                .add(Feed.SOURCE.name(), "SourceType")
                .add(Feed.IS_REMOVE_UTM.name(), "RemoveUtmTags")
                .add(Feed.URL.name(), "Url")
                .add(Feed.LOGIN.name(), "Login")
                .add(Feed.PLAIN_PASSWORD.name(), "Password")
                .add(Feed.FILENAME.name(), "Filename")
                .build();

        AD_VIDEOS_PATH_CONVERTER = MappingPathConverter.builder(ApiPathConverter.class, "AdVideos")
                .add(commonDict)
                .build();
    }

    private ApiPathConverter() {
        // no instantiation
    }

    public static Map<String, String> getCommonDict() {
        return commonDict;
    }

    public static PathConverter forRetargetingLists() {
        return RETARGETING_LISTS_PATH_CONVERTER;
    }

    public static PathConverter forAudienceTargets() {
        return AUDIENCE_TARGETS_PATH_CONVERTER;
    }

    public static PathConverter forDynamicTextAdTargets() {
        return DYNAMIC_TEXT_AD_TARGETS_PATH_CONVERTER;
    }

    public static PathConverter forDynamicFeedAdTargets() {
        return DYNAMIC_FEED_AD_TARGETS_PATH_CONVERTER;
    }

    public static PathConverter forDynamicFeedAdTargetsSetBids() {
        return DYNAMIC_FEED_AD_TARGETS_SET_BIDS_PATH_CONVERTER;
    }

    public static PathConverter forKeywordsResearch() {
        return KEYWORDS_RESEARCH_PATH_CONVERTER;
    }

    public static PathConverter forClientsUpdate() {
        return CLIENTS_UPDATE_PATH_CONVERTER;
    }

    public static PathConverter forAgencyClientsAdd() {
        return AGENCY_CLIENTS_ADD_PATH_CONVERTER;
    }

    public static PathConverter forSetBids() {
        return BIDS_SET_PATH_CONVERTER;
    }

    public static PathConverter forCreatives() {
        return CREATIVES_PATH_CONVERTER;
    }

    public static PathConverter forKeywordBidsSet() {
        return KEYWORD_BIDS_SET_PATH_CONVERTER;
    }

    public static PathConverter forSetAutoBids() {
        return BIDS_SET_AUTO_PATH_CONVERTER;
    }

    public static PathConverter forKeywordBidsSetAuto() {
        return KEYWORD_BIDS_SET_AUTO_PATH_CONVERTER;
    }

    public static PathConverter forAdExtensions() {
        return AD_EXTENSIONS_PATH_CONVERTER;
    }

    public static PathConverter forAds() {
        return ADS_PATH_CONVERTER;
    }

    public static PathConverter forCampaigns() {
        return CAMPAIGNS_PATH_CONVERTER;
    }

    public static PathConverter forCampaignsExt() {
        return CAMPAIGNS_EXT_PATH_CONVERTER;
    }

    public static PathConverter forNegativeKeywordSharedSets() {
        return NEGATIVE_KEYWORD_SHARED_SETS_PATH_CONVERTER;
    }

    public static PathConverter forBusinesses() {
        return BUSINESSES_PATH_CONVERTER;
    }

    public static PathConverter forSmartadtargets() {
        return SMARTADTARGETS_PATH_CONVERTER;
    }

    public static PathConverter forSmartadtargetsSetBidsPathConverter() {
        return SMARTADTARGETS_SET_BIDS_PATH_CONVERTER;
    }

    public static PathConverter forPromotedContent() {
        return PROMOTED_CONTENT_PATH_CONVERTER;
    }

    public static PathConverter forFeeds() {
        return FEEDS_PATH_CONVERTER;
    }

    public static PathConverter forAdVideos() {
        return AD_VIDEOS_PATH_CONVERTER;
    }
}
