@file:JvmName("GeneralUtil")

package ru.yandex.direct.api.v5.common

import com.yandex.direct.api.v5.general.ArrayOfInteger
import com.yandex.direct.api.v5.general.ArrayOfString
import com.yandex.direct.api.v5.general.LangEnum
import com.yandex.direct.api.v5.general.YesNoEnum
import java.math.BigDecimal
import java.util.Locale
import javax.xml.bind.JAXBElement
import ru.yandex.direct.api.v5.converter.ModelChangesHelper
import ru.yandex.direct.i18n.Language
import ru.yandex.direct.model.ModelChanges
import ru.yandex.direct.model.ModelProperty
import ru.yandex.direct.model.ModelWithId

@JvmName("yesNoFromBool")
fun Boolean.toYesNoEnum(): YesNoEnum =
    if (this) YesNoEnum.YES else YesNoEnum.NO

@JvmName("yesNoToBoolean")
fun YesNoEnum.toBoolean(): Boolean =
    when (this) {
        YesNoEnum.YES -> true
        YesNoEnum.NO -> false
    }

fun langFromString(lang: Language): LangEnum? {
    return LangEnum.fromValue(lang.langString.uppercase(Locale.getDefault()))
}

fun stripZeros(number: BigDecimal): BigDecimal? {
    val t = number.stripTrailingZeros()
    return if (t.scale() < 0) {
        t.setScale(0, BigDecimal.ROUND_UNNECESSARY)
    } else {
        t
    }
}

fun Collection<String>.toArrayOfString(): ArrayOfString =
    ArrayOfString().withItems(this)

fun Collection<Long>.toArrayOfInteger(): ArrayOfInteger =
    ArrayOfInteger().withItems(map(Long::toInt))

inline fun <reified M : ModelWithId> buildModelChanges(
    id: Long,
    modelType: Class<M> = M::class.java,
    block: ModelChanges<M>.() -> Unit,
) = ModelChanges(id, modelType).apply(block)

fun <M : ModelWithId, I, T> ModelChanges<M>.processJaxbElement(
    jaxbElement: JAXBElement<I>?,
    property: ModelProperty<in M, T?>,
    defaultValueForNil: T?,
    conversion: (I) -> T?,
) = apply {
    ModelChangesHelper.processJaxbElement(this, jaxbElement, property, conversion, defaultValueForNil)
}

fun <M : ModelWithId, I, T> ModelChanges<M>.processJaxbElement(
    jaxbElement: JAXBElement<I>?,
    property: ModelProperty<in M, T?>,
    conversion: (I) -> T?,
) = apply {
    ModelChangesHelper.processJaxbElement(this, jaxbElement, property, conversion)
}

fun <M : ModelWithId, T> ModelChanges<M>.processJaxbElement(
    jaxbElement: JAXBElement<T>?,
    property: ModelProperty<in M, T?>,
) = apply {
    ModelChangesHelper.processJaxbElement(this, jaxbElement, property)
}

fun <I, T> JAXBElement<I>?.extractValueOrDefault(
    default: T?,
    conversion: (I?) -> T?
) = when {
    this == null -> default
    isNil -> conversion(null)
    else -> conversion(value)
}

fun <T> JAXBElement<T>?.extractValueOrDefault(default: T?) =
    this.extractValueOrDefault(default) { it }
