package ru.yandex.direct.api.v5.common.constants;

import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class GetRequestCommonConstants {

    /**
     * Мин. кол-во сущностей, которое можно получить за один запрос к API
     */
    public static final long DEFAULT_MIN_LIMIT = 1;

    /**
     * Макс. кол-во сущностей, которое можно получить за один запрос к API
     */
    public static final long DEFAULT_MAX_LIMIT = 10_000;

    /**
     * Кол-во сущностей по умолчанию, которое можно получить за один запрос к API
     */
    public static final long DEFAULT_LIMIT = DEFAULT_MAX_LIMIT;

    /**
     * Мин. смещение в списке сущностей одного пользователя
     */
    public static final long DEFAULT_MIN_OFFSET = 0;

    /**
     * Макс. смещение в списке сущностей одного пользователя
     */
    public static final long DEFAULT_MAX_OFFSET = Integer.MAX_VALUE - DEFAULT_MAX_LIMIT;

    /**
     * Смещение по умолчанию в списке сущностей одного пользователя
     */
    public static final long DEFAULT_OFFSET = DEFAULT_MIN_OFFSET;

    /**
     * Мин. кол-во идентификаторов сущностей, которые можно указать в одном запросе к API
     */
    public static final int DEFAULT_MIN_IDS_COUNT = 1;

    /**
     * Макс. кол-во идентификаторов сущностей, которые можно указать в одном запросе к API
     */
    public static final int DEFAULT_MAX_IDS_COUNT = 10_000;

    /**
     * Макс. кол-во идентификаторов связанных сущностей, которые можно указать в одном запросе к API
     */
    public static final int DEFAULT_RELATED_OBJECT_IDS_COUNT = 50;
}
