package ru.yandex.direct.api.v5.common.container;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;

import static ru.yandex.direct.api.v5.common.constants.GetRequestCommonConstants.DEFAULT_LIMIT;
import static ru.yandex.direct.api.v5.common.constants.GetRequestCommonConstants.DEFAULT_OFFSET;


@ParametersAreNonnullByDefault
public class ItemsSelection implements Model {

    public static final ModelProperty<ItemsSelection, List<Long>> IDS =
            prop("ids", ItemsSelection::getIds, ItemsSelection::setIds);

    public static final ModelProperty<ItemsSelection, Long> LIMIT =
            prop("limit", ItemsSelection::getLimit, ItemsSelection::setLimit);

    public static final ModelProperty<ItemsSelection, Long> OFFSET =
            prop("offset", ItemsSelection::getOffset, ItemsSelection::setOffset);

    private List<Long> ids;
    private Long limit = DEFAULT_LIMIT;
    private Long offset = DEFAULT_OFFSET;

    private static <V> ModelProperty<ItemsSelection, V> prop(String name,
                                                             Function<ItemsSelection, V> getter, BiConsumer<ItemsSelection, V> setter) {
        return ModelProperty.create(ItemsSelection.class, name, getter, setter);
    }


    public List<Long> getIds() {
        return ids;
    }

    public void setIds(List<Long> ids) {
        this.ids = ids;
    }

    public ItemsSelection withIds(@Nullable List<Long> ids) {
        this.ids = ids;
        return this;
    }


    public Long getLimit() {
        return limit;
    }

    public void setLimit(Long limit) {
        this.limit = limit;
    }

    public ItemsSelection withLimit(Long limit) {
        this.limit = limit;
        return this;
    }


    public Long getOffset() {
        return offset;
    }

    public void setOffset(Long offset) {
        this.offset = offset;
    }

    public ItemsSelection withOffset(Long offset) {
        this.offset = offset;
        return this;
    }
}
