package ru.yandex.direct.api.v5.common.validation;

import java.util.function.Function;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.api.v5.validation.DefectType;
import ru.yandex.direct.validation.result.DefectId;


/**
 * Дефолтное представление ошибки апи
 *
 * @param <T> тип параметров дефекта
 */
@ParametersAreNonnullByDefault
public class ApiDefectPresentation<T> {
    private final DefectId<T> defectId;
    private final Function<T, DefectType> defectTypeProvider;

    public ApiDefectPresentation(DefectId<T> defectId,
                                 Function<T, DefectType> defectTypeProvider) {
        this.defectId = defectId;
        this.defectTypeProvider = defectTypeProvider;
    }

    public DefectType toDefectType(T params) {
        return defectTypeProvider.apply(params);
    }

    public DefectId<T> defectId() {
        return defectId;
    }
}
