package ru.yandex.direct.api.v5.common.validation;

import java.math.BigDecimal;

import one.util.streamex.StreamEx;

import ru.yandex.direct.api.v5.entity.adextensions.CalloutDefectTypes;
import ru.yandex.direct.api.v5.entity.adgroupadditionaltargetings.AdGroupAdditionalTargetingDefectTypes;
import ru.yandex.direct.api.v5.entity.adgroups.AdGroupDefectTypes;
import ru.yandex.direct.api.v5.entity.ads.AdsDefectTypes;
import ru.yandex.direct.api.v5.entity.bidmodifiers.BidModifiersDefectTypes;
import ru.yandex.direct.api.v5.entity.campaigns.CampaignDefectTypes;
import ru.yandex.direct.api.v5.entity.dynamictextadtargets.DynamicAdTargetsDefectTypes;
import ru.yandex.direct.api.v5.entity.feeds.validation.FeedDefectTypes;
import ru.yandex.direct.api.v5.entity.keywords.KeywordsDefectTypes;
import ru.yandex.direct.api.v5.entity.keywords.MinusPhraseDefectTypes;
import ru.yandex.direct.api.v5.entity.organizations.OrganizationsDefectTypes;
import ru.yandex.direct.api.v5.entity.sitelinks.Constants;
import ru.yandex.direct.api.v5.entity.sitelinks.SitelinksDefectTypes;
import ru.yandex.direct.api.v5.entity.vcards.VCardDefectTypes;
import ru.yandex.direct.api.v5.validation.ApiDefectIds;
import ru.yandex.direct.api.v5.validation.DefectTypes;
import ru.yandex.direct.core.entity.addition.callout.service.validation.CalloutDefectIds;
import ru.yandex.direct.core.entity.addition.callout.service.validation.CalloutDefectTranslations;
import ru.yandex.direct.core.entity.adgeneration.model.GenerationDefectIds;
import ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectIds;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.service.validation.AdGroupAdditionalTargetingsDefectIds;
import ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefectIds;
import ru.yandex.direct.core.entity.banner.type.performance.defects.PerformanceBannerMainDefectIds;
import ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds;
import ru.yandex.direct.core.entity.bids.validation.BidsDefects;
import ru.yandex.direct.core.entity.calltrackingsettings.validation.CalltrackingSettingDefects;
import ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefectIds;
import ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefectTranslations;
import ru.yandex.direct.core.entity.campaign.service.validation.CopyCampaignDefects;
import ru.yandex.direct.core.entity.campaign.service.validation.StrategyDefectIds;
import ru.yandex.direct.core.entity.client.service.AddAgencyClientValidator;
import ru.yandex.direct.core.entity.client.service.validation.ClientDefects;
import ru.yandex.direct.core.entity.clientphone.validation.ClientPhoneDefects;
import ru.yandex.direct.core.entity.contentpromotion.validation.defects.ContentPromotionDefectIds;
import ru.yandex.direct.core.entity.conversionsource.validation.ConversionSourceDefects;
import ru.yandex.direct.core.entity.creative.service.add.validation.CreativeDefectIds;
import ru.yandex.direct.core.entity.deal.service.validation.DealDefectIds;
import ru.yandex.direct.core.entity.dynamictextadtarget.service.validation.DynamicTextAdTargetDefectIds;
import ru.yandex.direct.core.entity.feature.service.validation.FeatureDefectIds;
import ru.yandex.direct.core.entity.feed.validation.FeedDefectIds;
import ru.yandex.direct.core.entity.feedoffer.validation.FeedOfferDefects;
import ru.yandex.direct.core.entity.freelancer.service.validation.AvatarsDefects;
import ru.yandex.direct.core.entity.freelancer.service.validation.FreelancerDefects;
import ru.yandex.direct.core.entity.grants.service.validation.GrantsDefectIds;
import ru.yandex.direct.core.entity.grants.service.validation.GrantsDefectTranslations;
import ru.yandex.direct.core.entity.hrefparams.validation.defects.HrefParamsDefectIds;
import ru.yandex.direct.core.entity.hypergeo.validation.HyperGeoDefectIds;
import ru.yandex.direct.core.entity.image.service.validation.ImageDefectIds;
import ru.yandex.direct.core.entity.internalads.restriction.InternalAdRestrictionDefects;
import ru.yandex.direct.core.entity.internalads.service.validation.defects.InternalAdDefectIds;
import ru.yandex.direct.core.entity.internalads.service.validation.defects.InternalAdStringDefectIds;
import ru.yandex.direct.core.entity.internalads.service.validation.defects.InternalAdsAccessGroupDefects;
import ru.yandex.direct.core.entity.keyword.service.validation.KeywordDefectIds;
import ru.yandex.direct.core.entity.keyword.service.validation.KeywordDefectTranslations;
import ru.yandex.direct.core.entity.keyword.service.validation.phrase.advqphrase.AdvqPhraseDefectIds;
import ru.yandex.direct.core.entity.keyword.service.validation.phrase.keyphrase.PhraseDefectIds;
import ru.yandex.direct.core.entity.keyword.service.validation.phrase.minusphrase.MinusPhraseDefectIds;
import ru.yandex.direct.core.entity.mobileapp.MobileAppDefects;
import ru.yandex.direct.core.entity.offerretargeting.validation.OfferRetargetingDefects;
import ru.yandex.direct.core.entity.organizations.validation.OrganizationDefectIds;
import ru.yandex.direct.core.entity.performancefilter.service.PerformanceFilterDefects;
import ru.yandex.direct.core.entity.pricepackage.service.validation.defects.PricePackageDefectIds;
import ru.yandex.direct.core.entity.promoextension.PromoExtensionNumericDefectIds;
import ru.yandex.direct.core.entity.region.validation.RegionIdDefectIds;
import ru.yandex.direct.core.entity.relevancematch.valdiation.RelevanceMatchDefects;
import ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectIds;
import ru.yandex.direct.core.entity.retargeting.service.validation2.RetargetingDefectTranslations;
import ru.yandex.direct.core.entity.sitelink.service.validation.SitelinkDefectIds;
import ru.yandex.direct.core.entity.sitelink.service.validation.SitelinkSetDefectIds;
import ru.yandex.direct.core.entity.turbolanding.service.validation.defects.TurboLandingDefectIds;
import ru.yandex.direct.core.entity.uac.validation.AppInfoDefectIds;
import ru.yandex.direct.core.entity.uac.validation.ContentDefectIds;
import ru.yandex.direct.core.entity.uac.validation.ParseAppInfoUrlDefectIds;
import ru.yandex.direct.core.entity.uac.validation.TrackingUrlDefectIds;
import ru.yandex.direct.core.entity.user.service.validation.UserDefectIds;
import ru.yandex.direct.core.entity.userssegments.service.validation.UsersSegmentDefectIds;
import ru.yandex.direct.core.entity.vcard.service.validation.AddVcardValidationService;
import ru.yandex.direct.core.entity.vcard.service.validation.InstantMessengerValidator;
import ru.yandex.direct.core.entity.vcard.service.validation.MetroIdValidator;
import ru.yandex.direct.core.entity.vcard.service.validation.OgrnConstraint;
import ru.yandex.direct.core.entity.vcard.service.validation.PhoneValidator;
import ru.yandex.direct.core.entity.vcard.service.validation.VcardDefectIds;
import ru.yandex.direct.core.entity.vcard.service.validation.WorkTimeConstraint;
import ru.yandex.direct.core.service.integration.balance.defects.BalanceDefectIds;
import ru.yandex.direct.core.service.integration.balance.defects.BalanceNumericDefectIds;
import ru.yandex.direct.core.validation.CommonDefectTranslations;
import ru.yandex.direct.core.validation.defects.ids.AdDefectIds;
import ru.yandex.direct.core.validation.defects.ids.CurrencyDefectIds;
import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.i18n.types.Identity;
import ru.yandex.direct.validation.defect.ids.CollectionDefectIds;
import ru.yandex.direct.validation.defect.ids.DateDefectIds;
import ru.yandex.direct.validation.defect.ids.DateTimeDefectIds;
import ru.yandex.direct.validation.defect.ids.NumberDefectIds;
import ru.yandex.direct.validation.defect.ids.StringDefectIds;
import ru.yandex.direct.validation.result.DefectIds;

import static ru.yandex.direct.api.v5.common.ConverterUtils.convertToMicros;
import static ru.yandex.direct.api.v5.common.constants.GetRequestCommonConstants.DEFAULT_MAX_IDS_COUNT;
import static ru.yandex.direct.api.v5.validation.DefectTypes.badGeo;
import static ru.yandex.direct.api.v5.validation.DefectTypes.badParams;
import static ru.yandex.direct.api.v5.validation.DefectTypes.duplicatedObject;
import static ru.yandex.direct.api.v5.validation.DefectTypes.fieldMustBeInRange;
import static ru.yandex.direct.api.v5.validation.DefectTypes.inconsistentState;
import static ru.yandex.direct.api.v5.validation.DefectTypes.inconsistentStateAllowEditCampaignAndAllowImportXls;
import static ru.yandex.direct.api.v5.validation.DefectTypes.invalidCollectionSize;
import static ru.yandex.direct.api.v5.validation.DefectTypes.invalidFormat;
import static ru.yandex.direct.api.v5.validation.DefectTypes.invalidValue;
import static ru.yandex.direct.api.v5.validation.DefectTypes.invalidValueNotGreaterThan;
import static ru.yandex.direct.api.v5.validation.DefectTypes.invalidValueNotLessThan;
import static ru.yandex.direct.api.v5.validation.DefectTypes.maxElementsPerRequest;
import static ru.yandex.direct.api.v5.validation.DefectTypes.notFound;
import static ru.yandex.direct.api.v5.validation.DefectTypes.requiredButEmpty;
import static ru.yandex.direct.api.v5.validation.DefectTypes.translations;
import static ru.yandex.direct.api.v5.validation.DefectTypes.unavailableCurrency;
import static ru.yandex.direct.api.v5.validation.DefectTypes.warningNoEffect;
import static ru.yandex.direct.core.entity.campaign.service.validation.CopyCampaignDefects.Gen.CANNOT_COPY_BANNERS_WITH_REJECTED_CREATIVES;
import static ru.yandex.direct.core.entity.campaign.service.validation.CopyCampaignDefects.Gen.CANNOT_COPY_CANVAS_CREATIVES_BETWEEN_CLIENTS;
import static ru.yandex.direct.core.entity.campaign.service.validation.CopyCampaignDefects.Gen.CANNOT_COPY_CPC_VIDEO_BANNERS_BETWEEN_CLIENTS;
import static ru.yandex.direct.core.entity.campaign.service.validation.CopyCampaignDefects.Gen.CANNOT_COPY_DYNAMIC_FEED_ADGROUPS_BETWEEN_CLIENTS;
import static ru.yandex.direct.core.entity.campaign.service.validation.CopyCampaignDefects.Gen.CANNOT_COPY_PERMALINKS_WITHOUT_ACCESS;
import static ru.yandex.direct.core.entity.campaign.service.validation.CopyCampaignDefects.Gen.FLAG_IS_NOT_ALLOWED;
import static ru.yandex.direct.core.entity.campaign.service.validation.CopyCampaignDefects.Gen.MUST_BE_CLIENT;
import static ru.yandex.direct.core.entity.campaign.service.validation.CopyCampaignDefects.Gen.MUST_BE_SAME_SUB_CLIENT;
import static ru.yandex.direct.core.entity.campaign.service.validation.CopyCampaignDefects.Gen.SELECTOR_NOT_ALLOWED;
import static ru.yandex.direct.core.entity.inventori.service.validation.InventoriDefectIds.String.UNEXPECTED_INVENTORI_COMMON_PROBLEM;
import static ru.yandex.direct.core.entity.inventori.service.validation.InventoriDefectIds.String.UNEXPECTED_INVENTORI_PROBLEM_WITH_CAMPAIGN;
import static ru.yandex.direct.core.entity.retargeting.Constants.MAX_INTEREST_RULES_PER_CONDITION;
import static ru.yandex.direct.web.core.entity.inventori.validation.CampaignDefectIds.CampaignDefects.CAMPAIGN_ALREADY_DELETED;
import static ru.yandex.direct.web.core.entity.inventori.validation.CampaignDefectIds.CampaignDefects.CAMPAIGN_NOT_EXISTS;
import static ru.yandex.direct.web.core.entity.inventori.validation.CampaignDefectIds.CampaignTypeDefects.INVALID_CAMPAIGN_TYPE;
import static ru.yandex.direct.web.core.entity.inventori.validation.CampaignDefectIds.GroupsDefects.INVALID_GROUP_TYPE;
import static ru.yandex.direct.web.core.entity.inventori.validation.CampaignDefectIds.StrategyDefects.INVALID_CAMPAIGN_STRATEGY;
import static ru.yandex.direct.web.core.entity.inventori.validation.InventoriDefectIds.Gen.CONTAINS_KEYWORD_ADGROUPS;
import static ru.yandex.direct.web.core.entity.inventori.validation.InventoriDefectIds.Gen.INTERNAL_ERROR;
import static ru.yandex.direct.web.core.entity.inventori.validation.InventoriDefectIds.Gen.NO_GROUPS;
import static ru.yandex.direct.web.core.entity.inventori.validation.InventoriDefectIds.Gen.NO_SUITABLE_ADGROUPS;
import static ru.yandex.direct.web.core.entity.inventori.validation.InventoriDefectIds.Gen.UNSUPPORTED_ERROR;
import static ru.yandex.direct.web.core.entity.inventori.validation.InventoriDefectIds.Number.INVALID_BUDGET;
import static ru.yandex.direct.web.core.entity.inventori.validation.InventoriDefectIds.Number.INVALID_CPM;
import static ru.yandex.direct.web.core.entity.inventori.validation.InventoriDefectIds.Number.LOW_REACH;
import static ru.yandex.direct.web.core.entity.inventori.validation.InventoriDefectIds.String.INVALID_DATES;
import static ru.yandex.direct.web.core.entity.inventori.validation.InventoriDefectIds.String.INVALID_REQUEST;
import static ru.yandex.direct.web.core.entity.inventori.validation.InventoriDefectIds.String.INVALID_RF;
import static ru.yandex.direct.web.core.entity.inventori.validation.InventoriDefectIds.String.UNKNOWN_SEGMENTS;
import static ru.yandex.direct.web.core.entity.inventori.validation.InventoriDefectIds.String.UNSUPPORTED_SEGMENTS;

/**
 * Хранилище default-ных представлений для ошибок.
 */
public class DefaultApiPresentations {

    public static final DefectPresentationsHolder HOLDER = DefectPresentationsHolder.builder()
            .configure(DefaultApiPresentations::registerCommon)

            .configure(DefaultApiPresentations::registerBaseTypes)

            //API
            .register(ApiDefectIds.Nums.OFFSET_MUST_BE_LESS_THAN_VALUE,
                    t -> DefectTypes.incorrectPageOffsetExceeded(t.getMax().intValue()))
            .register(ApiDefectIds.Nums.ARRAY_MUST_CONTAIN_LESS_THAN_VALUE,
                    t -> DefectTypes.maxElementsInSelection(t.getMax().intValue()))
            .register(ApiDefectIds.Strings.SELECTION_CRITERIA_PARAM_MISSED,
                    t -> DefectTypes.missedParamsInSelection(StreamEx.of(t.getStrings()).joining(", ")))

            .configure(DefaultApiPresentations::registerRetargetings)

            //features
            .register(FeatureDefectIds.CollectionDefectIds.FEATURE_IS_ALREADY_ENABLED_FOR_ROLE,
                    t -> invalidValue())
            .register(FeatureDefectIds.CollectionDefectIds.FEATURE_IS_ALREADY_DISABLED_FOR_ROLE,
                    t -> invalidValue())

            //creatives
            .register(CreativeDefectIds.ClientIds.CREATIVE_NOT_BELONG_TO_CLIENT, t -> invalidValue())
            .register(CreativeDefectIds.AdminReject.CREATIVE_IS_ADMIN_REJECTED, t -> invalidValue())
            .register(CreativeDefectIds.Gen.UPLOAD_VIDEO_FAILED, t -> invalidValue())
            .register(CreativeDefectIds.Gen.CREATE_ADDITION_FROM_VIDEO_FAILED, t -> invalidValue())

            //callout
            .register(CalloutDefectIds.Numbers.MAX_CLIENT_CALLOUTS,
                    t -> DefectTypes.maxElementsExceeded(t.getMax().intValue())
                            .withDetailedMessage(
                                    CalloutDefectTranslations.INSTANCE.maxCalloutsOnClient(t.getMax())))
            .register(CalloutDefectIds.Numbers.MAX_CLIENT_CALLOUTS_WITH_DELETED,
                    t -> DefectTypes.maxElementsExceeded(t.getMax().intValue())
                            .withDetailedMessage(
                                    CalloutDefectTranslations.INSTANCE.maxCalloutsOnClientWithDeleted(t.getMax())))
            .register(CalloutDefectIds.Gen.DUPLICATE_CALLOUT_TEXTS, t -> DefectTypes.duplicatedElement()
                    .withDetailedMessage(CalloutDefectTranslations.INSTANCE.duplicateCalloutTexts()))
            .register(CalloutDefectIds.Strings.ALLOWED_SYMBOLS_CALLOUT_TEXT, t -> DefectTypes.invalidChars()
                    .withDetailedMessage(CalloutDefectTranslations.INSTANCE.notAllowedSymbolsInCalloutText()))
            .register(CalloutDefectIds.Gen.AD_EXTENSION_ALREADY_EXISTS,
                    t -> DefectTypes.warningAdExtensionAlreadyExists()
                            .withDetailedMessage(CalloutDefectTranslations.INSTANCE.adExtensionAlreadyExists()))
            .register(CalloutDefectIds.Gen.AD_EXTENSION_IS_IN_USE, t -> DefectTypes.unableToDelete()
                    .withDetailedMessage(CalloutDefectTranslations.INSTANCE.adExtensionIsInUse()))
            .register(CalloutDefectIds.Gen.AD_EXTENSION_IS_DELETED,
                    t -> DefectTypes.warningAdExtensionIsDeleted())
            .register(CalloutDefectIds.Gen.CALLOUT_TEXT_IS_EMPTY,
                    t -> DefectTypes.emptyValue()
                            .withDetailedMessage(CalloutDefectTranslations.INSTANCE.calloutTextNotSpecified()))
            .register(CalloutDefectIds.Strings.CALLOUT_TEXT_LENGTH_EXCEEDED,
                    t -> CalloutDefectTypes.maxCalloutTextSize())

            //sitelinks
            .configure(DefaultApiPresentations::registerSitelinks)

            //CurrencyAmount
            .register(CurrencyDefectIds.Amount.MUST_BE_GREATER_THAN_OR_EQUAL_TO_MIN,
                    t -> invalidValueNotLessThan(t.getMoneyValue()))
            .register(CurrencyDefectIds.Amount.MUST_BE_LESS_THEN_OR_EQUAL_TO_MAX,
                    t -> invalidValueNotGreaterThan(t.getMoneyValue()))

            .register(CurrencyDefectIds.Availability.UNAVAILABLE_CURRENCY,
                    t -> unavailableCurrency(t.getCurrency(), t.getAvailableCurrencies()))
            .register(
                    AddAgencyClientValidator.VoidDefectIds.INCONSISTENT_STATE_ALLOW_EDIT_CAMPAIGN_AND_ALLOW_IMPORT_XLS,
                    t -> inconsistentStateAllowEditCampaignAndAllowImportXls())

            // vcard
            .configure(DefaultApiPresentations::registerVcards)

            // internalAds
            .configure(DefaultApiPresentations::registerInternalAds)

            //banner
            .configure(DefaultApiPresentations::registerBanners)

            // bids
            // заглушки (эти ошибки правильно определены в BidsDefectPresentations)
            .useDefaultDefectType(invalidValue())
            .configure(DefaultApiPresentations::registerBids)

            //relevanceMatch
            .registerWithDefault(
                    RelevanceMatchDefects.Gen.RELEVANCE_MATCH_CANT_BE_USED_IN_AUTO_BUDGET_COMPANY)
            .registerWithDefault(
                    RelevanceMatchDefects.Gen.RELEVANCE_MATCH_CANT_BE_USED_WHEN_SEARCH_IS_STOPPED)
            .registerWithDefault(
                    RelevanceMatchDefects.Gen.RELEVANCE_MATCH_ALREADY_DELETED)
            .registerWithDefault(
                    RelevanceMatchDefects.Gen.RELEVANCE_MATCH_CANT_BE_DELETED_FROM_ADGROUP_WITHOUT_PHRASES)
            .register(RelevanceMatchDefects.Gen.RELEVANCE_MATCH_ALREADY_SUSPENDED,
                    t -> KeywordsDefectTypes.warningAutotargetingAlreadySuspended())
            .register(RelevanceMatchDefects.Gen.RELEVANCE_MATCH_NOT_SUSPENDED,
                    t -> KeywordsDefectTypes.warningAutotargetingNotSuspended())

            // offer retargeting
            .registerWithDefault(OfferRetargetingDefects.Gen.OFFER_RETARGETING_CANT_BE_USED_IN_AUTO_BUDGET_CAMPAIGN)
            .registerWithDefault(OfferRetargetingDefects.Gen.OFFER_RETARGETING_ALREADY_DELETED)
            .registerWithDefault(OfferRetargetingDefects.Gen.OFFER_RETARGETING_ALREADY_SUSPENDED)
            .registerWithDefault(OfferRetargetingDefects.Gen.OFFER_RETARGETING_NOT_SUSPENDED)

            //adgroup
            .configure(DefaultApiPresentations::registerAdgroups)

            //feed
            .configure(DefaultApiPresentations::registerFeed)

            //additional targeting
            .register(AdGroupAdditionalTargetingsDefectIds.Gen.INCORRECT_VERSION,
                    t -> AdGroupAdditionalTargetingDefectTypes.incorrectVersion())

            // campaign
            .register(CampaignDefectIds.Gen.CAMPAIGN_TYPE_NOT_SUPPORTED,
                    t -> CampaignDefectTypes.campaignTypeNotSupported())
            .register(CampaignDefectIds.Gen.INCONSISTENT_CAMPAIGN_TYPE,
                    t -> DefectTypes.invalidValue())
            .register(CampaignDefectIds.Places.INVALID_DOMAIN_OR_SSP,
                    t -> DefectTypes.invalidValue())
            .register(CampaignDefectIds.Subset.MUST_NOT_CONTAIN_DUPLICATED_STRINGS,
                    t -> DefectTypes.duplicatedElement())
            .register(CampaignDefectIds.LongSubset.MUST_CONTAIN_METRIKA_COUNTERS,
                    t -> DefectTypes.collectionMustContainElements(t.getSubset()))
            .register(CampaignDefectIds.Places.UNKNOWN_SSP,
                    t -> DefectTypes.invalidValue())
            .register(CampaignDefectIds.ContentLanguage.BAD_LANGUAGE,
                    t -> DefectTypes.invalidValue())
            .register(CampaignDefectIds.IpAddresses.INVALID_IP_FORMAT,
                    t -> DefectTypes.invalidValue())
            .register(CampaignDefectIds.IpAddresses.IP_CANT_BE_FROM_INTERNAL_NETWORK,
                    t -> DefectTypes.invalidValue())
            .register(CampaignDefectIds.IpAddresses.IP_CANT_BE_FROM_PRIVATE_NETWORK,
                    t -> DefectTypes.invalidValue())
            .register(CampaignDefectIds.Gen.BROAD_MATCH_DOESNT_MATCH_STRATEGY,
                    t -> DefectTypes.invalidValue())
            .register(CampaignDefectIds.Gen.RELEVANT_KEYWORDS_USELESS_FOR_CHOSEN_STRATEGY,
                    t -> CampaignDefectTypes.relevantKeywordsUselessForChosenStrategy())
            .register(CampaignDefectIds.Gen.MINUS_KEYWORDS_NOT_ALLOWED,
                    t -> CampaignDefectTypes.minusKeywordsNotAllowed())
            .register(CampaignDefectIds.Gen.ARCHIVED_CAMPAIGN_MODIFICATION,
                    t -> CampaignDefectTypes.archivedCampaignModification())
            .register(CampaignDefectIds.Gen.OPERATOR_CANNOT_SET_CONTENT_LANGUAGE,
                    t -> CampaignDefectTypes.campaignNoRights())
            .register(CampaignDefectIds.Gen.OPERATOR_CANNOT_SET_ALLOWED_PAGE_IDS,
                    t -> CampaignDefectTypes.campaignNoRights())
            .register(CampaignDefectIds.Gen.OPERATOR_CANNOT_SET_DISALLOWED_PAGE_IDS,
                    t -> CampaignDefectTypes.campaignNoRights())
            .register(CampaignDefectIds.Gen.CAMPAIGN_NO_WRITE_RIGHTS, t -> CampaignDefectTypes.campaignNoRights())
            .register(CampaignDefectIds.Gen.CAMPAIGN_NOT_FOUND, t -> CampaignDefectTypes.campaignNotFound())
            .register(CampaignDefectIds.Gen.CAMPAIGN_WITH_MONEY_ARCHIVING,
                    t -> CampaignDefectTypes.campaignWithMoneyArchiving())
            .register(CampaignDefectIds.Gen.NON_STOPPED_CAMPAIGN_ARCHIVING,
                    t -> CampaignDefectTypes.nonStoppedCampaignArchiving())
            .register(CampaignDefectIds.Gen.CAMPAIGN_ALREADY_ARCHIVED,
                    t -> CampaignDefectTypes.campaignAlreadyArchived())
            .register(CampaignDefectIds.Gen.CAMPAIGN_NOT_ARCHIVED,
                    t -> CampaignDefectTypes.campaignNotArchived())
            .register(CampaignDefectIds.Nums.UNARC_CAMPAIGNS_LIMIT_EXCEEDED,
                    t -> CampaignDefectTypes.unarcCampaignsLimitExceeded(t.getMax().longValue()))
            .register(CampaignDefectIds.Gen.CAMPAIGN_IS_IN_SPECIAL_ARCHIVED_STATE,
                    CampaignDefectTypes.campaignIsInSpecialArchivedState())
            .register(CampaignDefectIds.Gen.CAMPAIGN_ALREADY_SUSPENDED,
                    t -> CampaignDefectTypes.campaignAlreadySuspended())
            .register(CampaignDefectIds.Gen.CAMPAIGN_NOT_SUSPENDED, t -> CampaignDefectTypes.campaignNotSuspended())
            .register(CampaignDefectIds.Gen.WRONG_DISABLED_DOMAINS_LIMIT,
                    t -> CampaignDefectTypes.wrongDisableDomainLimit())
            .register(CampaignDefectIds.Nums.TOO_MANY_DAY_BUDGET_DAILY_CHANGES,
                    t -> DefectTypes.invalidValue())
            .register(CampaignDefectIds.Gen.DAY_BUDGET_OVERRIDEN_BY_WALLET,
                    t -> DefectTypes.invalidValue())
            .register(CampaignDefectIds.Gen.DAY_BUDGET_SHOW_MODE_OVERRIDEN_BY_WALLET,
                    t -> DefectTypes.invalidValue())
            .register(CampaignDefectIds.Gen.DAY_BUDGET_NOT_SUPPORTED_WITH_STRATEGY,
                    t -> DefectTypes.invalidValue())
            .register(CampaignDefectIds.Gen.DAY_BUDGET_IS_ONLY_USEFUL_FOR_MANUAL_STRATEGIES,
                    t -> DefectTypes.dailyBudgetReset()
                            .withDetailedMessage(
                                    CampaignDefectTranslations.INSTANCE.dailyBudgetIsOnlyUsefulForManualStrategies()))
            .register(CampaignDefectIds.Gen.VIDEO_TYPE_NOT_SUPPORTED_WITH_STRATEGY,
                    t -> DefectTypes.invalidValue())
            .register(CampaignDefectIds.Nums.MAX_COUNT_OF_CAMPAIGNS_CREATED,
                    t -> CampaignDefectTypes.maxCampaignsForClientId(t.getMax().intValue()))
            .register(CampaignDefectIds.Gen.BRAND_LIFT_CAN_BE_ADDED_ONLY_TO_DRAFT_CAMPAIGN,
                    t -> DefectTypes.invalidValue())
            .register(CampaignDefectIds.Gen.BRAND_LIFT_EXPERIMENT_SEGMENTS_CANT_BE_CHANGED,
                    t -> DefectTypes.invalidValue())
            .register(CampaignDefectIds.Gen.BRAND_LIFT_CANT_BE_CHANGED,
                    t -> DefectTypes.invalidValue())
            .register(CopyCampaignDefects.Gen.ALREADY_IN_CAMPAIGN_QUEUE,
                    t -> DefectTypes.invalidValue())
            .register(CopyCampaignDefects.Gen.ALREADY_IN_COPY_QUEUE,
                    t -> DefectTypes.invalidValue())
            .register(MUST_BE_CLIENT,
                    t -> DefectTypes.invalidValue())
            .register(MUST_BE_SAME_SUB_CLIENT,
                    t -> DefectTypes.invalidValue())
            .register(SELECTOR_NOT_ALLOWED,
                    t -> DefectTypes.invalidValue())
            .register(FLAG_IS_NOT_ALLOWED,
                    t -> DefectTypes.invalidValue())
            .register(CANNOT_COPY_DYNAMIC_FEED_ADGROUPS_BETWEEN_CLIENTS,
                    t -> DefectTypes.invalidValue())
            .register(CANNOT_COPY_BANNERS_WITH_REJECTED_CREATIVES,
                    t -> DefectTypes.invalidValue())
            .register(CANNOT_COPY_CANVAS_CREATIVES_BETWEEN_CLIENTS,
                    t -> DefectTypes.invalidValue())
            .register(CANNOT_COPY_CPC_VIDEO_BANNERS_BETWEEN_CLIENTS,
                    t -> DefectTypes.invalidValue())
            .register(CANNOT_COPY_PERMALINKS_WITHOUT_ACCESS,
                    t -> DefectTypes.invalidValue())
            .register(CopyCampaignDefects.Gen.YND_FIXED_CURRENCY,
                    t -> DefectTypes.invalidValue())
            .register(CampaignDefectIds.Gen.REQUIRE_SERVICING_WILL_BE_IGNORED,
                    t -> CampaignDefectTypes.requireServicingWillBeIgnored())
            .register(CampaignDefectIds.Gen.NOT_ALLOWED_ATTRIBUTION_TYPE,
                    t -> DefectTypes.invalidValue())
            .register(CampaignDefectIds.Gen.CAMPAIGNS_PROMOTIONS_PERIODS_ARE_INTERSECTED,
                    t -> DefectTypes.invalidValue())
            .register(CampaignDefectIds.Gen.CAMPAIGN_MORE_THAN_ONCE_IN_REQUEST,
                    t -> DefectTypes.warningDuplicatedCampaign())
            .register(CampaignDefectIds.Nums.MAX_ACTIVE_CAMPAIGNS_PROMOTIONS, t -> invalidValue())
            .register(CampaignDefectIds.Gen.CPM_BANNER_CAMPAIGN_DISABLED,
                    t -> DefectTypes.invalidValue())


            //strategy
            .register(StrategyDefectIds.Gen.WEEK_BUDGET_LESS_THAN, t -> invalidValue()
                    .withDetailedMessage(CampaignDefectTranslations.INSTANCE.weekBudgetLessThan()))
            .register(StrategyDefectIds.Gen.BID_LESS_THAN_AVG_BID, t -> invalidValue()
                    .withDetailedMessage(CampaignDefectTranslations.INSTANCE.bidLessThanAvgBid()))
            .register(StrategyDefectIds.Gen.AVG_BID_AND_BID_TOGETHER_PROHIBITED, t -> invalidValue()
                    .withDetailedMessage(CampaignDefectTranslations.INSTANCE.avgBidAndBidTogetherAreProhibited()))
            .register(StrategyDefectIds.Gen.INCORRECT_RESERVE_RETURN, t -> invalidValue()
                    .withDetailedMessage(CampaignDefectTranslations.INSTANCE.incorrectReserveReturn()))
            .register(StrategyDefectIds.Gen.CAMPAIGN_STRATEGY_INFO_IS_IGNORED_ON_CAMPAIGN_ADD, t -> warningNoEffect()
                    .withDetailedMessage(CampaignDefectTranslations.INSTANCE.campaignStrategyInfoIsIgnoredOnCampaignAdd()))
            .register(StrategyDefectIds.Gen.CAMPAIGN_STRATEGY_INFO_IS_IGNORED_ON_CAMPAIGN_UPDATE, t -> warningNoEffect()
                    .withDetailedMessage(CampaignDefectTranslations.INSTANCE.campaignStrategyInfoIsIgnoredOnCampaignUpdate()))
            .register(StrategyDefectIds.Gen.NEW_STRATEGY_HAS_BEEN_CREATED, t -> warningNoEffect()
                    .withDetailedMessage(CampaignDefectTranslations.INSTANCE.newStrategyHasBeenCreated()))
            .register(StrategyDefectIds.Gen.CAMPAIGN_NOT_IN_PACKAGE, t -> inconsistentState()
                    .withDetailedMessage(CampaignDefectTranslations.INSTANCE.campaignNotInPackage()))
            .register(StrategyDefectIds.Gen.INCONSISTENT_STATE_STRATEGY_AND_STRATEGY_TYPE, t -> inconsistentState()
                    .withDetailedMessage(CampaignDefectTranslations.INSTANCE.inconsistentStrategyToStrategyType()))
            .register(StrategyDefectIds.Gen.STRATEGY_INFO_MISSED, t -> invalidValue()
                    .withDetailedMessage(CampaignDefectTranslations.INSTANCE.strategyInfoMissed()))
            .register(StrategyDefectIds.Gen.CAMPAIGNS_WITH_DIFFERENT_TYPES_IN_ONE_PACKAGE, t -> inconsistentState()
                    .withDetailedMessage(CampaignDefectTranslations.INSTANCE.campaignsWithDifferentTypesInOnePackage()))
            .register(StrategyDefectIds.Gen.INCONSISTENT_STATE_STRATEGY_TYPE_AND_CAMPAIGN_TYPE, t -> invalidValue()
                    .withDetailedMessage(CampaignDefectTranslations.INSTANCE.inconsistentStrategyToCampaignType()))
            .register(StrategyDefectIds.Gen.INCONSISTENT_STATE_STRATEGY_TYPE_AND_AD_GROUP_TYPES, t -> invalidValue()
                    .withDetailedMessage(CampaignDefectTranslations.INSTANCE.inconsistentStrategyToAdGroupTypes()))
            .register(StrategyDefectIds.Gen.INCONSISTENT_STATE_STRATEGY_TYPE_AND_MOBILE_CAMPAIGN_WITHOUT_TRACKING_SYSTEM, t -> invalidValue()
                    .withDetailedMessage(CampaignDefectTranslations.INSTANCE.inconsistentStrategyToMobileCampaignWithoutTrackingSystem()))
            .register(StrategyDefectIds.Gen.PAY_FOR_CONVERSION_DOES_NOT_SUPPORT_BANNERS_WITHOUT_TURBO,
                    t -> invalidValue()
                            .withDetailedMessage(CampaignDefectTranslations.INSTANCE.payForConversionDoesNotSupportBannersWithoutTurbo()))
            .register(StrategyDefectIds.Gen.PAY_FOR_CONVERSION_DOES_NOT_SUPPORT_SITELINKS_WITH_HREFS,
                    t -> invalidValue()
                            .withDetailedMessage(CampaignDefectTranslations.INSTANCE.payForConversionDoesNotSupportSitelinksWithHrefs()))
            .register(StrategyDefectIds.Gen.PAY_FOR_CONVERSION_DOES_NOT_ALLOW_ALL_GOALS,
                    t -> invalidValue()
                            .withDetailedMessage(CampaignDefectTranslations.INSTANCE.payForConversionDoesNotAllowAllGoals()))
            .register(StrategyDefectIds.Gen.PAY_FOR_CONVERSION_DOES_NOT_ALLOW_WALLET_DAY_BUDGET, t -> invalidValue()
                    .withDetailedMessage(CampaignDefectTranslations.INSTANCE.payForConversionDoesNotAllowWalletDayBudget()))
            .register(StrategyDefectIds.Num.STRATEGY_CHANGING_LIMIT_WAS_EXCEEDED, t -> invalidValue()
                    .withDetailedMessage(CampaignDefectTranslations.INSTANCE.strategyChangingLimitWasExceeded()))
            .register(StrategyDefectIds.Gen.MEANINGFUL_GOALS_VALUES_FROM_METRIKA_NOT_SUPPORTED, t -> invalidValue()
                    .withDetailedMessage(CampaignDefectTranslations.INSTANCE.meaningfulGoalsValuesFromMetrikaNotSupported()))
            .register(StrategyDefectIds.Gen.MEANINGFUL_GOALS_VALUES_FROM_METRIKA_INCONSISTENT_STRATEGY,
                    t -> invalidValue()
                            .withDetailedMessage(CampaignDefectTranslations.INSTANCE.meaningfulGoalsValuesFromMetrikaInconsistentStrategy()))
            .register(StrategyDefectIds.Gen.MEANINGFUL_GOALS_VALUES_FROM_METRIKA_ALLOW_ONLY_ALL_GOALS,
                    t -> invalidValue()
                            .withDetailedMessage(CampaignDefectTranslations.INSTANCE.meaningfulGoalsValuesFromMetrikaAllowOnlyAllGoals()))
            .register(StrategyDefectIds.Gen.PAY_FOR_CONVERSION_NOT_SUPPORTED, t -> invalidValue()
                    .withDetailedMessage(CampaignDefectTranslations.INSTANCE.payForConversionNotSupported()))
            .register(StrategyDefectIds.Gen.AVG_CPA_IS_REQUIRED, t -> invalidValue()
                    .withDetailedMessage(CampaignDefectTranslations.INSTANCE.avgCpaIsRequired()))
            .register(StrategyDefectIds.Gen.UNABLE_TO_USE_CURRENT_MEANINGFUL_GOALS_FOR_OPTIMIZATION, t -> invalidValue()
                    .withDetailedMessage(CampaignDefectTranslations.INSTANCE.unableToUseCurrentMeaningfulGoalsForOptimization()))
            .register(StrategyDefectIds.Gen.NO_MEANINGFUL_GOAL_AVAILABLE_AFTER_COPY, t -> invalidValue())
            .register(StrategyDefectIds.Gen.STRATEGY_START_DATE_IS_BEFORE_CAMPAIGN_START_DATE, t -> invalidValue())
            .register(StrategyDefectIds.Gen.STRATEGY_END_DATE_IS_AFTER_CAMPAIGN_END_DATE, t -> invalidValue())
            .register(StrategyDefectIds.Num.STRATEGY_PERIOD_DAYS_COUNT_LESS_THAN_MIN, t -> invalidValue())
            .register(StrategyDefectIds.Num.STRATEGY_PERIOD_DAYS_COUNT_GREATER_THAN_MAX, t -> invalidValue())
            .register(StrategyDefectIds.Gen.INCORRECT_SET_OF_MOBILE_GOALS, t -> invalidValue()
                    .withDetailedMessage(CampaignDefectTranslations.INSTANCE.incorrectSetOfMobileGoals()))
            .register(StrategyDefectIds.Gen.ALL_GOALS_OPTIMIZATION_PROHIBITED,
                    t -> badParams()
                            .withDetailedMessage(CampaignDefectTranslations.INSTANCE.allGoalsOptimizationProhibited()))
            .register(StrategyDefectIds.Gen.WEEKLY_BUDGET_IS_NOT_SUPPORTED, t -> invalidValue()
                    .withDetailedMessage(CampaignDefectTranslations.INSTANCE.weeklyBudgetIsNotSupported()))
            .register(StrategyDefectIds.Gen.LINKING_NON_PUBLIC_STRATEGY_TO_SEVERAL_CAMPAIGNS, t -> invalidValue()
                    .withDetailedMessage(CampaignDefectTranslations.INSTANCE.linkingNonPublicStrategyToSeveralCampaigns()))
            .register(StrategyDefectIds.Gen.UNAVAILABLE_STRATEGY_TYPE_FOR_PUBLICATION, t -> inconsistentState()
                    .withDetailedMessage(CampaignDefectTranslations.INSTANCE.unavailableStrategyTypeForPublication()))
            .register(StrategyDefectIds.Gen.PUBLIC_STRATEGY_NOT_SUPPORTED_FOR_CLIENTS_WITHOUT_WALLET,
                    t -> inconsistentState()
                            .withDetailedMessage(CampaignDefectTranslations.INSTANCE.publicStrategyNotSupportedForClientsWithoutWallet()))
            .register(StrategyDefectIds.Gen.CHANGE_PUBLIC_STRATEGY_TO_PRIVATE, t -> invalidValue()
                    .withDetailedMessage(CampaignDefectTranslations.INSTANCE.changePublicStrategyToPrivate()))
            .register(StrategyDefectIds.Gen.FLAT_CPC_STRATEGY_NOT_SUPPORTED, t -> invalidValue()
                    .withDetailedMessage(CampaignDefectTranslations.INSTANCE.flatCpcStrategyNotSupported()))
            .register(StrategyDefectIds.Gen.ARCHIVED_STRATEGY_MODIFICATION, t -> invalidValue()
                    .withDetailedMessage(CampaignDefectTranslations.INSTANCE.archivedStrategyModificationNotAllowed()))
            .register(StrategyDefectIds.Gen.STRATEGY_ARCHIVING_NOT_ALLOWED, t -> invalidValue()
                    .withDetailedMessage(CampaignDefectTranslations.INSTANCE.strategyArchivingNotAllowed()))
            .register(StrategyDefectIds.Gen.WEEKLY_BUDGET_IS_MANDATORY, t -> invalidValue()
                    .withDetailedMessage(CampaignDefectTranslations.INSTANCE.weeklyBudgetIsMandatory()))
            .register(StrategyDefectIds.NumParameters.STRATEGIES_NUMBER_LIMIT_EXCEEDED, t -> invalidValue()
                    .withDetailedMessage(CampaignDefectTranslations.INSTANCE.strategiesNumberLimitExceeded()))
            .register(StrategyDefectIds.NumParameters.UNARCHIVED_STRATEGIES_NUMBER_LIMIT_EXCEEDED, t -> invalidValue()
                    .withDetailedMessage(CampaignDefectTranslations.INSTANCE.unarchivedStrategiesNumberLimitExceeded()))
            .register(StrategyDefectIds.Num.TOO_MUCH_CAMPAIGNS_LINKED_TO_STRATEGY, t -> invalidValue()
                    .withDetailedMessage(CampaignDefectTranslations.INSTANCE.tooMuchCampaignsLinkedToStrategy()))
            .register(StrategyDefectIds.Gen.STRATEGY_NOT_FOUND, t -> notFound()
                    .withDetailedMessage(CampaignDefectTranslations.INSTANCE.strategyNotFound()))

            //href params
            .register(HrefParamsDefectIds.GeneralDefectIds.HREF_WITH_PARAMS_INVALID, t -> invalidValue()
                    .withDetailedMessage(CommonDefectTranslations.INSTANCE.hrefParamsInvalid()))
            .register(HrefParamsDefectIds.NumberDefectIds.HREF_PARAMS_TOO_LONG, t -> invalidValue()
                    .withDetailedMessage(CommonDefectTranslations.INSTANCE.hrefParamsMaxLength()))

            //camp_metrika_counters
            .register(CampaignDefectIds.Gen.CANT_ADD_OR_DELETE_METRIKA_COUNTERS_TO_PERFORMANCE_CAMPAIGN,
                    t -> invalidValue())
            .register(CampaignDefectIds.Gen.METRIKA_COUNTER_IS_UNAVAILABLE, t -> invalidValue())
            .register(CampaignDefectIds.Gen.METRIKA_COUNTERS_UNSUPPORTED_CAMP_TYPE, t -> invalidValue())
            .register(CampaignDefectIds.Nums.MAX_METRIKA_COUNTERS_LIST_SIZE, t -> invalidValue())

            //geo
            .register(RegionIdDefectIds.Gen.EMPTY_REGIONS,
                    t -> badGeo().withDetailedMessage(translations().badGeoDetailedEmptyRegions()))
            .register(RegionIdDefectIds.Gen.INCORRECT_USE_OF_ZERO_REGION,
                    t -> badGeo().withDetailedMessage(translations().badGeoDetailedIncorrectUseOfZeroRegion()))
            .register(RegionIdDefectIds.Gen.NO_PLUS_REGIONS,
                    t -> badGeo().withDetailedMessage(translations().badGeoDetailedNoPlusRegions()))
            .register(RegionIdDefectIds.RegionIds.INCORRECT_REGIONS,
                    t -> badGeo().withDetailedMessage(
                            translations().badGeoDetailedIncorrectRegions(t.getRegionIds())))
            .register(RegionIdDefectIds.RegionIds.MINUS_REGION_MATCHES_PLUS_REGION,
                    t -> badGeo().withDetailedMessage(
                            translations().badGeoDetailedMinusRegionMatchesPlusRegion(
                                    t.getMinusRegionIds(), t.getRegionIds())))
            .register(RegionIdDefectIds.Regions.MINUS_REGIONS_WITHOUT_PLUS_REGIONS,
                    t -> badGeo().withDetailedMessage(
                            translations().badGeoDetailedMinusRegionsWithoutPlusRegions(
                                    t.toTranslatable())))
            .register(RegionIdDefectIds.Regions.NON_UNIQUE_REGIONS,
                    t -> badGeo().withDetailedMessage(
                            translations().badGeoDetailedNonUniqueRegions(t.toTranslatable())))
            .register(RegionIdDefectIds.Regions.GEO_FRONTPAGE_DESKTOP_IGNORED_REGIONS_DUE_TO_PRICE,
                    t -> badGeo().withDetailedMessage(
                            translations().regionsIgnoredDesktopBecauseOfPrice(t.toTranslatable())))
            .register(RegionIdDefectIds.Regions.GEO_FRONTPAGE_MOBILE_IGNORED_REGIONS_DUE_TO_PRICE,
                    t -> badGeo()
                            .withDetailedMessage(translations().regionsIgnoredMobileBecauseOfPrice(t.toTranslatable())))
            .register(RegionIdDefectIds.Regions.GEO_FRONTPAGE_BROWSER_NEW_TAB_IGNORED_REGIONS_DUE_TO_PRICE,
                    t -> badGeo()
                            .withDetailedMessage(translations().regionsIgnoredBrowserNewTabBecauseOfPrice(t.toTranslatable())))

            //minusWords
            .configure(DefaultApiPresentations::registerMinuswords)

            //keywords advq
            .configure(DefaultApiPresentations::registerKeywordsAdvq)

            // keywords фразы
            .register(PhraseDefectIds.String.ILLEGAL_CHARACTERS,
                    t -> DefectTypes.mustContainLettersOrDigitsOrPunctuations())
            .register(PhraseDefectIds.Gen.INVALID_QUOTES, t -> invalidValue())
            .register(PhraseDefectIds.Gen.INVALID_BRACKETS, t -> invalidValue())
            .register(PhraseDefectIds.Gen.INVALID_EXCLAMATION_MARK,
                    t -> DefectTypes.invalidChars().withDetailedMessage(
                            (path, value) -> translations().invalidCharsIncorrectUseOfExclamationMarks(value.toString())))
            .register(PhraseDefectIds.Gen.INVALID_PLUS_MARK,
                    t -> DefectTypes.invalidChars().withDetailedMessage(
                            (path, value) -> translations().invalidCharsIncorrectUseOfPlusSign(value.toString())))
            .register(PhraseDefectIds.Gen.INVALID_MINUS_MARK, t -> DefectTypes.invalidMinusMark())
            .register(PhraseDefectIds.Gen.INVALID_POINT, MinusPhraseDefectTypes.invalidWordFirstCharacter())
            .register(PhraseDefectIds.Gen.INVALID_APOSTROPHE, MinusPhraseDefectTypes.invalidWordFirstCharacter())
            .register(PhraseDefectIds.Gen.BOTH_QUOTES_AND_MINUS_WORDS, t -> invalidValue())
            .register(PhraseDefectIds.Gen.MINUS_WORD_INSIDE_BRACKETS_OR_QUOTES, t -> invalidValue())
            .register(PhraseDefectIds.Gen.PLUS_MARK_IN_BRACKETS, t -> invalidValue())
            .register(PhraseDefectIds.Gen.BRACKETS_IN_MINUS_WORDS, t -> DefectTypes.minusWords())
            .register(PhraseDefectIds.Gen.NO_PLUS_WORDS, t -> DefectTypes.minusWords())
            .register(PhraseDefectIds.String.NOT_SINGLE_MINUS_WORD, t -> DefectTypes.minusWords())
            .register(PhraseDefectIds.String.MINUS_WORD_DELETE_PLUS_WORD, t -> DefectTypes.minusWords())
            .register(PhraseDefectIds.Gen.ONLY_STOP_WORDS, t -> invalidValue())
            .register(PhraseDefectIds.String.TOO_LONG_KEYWORD, t -> invalidValue())
            .register(PhraseDefectIds.String.TOO_LONG_WORD, t -> invalidValue())
            .register(PhraseDefectIds.String.TOO_LONG_MINUS_WORD, t -> invalidValue())
            .register(PhraseDefectIds.String.TOO_MANY_WORDS, t -> invalidValue())
            .register(PhraseDefectIds.Gen.INCORRECT_USE_OF_PARENTHESIS, t -> invalidValue())

            // keywords модели -заглушки
            .register(KeywordDefectIds.Gen.KEYWORD_DUPLICATED_WITH_EXISTING,
                    t -> DefectTypes.warningKeywordAlreadyExists())
            .register(KeywordDefectIds.Gen.KEYWORD_DUPLICATED_WITH_NEW, t -> DefectTypes.warningKeywordAlreadyExists())
            .register(KeywordDefectIds.Gen.DUPLICATED_WITH_UPDATED, t -> DefectTypes.warningKeywordAlreadyExists())
            .register(KeywordDefectIds.Keyword.MAX_KEYWORDS_PER_AD_GROUP_EXCEEDED, t -> invalidValue())
            .register(KeywordDefectIds.Gen.NOT_ACCEPTABLE_AD_GROUP_TYPE,
                    DefectTypes.notEligibleObject().withDetailedMessage(
                            KeywordDefectTranslations.INSTANCE.keywordForbiddenInThisAdGroup()))
            .register(KeywordDefectIds.Gen.NO_RIGHTS_IN_ARCHIVED_ADGROUP,
                    DefectTypes.notEligibleObject().withDetailedMessage(
                            KeywordDefectTranslations.INSTANCE.keywordModificationInArchivedAdGroup()))
            .register(KeywordDefectIds.Gen.AD_GROUP_NOT_FOUND, t -> DefectTypes.notFound())
            .register(KeywordDefectIds.Gen.KEYWORD_ALREADY_SUSPENDED,
                    t -> KeywordsDefectTypes.warningKeywordAlreadySuspended())
            .register(KeywordDefectIds.Gen.KEYWORD_NOT_SUSPENDED,
                    t -> KeywordsDefectTypes.warningKeywordNotSuspended())
            .register(KeywordDefectIds.Gen.AUTOTARGETING_PREFIX_IS_NOT_ALLOWED,
                    t -> KeywordsDefectTypes.autotargetingPrefixIsNotAllowed())
            // dynamictextadtargets
            .register(DynamicTextAdTargetDefectIds.Gen.IS_NOT_SUSPENDED,
                    DynamicAdTargetsDefectTypes.dynamicTextAdTargetIsNotSuspended())
            .register(DynamicTextAdTargetDefectIds.Gen.ALREADY_SUSPENDED,
                    DynamicAdTargetsDefectTypes.dynamicTextAdTargetAlreadySuspended())
            .register(DynamicTextAdTargetDefectIds.IdParametrized.DYNAMIC_TEXT_AD_TARGET_NOT_FOUND_IN_CAMPAIGN,
                    t -> DynamicAdTargetsDefectTypes.dynamicTextAdTargetNotFoundInCampaign(t.getId()))
            .register(DynamicTextAdTargetDefectIds.IdParametrized.DYNAMIC_TEXT_AD_TARGET_NOT_FOUND_IN_AD_GROUP,
                    t -> DynamicAdTargetsDefectTypes.dynamicTextAdTargetNotFoundInAdGroup(t.getId()))

            // grants
            .register(GrantsDefectIds.Gen.INCONSISTENT_STATE_ALLOW_EDIT_CAMPAIGN_AND_ALLOW_IMPORT_XLS,
                    t -> inconsistentState()
                            .withDetailedMessage(GrantsDefectTranslations.INSTANCE
                                    .inconsistentStateAllowEditCampaignAndAllowImportXls()))

            //balance
            .registerWithDefault(BalanceDefectIds.INVALID_PROMO_CODE)
            .registerWithDefault(BalanceDefectIds.PROMOCODE_WRONG_CLIENT)
            .registerWithDefault(BalanceDefectIds.UNIQUE_URLS_PROMOCODE)
            .registerWithDefault(BalanceNumericDefectIds.INVALID_MINIMAL_QTY)

            // conversion source
            .registerWithDefault(ConversionSourceDefects.Counter.COUNTER_IS_INACCESSIBLE)

            // organizations
            .register(OrganizationDefectIds.Gen.ORGANIZATION_NOT_FOUND, OrganizationsDefectTypes.organizationNotFound())
            .register(OrganizationDefectIds.Gen.INVALID_PREFER_V_CARD_OVER_PERMALINK,
                    OrganizationsDefectTypes.invalidPreferVCardOverPermalink())
            .register(OrganizationDefectIds.Gen.HAS_NO_ACCESS_TO_ORGANIZATION,
                    OrganizationsDefectTypes.hasNoAccessToOrganization())
            .register(OrganizationDefectIds.Gen.EITHER_PERMALINK_OR_CHAIN_CAN_BE_FILLED,
                    OrganizationsDefectTypes.eitherPermalinkOrChainCanBeFilled())
            .register(OrganizationDefectIds.Statuses.INVALID_ORGANIZATION_STATUS,
                    OrganizationsDefectTypes::invalidOrganizationStatus)

            // client phones
            .registerWithDefault(ClientPhoneDefects.Ids.PHONE_COUNTRY_NOT_ALLOWED)

            // calltracking settings
            .registerWithDefault(CalltrackingSettingDefects.Ids.NO_WRITE_PERMISSIONS_ON_COUNTER)
            .registerWithDefault(CalltrackingSettingDefects.Ids.COUNTER_NOT_AVAILABLE_FOR_CLIENT)
            .registerWithDefault(CalltrackingSettingDefects.Ids.FORBIDDEN_DOMAIN)

            // generation
            .registerWithDefault(GenerationDefectIds.CAMPAIGN_WITHOUT_HREF)
            .registerWithDefault(GenerationDefectIds.BAD_CAMPAIGN_HREF)
            .registerWithDefault(GenerationDefectIds.EMPTY_SEARCH_QUERY_API_RESPONSE)
            .registerWithDefault(GenerationDefectIds.CAMPAIGN_WITHOUT_PERMALINK)
            .registerWithDefault(GenerationDefectIds.PERMALINK_WITHOUT_GEO)
            .registerWithDefault(GenerationDefectIds.PERMALINK_WITHOUT_SUITABLE_GEO)
            .registerWithDefault(GenerationDefectIds.COUNTERS_NOT_FOUND)
            .registerWithDefault(GenerationDefectIds.DOMAIN_DISABLED)
            .registerWithDefault(GenerationDefectIds.AD_GROUP_WITHOUT_KEYWORDS)
            .registerWithDefault(GenerationDefectIds.IMAGE_SEARCH_API_WITHOUT_QUERY)
            .registerWithDefault(GenerationDefectIds.EMPTY_IMAGE_SEARCH_API_RESPONSE)
            .registerWithDefault(GenerationDefectIds.SITELINKS_NOT_FOUND)
            .registerWithDefault(GenerationDefectIds.SITELINKS_FOUND_ONLY_FOR_COMMON_PAGE)
            .registerWithDefault(GenerationDefectIds.SITELINKS_FOUND_FOR_PARENT_PAGE)
            .registerWithDefault(GenerationDefectIds.RICH_CONTENT_API_USE_ZORA)
            .registerWithDefault(GenerationDefectIds.SPRAV_API_ERROR)
            .registerWithDefault(GenerationDefectIds.RICH_CONTENT_API_ERROR)
            .registerWithDefault(GenerationDefectIds.SEARCH_QUERY_API_ERROR)
            .registerWithDefault(GenerationDefectIds.IMAGE_SEARCH_API_ERROR)
            .registerWithDefault(GenerationDefectIds.METRIKA_API_ERROR)
            .registerWithDefault(GenerationDefectIds.BANGEN_PROXY_API_ERROR)

            //contentPromotion
            .register(ContentPromotionDefectIds.NumberDefectIds.NOT_ENOUGH_CARDS_IN_NEW_COLLECTION,
                    t -> invalidValue().withDetailedMessage(
                            translations().notEnoughCardsInNewCollection(t.getMin().intValue())
                    ))
            .register(ContentPromotionDefectIds.NumberDefectIds.NOT_ENOUGH_CARDS_IN_EXISTING_COLLECTION,
                    t -> invalidValue().withDetailedMessage(
                            translations().notEnoughCardsinExistingCollection(t.getMin().intValue())
                    ))
            .register(ContentPromotionDefectIds.GeneralDefectIds.CONTENT_PROMOTION_INACCESSIBLE,
                    t -> invalidValue().withDetailedMessage(translations().contentInaccessibleGetmeta()))
            .register(ContentPromotionDefectIds.GeneralDefectIds.CONTENT_PROMOTION_NOT_FOUND,
                    t -> invalidValue().withDetailedMessage(translations().contentNotFoundGetmeta()))
            .register(ContentPromotionDefectIds.GeneralDefectIds.CONTENT_PROMOTION_TYPE_IS_NOT_SUPPORTED,
                    t -> invalidValue().withDetailedMessage(translations().contentTypeIsNotSupported()))

            // bidmodifiers
            .registerWithDefault(BidModifiersDefectIds.GeneralDefects.GEO_BID_MODIFIERS_NOT_SUPPORTED_ON_ADGROUPS)
            .registerWithDefault(BidModifiersDefectIds.GeneralDefects.DUPLICATE_RETARGETING_CONDITION)
            .registerWithDefault(BidModifiersDefectIds.GeneralDefects.DUPLICATE_ADJUSTMENT)
            .registerWithDefault(BidModifiersDefectIds.GeneralDefects.DUPLICATE_SINGLE_ADJUSTMENT)
            .registerWithDefault(BidModifiersDefectIds.GeneralDefects.REQUIRED_AT_LEAST_ONE_OF_AGE_OR_GENDER)
            .registerWithDefault(BidModifiersDefectIds.GeneralDefects.REQUIRED_AT_LEAST_ONE_EXPRESSION)
            .registerWithDefault(BidModifiersDefectIds.GeneralDefects.REQUIRED_EXPRESSION_FIELDS)
            .registerWithDefault(BidModifiersDefectIds.IntegerDefects.TEMP_MUST_BE_GREATER_OR_EQUAL)
            .registerWithDefault(BidModifiersDefectIds.IntegerDefects.TEMP_MUST_BE_LESS_OR_EQUAL)
            .registerWithDefault(BidModifiersDefectIds.GeneralDefects.INVALID_PARAMETER_VALUE)
            .registerWithDefault(BidModifiersDefectIds.GeneralDefects.INVALID_PARAMETER)
            .registerWithDefault(BidModifiersDefectIds.GeneralDefects.DEMOGRAPHICS_CONDITIONS_INTERSECTION)
            .registerWithDefault(BidModifiersDefectIds.GeneralDefects.INVALID_PERCENT_SHOULD_BE_POSITIVE)
            .registerWithDefault(BidModifiersDefectIds.GeneralDefects.NOT_SUPPORTED_MULTIPLIER)
            .registerWithDefault(BidModifiersDefectIds.GeneralDefects.GEO_REGIONS_INTERSECTION)
            .registerWithDefault(BidModifiersDefectIds.GeneralDefects.TRAFARET_POSITIONS_INTERSECTION)
            .registerWithDefault(BidModifiersDefectIds.GeneralDefects.ADJUSTMENT_NOT_FOUND)
            .registerWithDefault(BidModifiersDefectIds.GeneralDefects.ADJUSTMENT_SET_NOT_FOUND)
            .registerWithDefault(BidModifiersDefectIds.GeneralDefects.SINGLE_VALUE_MODIFIER_ALREADY_EXISTS)
            .registerWithDefault(BidModifiersDefectIds.GeneralDefects.CONFLICT_APPLYING_CHANGES)
            .registerWithDefault(BidModifiersDefectIds.Number.TOO_MANY_DEMOGRAPHY_CONDITIONS)
            .registerWithDefault(BidModifiersDefectIds.Number.TOO_MANY_RETARGETING_CONDITIONS)
            .registerWithDefault(BidModifiersDefectIds.Number.TOO_MANY_INVENTORY_CONDITIONS)
            .registerWithDefault(BidModifiersDefectIds.Number.TOO_MANY_WEATHER_CONDITIONS)
            .registerWithDefault(BidModifiersDefectIds.Number.TOO_MANY_EXPRESSION_CONDITIONS)
            .registerWithDefault(BidModifiersDefectIds.Number.TOO_MANY_TRAFARET_POSITION_CONDITIONS)
            .registerWithDefault(BidModifiersDefectIds.LimitOffsetDefects.BID_MODIFIERS_GET_HARD_LIMIT_EXCEEDED)
            .registerWithDefault(BidModifiersDefectIds.LimitOffsetDefects.BID_MODIFIERS_ADD_ITEMS_LIMIT_EXCEEDED)
            .registerWithDefault(BidModifiersDefectIds.LimitOffsetDefects.BID_MODIFIERS_SET_ITEMS_LIMIT_EXCEEDED)
            .registerWithDefault(BidModifiersDefectIds.LimitOffsetDefects.BID_MODIFIERS_TOGGLE_ITEMS_LIMIT_EXCEEDED)
            .registerWithDefault(BidModifiersDefectIds.ModelDefects.REQUIRED_AT_LEAST_ONE_OF_FIELDS)
            .registerWithDefault(BidModifiersDefectIds.ModelDefects.POSSIBLE_ONLY_ONE_FIELD)
            .registerWithDefault(BidModifiersDefectIds.RegionIdsDefects.NONEXISTENT_REGION_IDS)
            .registerWithDefault(BidModifiersDefectIds.GeneralDefects.AB_SEGMENT_BID_MODIFIERS_INTERSECTION)
            .registerWithDefault(
                    BidModifiersDefectIds.GeneralDefects.AB_SEGMENT_BID_MODIFIERS_NOT_SUPPORTED_ON_ADGROUPS)
            .registerWithDefault(BidModifiersDefectIds.GeneralDefects.UNSUPPORTED_RETARGETING_TYPE)
            .registerWithDefault(BidModifiersDefectIds.GeneralDefects.DEVICE_BID_MODIFIERS_ALL_ZEROS)
            .registerWithDefault(BidModifiersDefectIds.GeneralDefects.SETTING_OS_TYPE_NOT_ALLOWED)
            .register(BidModifiersDefectIds.IdParametrized.AB_SEGMENT_NOT_FOUND,
                    t -> BidModifiersDefectTypes.abSegmentNotFound(t.getId()))
            .register(BidModifiersDefectIds.IdParametrized.AB_SEGMENT_SECTION_NOT_FOUND,
                    t -> BidModifiersDefectTypes.abSegmentSectionNotFound(t.getId()))
            .registerWithDefault(BidModifiersDefectIds.GeneralDefects.INVALID_EXPRESSION_LITERAL)
            .registerWithDefault(BidModifiersDefectIds.GeneralDefects.EXPRESSION_ADJUSTMENT_IS_CONSTANT_FOR_ANY_VALUES)
            .registerWithDefault(BidModifiersDefectIds.GeneralDefects.EXPRESSION_CONDITIONS_INTERSECTION)
            .registerWithDefault(BidModifiersDefectIds.GeneralDefects.ONE_TYPE_USED_TWICE_IN_COMPLEX_MODIFIER)

            // clients
            .registerWithDefault(ClientDefects.Gen.MUST_NOT_BE_FREELANCER)
            .registerWithDefault(ClientDefects.Gen.NOT_APPROPRIATE_ROLE)

            //deals
            .registerWithDefault(DealDefectIds.TRANSITION_IS_UNAVAILABLE)
            .registerWithDefault(DealDefectIds.DEAL_IS_NOT_ACTIVE)
            .registerWithDefault(DealDefectIds.Currency.CAMPAIGN_AND_DEAL_CURRENCY_SHOULD_MATCH)
            .registerWithDefault(DealDefectIds.Currency.DEAL_CURRENCY_SHOULD_MATCH_CLIENT)

            // mobile app
            .registerWithDefault(MobileAppDefects.Gen.NO_ACCESS_TO_CHANGE_DOMAIN)
            .registerWithDefault(MobileAppDefects.Gen.INVALID_URL)
            .registerWithDefault(MobileAppDefects.Gen.INVALID_APP_STORE_URL)
            .registerWithDefault(MobileAppDefects.Gen.INVALID_DOMAIN)
            .registerWithDefault(MobileAppDefects.Gen.TRACKER_URL_DOMAIN_DOES_NOT_MATCH_SELECTED_TRACKER_SYSTEM)
            .registerWithDefault(MobileAppDefects.Gen.APP_NOT_FOUND)
            .registerWithDefault(MobileAppDefects.Gen.TOO_MANY_BANNERS)
            .registerWithDefault(MobileAppDefects.Gen.PROPAGATION_IS_FAILED)
            .registerWithDefault(MobileAppDefects.Gen.CAN_NOT_REMOVE_TRACKING_URL_IN_CPI_CAMPAIGN)
            .registerWithDefault(MobileAppDefects.Gen.CAN_NOT_CHANGE_TRACKING_SYSTEM_IN_CPI_CAMPAIGN)
            .registerWithDefault(MobileAppDefects.Gen.CAN_NOT_CHANGE_TRACKING_SYSTEM_WITH_UNTRACKABLE_BANNER_HREF)
            .registerWithDefault(MobileAppDefects.Gen.APPMETRIKA_APPLICATION_ALREADY_USED)

            //freelancers
            .registerWithDefault(FreelancerDefects.VoidDefects.CLIENT_NOT_FOUND)
            .registerWithDefault(FreelancerDefects.VoidDefects.MUST_BE_CLIENT)
            .registerWithDefault(FreelancerDefects.VoidDefects.MUST_BE_FREELANCER)
            .registerWithDefault(FreelancerDefects.VoidDefects.MUST_HAVE_FREELANCER_CARD)
            .registerWithDefault(FreelancerDefects.VoidDefects.PROJECT_NOT_FOUND)
            .registerWithDefault(FreelancerDefects.VoidDefects.CLIENT_IS_ALREADY_FREELANCER)
            .registerWithDefault(FreelancerDefects.VoidDefects.CLIENT_HAS_WRONG_ROLE)
            .registerWithDefault(FreelancerDefects.VoidDefects.SKILL_DOES_NOT_EXIST)
            .registerWithDefault(FreelancerDefects.VoidDefects.CLIENT_CURRENCY_IS_NOT_CONVERTED)
            .registerWithDefault(FreelancerDefects.VoidDefects.SOCIAL_CLIENTS_CANT_REQUEST_SERVICE)
            .registerWithDefault(FreelancerDefects.VoidDefects.AGENCY_CLIENT_CANT_REQUEST_SERVICE)
            .registerWithDefault(FreelancerDefects.VoidDefects.USERS_COUNT_EXCEEDED)
            .registerWithDefault(FreelancerDefects.VoidDefects.DIRECT_CERTIFICATE_NOT_FOUND)
            .registerWithDefault(FreelancerDefects.VoidDefects.NAMES_MUST_BE_SAME_AS_CERT_NAMES)
            .registerWithDefault(FreelancerDefects.ProjectsDefects.PROJECTS_ARE_ALREADY_EXIST)
            .registerWithDefault(FreelancerDefects.StatusDefects.TRANSITION_IS_NOT_AVAILABLE)
            .registerWithDefault(FreelancerDefects.FeedbackDefects.FEEDBACK_NOT_FOUND)
            .registerWithDefault(FreelancerDefects.FeedbackDefects.INCORRECT_FEEDBACK_TEXT_SIZE)
            .registerWithDefault(FreelancerDefects.FeedbackDefects.OPERATOR_HAS_NO_PROJECT_WITH_FREELANCER)
            .registerWithDefault(FreelancerDefects.FeedbackDefects.OPERATOR_HAS_WRONG_ROLE)
            .registerWithDefault(FreelancerDefects.FeedbackDefects.OPERATOR_IS_NOT_CHIEF)
            .registerWithDefault(FreelancerDefects.FeedbackDefects.FEEDBACK_ALREADY_EXIST)

            //avatars
            .registerWithDefault(AvatarsDefects.AvatarsClientDefects.SERVER_CONNECTION_ERROR)
            .registerWithDefault(AvatarsDefects.AvatarsClientDefects.UNKNOWN_ERROR)

            //image
            .registerWithDefault(ImageDefectIds.Gen.IMAGE_CONTAINS_ANIMATION)
            .registerWithDefault(ImageDefectIds.Gen.IMAGE_MIME_TYPE_IS_NOT_SUPPORTED)
            .registerWithDefault(ImageDefectIds.Gen.IMAGE_SIZE_IS_NOT_ALLOWED)
            .registerWithDefault(ImageDefectIds.Gen.IMAGE_SIZE_IS_NOT_ALLOWED_MC_BANNER)
            .registerWithDefault(ImageDefectIds.SizesDefects.IMAGE_SIZES_GREATER_THAN_MAX)
            .registerWithDefault(ImageDefectIds.Format.IMAGE_FILE_FORMAT_NOT_ALLOWED)
            .registerWithDefault(ImageDefectIds.Gen.INVALID_IMAGE_FILE)
            .registerWithDefault(ImageDefectIds.Gen.INVALID_IMAGE_URL)
            .registerWithDefault(ImageDefectIds.Gen.IMAGE_FILE_SIZE_GREATER_THAN_MAX)

            //performance_filters
            .registerWithDefault(PerformanceFilterDefects.PerformanceFilterDefectIds.INCONSISTENT_CAMPAIGN_STRATEGY)
            .registerWithDefault(PerformanceFilterDefects.PerformanceFilterDefectIds.FILTER_CONDITIONS_IS_TOO_LONG)
            .registerWithDefault(PerformanceFilterDefects.PerformanceFilterDefectIds.MUST_CONTAIN_ANY_MORE_CONDITIONS)
            .registerWithDefault(PerformanceFilterDefects.PerformanceFilterDefectIds.INVALID_OPERATOR)
            .registerWithDefault(PerformanceFilterDefects.PerformanceFilterDefectIds.UNKNOWN_OPERATOR)
            .registerWithDefault(PerformanceFilterDefects.PerformanceFilterDefectIds.UNKNOWN_FIELD)
            .registerWithDefault(PerformanceFilterDefects.PerformanceFilterNumberDefectIds.FILTER_COUNT_IS_TOO_LARGE)

            //inventori (campaigns)
            .registerWithDefault(INVALID_CAMPAIGN_TYPE)
            .registerWithDefault(CAMPAIGN_NOT_EXISTS)
            .registerWithDefault(CAMPAIGN_ALREADY_DELETED)
            .registerWithDefault(INVALID_CAMPAIGN_STRATEGY)
            .registerWithDefault(INVALID_GROUP_TYPE)

            //inventori (inventori)
            .registerWithDefault(UNSUPPORTED_ERROR)
            .registerWithDefault(INTERNAL_ERROR)
            .registerWithDefault(NO_SUITABLE_ADGROUPS)
            .registerWithDefault(CONTAINS_KEYWORD_ADGROUPS)
            .registerWithDefault(NO_GROUPS)
            .registerWithDefault(INVALID_DATES)
            .registerWithDefault(INVALID_REQUEST)
            .registerWithDefault(INVALID_RF)
            .registerWithDefault(UNKNOWN_SEGMENTS)
            .registerWithDefault(UNSUPPORTED_SEGMENTS)
            .registerWithDefault(LOW_REACH)
            .registerWithDefault(INVALID_BUDGET)
            .registerWithDefault(INVALID_CPM)
            .registerWithDefault(UNEXPECTED_INVENTORI_PROBLEM_WITH_CAMPAIGN)
            .registerWithDefault(UNEXPECTED_INVENTORI_COMMON_PROBLEM)

            //video segment goals
            .registerWithDefault(UsersSegmentDefectIds.Gen.AD_GROUP_TYPE_NOT_SUPPORTED)
            .registerWithDefault(UsersSegmentDefectIds.Gen.GOAL_TYPE_NOT_SUPPORTED_IN_AD_GROUP)

            // internal ads
            .registerWithDefault(InternalAdsAccessGroupDefects.Gen.INVALID_ROLE)
            .registerWithDefault(InternalAdDefectIds.UNKNOWN_CLIENT_ID)
            .registerWithDefault(InternalAdDefectIds.PRODUCT_ACCESS_EXISTS)
            .registerWithDefault(InternalAdDefectIds.PRODUCT_ACCESS_DOES_NOT_EXIST)
            .registerWithDefault(InternalAdDefectIds.PRODUCT_WITH_THIS_NAME_ALREADY_EXISTS)
            .registerWithDefault(InternalAdDefectIds.INVALID_PLACE_ID)
            .registerWithDefault(InternalAdDefectIds.TEMPLATE_NOT_FOUND)
            .registerWithDefault(InternalAdDefectIds.REQUIRED_IMPRESSION_RATE_DUE_TO_RF_CLOSE_BY_CLICK)
            .registerWithDefault(InternalAdStringDefectIds.URL_UNREACHABLE)
            .registerWithDefault(InternalAdStringDefectIds.RESOURCE_RESTRICTIONS_NOT_FOLLOWED)

            // performance banners
            .register(PerformanceBannerMainDefectIds.BANNER_IN_THIS_ADGROUP_ALREADY_EXISTS,
                    t -> AdsDefectTypes.bannerInThisAdgroupAlreadyExists())
            .register(PerformanceBannerMainDefectIds.BANNERS_WITHOUT_CREATIVE_NOT_ENABLED,
                    t -> AdsDefectTypes.bannersWithoutCreativeNotEnabled())

            //promoextensions
            .registerWithDefault(PromoExtensionNumericDefectIds.MAX_COUNT_OF_PROMO_EXTENSIONS_CREATED)

            //dynamictextadtargets and dynamicfeedadtargets
            .registerWithDefault(DynamicTextAdTargetDefectIds.Strings.NUMBER_ARGUMENTS_MUST_BE_FROM_TO)
            .registerWithDefault(DynamicTextAdTargetDefectIds.Strings.EXCEEDED_MAX_LENGTH_IN_ARGUMENTS)
            .registerWithDefault(DynamicTextAdTargetDefectIds.Strings.INVALID_URL_FORMAT)
            .registerWithDefault(DynamicTextAdTargetDefectIds.Strings.INVALID_EMPTY_URL_FORMAT)
            .registerWithDefault(DynamicTextAdTargetDefectIds.Strings.INVALID_LETTERS_IN_RULE)
            .registerWithDefault(DynamicTextAdTargetDefectIds.Strings.EXCEEDED_MAX_LENGTH_IN_NAME)
            .registerWithDefault(DynamicTextAdTargetDefectIds.Strings.INVALID_EMPTY_NAME_FORMAT)
            .registerWithDefault(DynamicTextAdTargetDefectIds.Strings.INVALID_LETTERS_IN_NAME)
            .registerWithDefault(DynamicTextAdTargetDefectIds.Gen.AD_GROUP_NOT_FOUND)
            .registerWithDefault(DynamicTextAdTargetDefectIds.Gen.NOT_ACCEPTABLE_AD_GROUP_TYPE)
            .registerWithDefault(DynamicTextAdTargetDefectIds.Gen.ALL_PAGE_CONDITION_NOT_WITH_ANOTHER)
            .registerWithDefault(DynamicTextAdTargetDefectIds.Gen.DUPLICATE_RULES_IN_CONDITION)
            .registerWithDefault(DynamicTextAdTargetDefectIds.Num.INVALID_FORMAT_WEBPAGE_CONDITION)
            .registerWithDefault(DynamicTextAdTargetDefectIds.Num.NUMBER_OF_RULES_MUST_BE_FROM_TO)
            .registerWithDefault(DynamicTextAdTargetDefectIds.Num.MAX_COUNT_IN_ADGROUP)

            // price packages
            .registerWithDefault(PricePackageDefectIds.Gen.CLIENT_CURRENCY_NOT_EQUALS_PACKAGE_CURRENCY)
            .registerWithDefault(PricePackageDefectIds.Gen.GEO_EXPANDED_IS_EMPTY)
            .registerWithDefault(PricePackageDefectIds.Gen.PRICE_PACKAGE_IS_EXPIRED)
            .registerWithDefault(PricePackageDefectIds.Gen.CRYPTA_TYPES_COUNT_IS_MISMATCHED)
            .registerWithDefault(PricePackageDefectIds.Gen.CREATIVE_TEMPLATES_IS_EMPTY)
            .registerWithDefault(PricePackageDefectIds.Gen.CREATIVE_TEMPLATES_AND_AD_GROUP_TYPES_MISMATCHED)
            .registerWithDefault(PricePackageDefectIds.DateTime.USER_TIMESTAMP_NOT_EQUALS_LAST_UPDATE_TIME)
            .registerWithDefault(PricePackageDefectIds.Gen.MUTUAL_EXCLUSIVE_BID_MODIFIERS_SELECTED)
            .registerWithDefault(PricePackageDefectIds.Gen.DATE_START_CAN_ONLY_EXPAND)
            .registerWithDefault(PricePackageDefectIds.Gen.DATE_END_CAN_ONLY_EXPAND)
            .registerWithDefault(PricePackageDefectIds.Gen.CREATIVE_TEMPLATES_CAN_ONLY_EXPAND)
            .registerWithDefault(PricePackageDefectIds.Gen.RETARGETING_CATEGORIES_AMOUNT_LESS_LOWER_LIMIT)
            .registerWithDefault(PricePackageDefectIds.Gen.RETARGETING_CATEGORIES_AMOUNT_GREATER_UPPER_LIMIT)
            .registerWithDefault(PricePackageDefectIds.Gen.OVERLAPPING_PRICE_MARKUPS)

            //turbolandings
            .registerWithDefault(TurboLandingDefectIds.MODERATION_REQUIRED_ATTRIBUTE_CANT_BE_CHANGED)
            .registerWithDefault(TurboLandingDefectIds.INCONSISTENT_STATE_OF_MODERATION_STATUS)

            //user
            .registerWithDefault(UserDefectIds.Gen.USER_NOT_FOUND)
            .registerWithDefault(UserDefectIds.Gen.USER_IS_NOT_REPRESENTATIVE)
            .registerWithDefault(UserDefectIds.Gen.USER_IS_BLOCKED)
            .registerWithDefault(UserDefectIds.Gen.USER_ASSOCIATED_WITH_ANOTHER_CLIENT)
            .registerWithDefault(UserDefectIds.Gen.USER_HAS_CARD_PAYMENT_METHOD)
            .registerWithDefault(UserDefectIds.Gen.USER_HAS_NOT_VALID_NAME)
            .registerWithDefault(UserDefectIds.Gen.USER_HAS_NOT_VALID_EMAIL)
            .registerWithDefault(UserDefectIds.Gen.BALANCE_USER_ASSOCIATED_WITH_ANOTHER_CLIENT)
            .registerWithDefault(UserDefectIds.Gen.USER_HAS_ACTIVE_AUTOPAY)
            .registerWithDefault(UserDefectIds.Gen.CHIEF_DELETION_PROHIBITED)
            .registerWithDefault(UserDefectIds.Gen.USER_MUST_BE_MANAGER)
            .registerWithDefault(UserDefectIds.Gen.USER_MUST_BE_MANAGER_IN_BALANCE)
            .registerWithDefault(UserDefectIds.Gen.USER_CANT_BE_UNBLOCKED)
            .registerWithDefault(UserDefectIds.Gen.USER_HAS_NO_AVAILABLE_CURRENCIES)

            // uac
            .registerWithDefault(AppInfoDefectIds.Gen.APP_INFO_NOT_FOUND)
            .registerWithDefault(TrackingUrlDefectIds.Gen.INVALID_TRACKING_URL)
            .registerWithDefault(TrackingUrlDefectIds.Gen.INVALID_IMPRESSION_URL)
            .registerWithDefault(TrackingUrlDefectIds.Gen.TRACKING_URL_WRONG_REDIRECT)
            .registerWithDefault(TrackingUrlDefectIds.Gen.CANNOT_MAKE_IMPRESSION_URL)
            .registerWithDefault(ContentDefectIds.Gen.SIZE_OF_IMAGE_CONTENTS_CANNOT_BE_MORE_THAN_MAX)
            .registerWithDefault(ContentDefectIds.Gen.SIZE_OF_VIDEO_CONTENTS_CANNOT_BE_MORE_THAN_MAX)
            .registerWithDefault(ContentDefectIds.Canvas.INVALIDATED_BY_CANVAS)
            .registerWithDefault(ParseAppInfoUrlDefectIds.Gen.INVALID_APP_STORE_URL)
            .registerWithDefault(ParseAppInfoUrlDefectIds.Gen.INVALID_APP_ID)
            .registerWithDefault(ParseAppInfoUrlDefectIds.Gen.INVALID_GOOGLE_PLAY_URL)
            .registerWithDefault(ParseAppInfoUrlDefectIds.Gen.INVALID_ITUNES_URL)
            .registerWithDefault(ParseAppInfoUrlDefectIds.Gen.INVALID_URL)
            .registerWithDefault(ParseAppInfoUrlDefectIds.Gen.MULTIPLE_PARAMS)

            // hypergeo
            .registerWithDefault(HyperGeoDefectIds.Gen.COUNT_OF_SEGMENTS_MUST_BE_IN_INTERVAL)

            // verified phones
            .registerWithDefault(DefectIds.PHONE_MUST_BE_VERIFIED)

            .registerWithDefault(DefectIds.PROMOCODE_DOMAIN_OR_CLIENT_DOES_NOT_MATCH)
            .registerWithDefault(DefectIds.PROMOCODE_CLIENT_DOES_NOT_MATCH)
            .registerWithDefault(DefectIds.PROMOCODE_CLIENT_DOMAIN_DOES_NOT_MATCH)
            .registerWithDefault(DefectIds.PROMOCODE_CLIENT_HAS_MULTIPLE_DOMAINS)

            //feed offer
            .registerWithDefault(FeedOfferDefects.FeedOfferDefectIds.NO_OFFERS)
            .registerWithDefault(FeedOfferDefects.FeedOfferDefectIds.UNKNOWN_OFFER_ID)
            .registerWithDefault(FeedOfferDefects.FeedOfferDefectIds.OFFER_ID_NOT_UNIQUE)
            .registerWithDefault(FeedOfferDefects.FeedOfferDefectIds.CLIENT_NOT_EXIST_IN_GRUT)
            .registerWithDefault(FeedOfferDefects.FeedOfferDefectIds.INVALID_HREF)
            .registerWithDefault(FeedOfferDefects.FeedOfferDefectIds.HREF_NOT_UNIQUE)
            .registerWithDefault(FeedOfferDefects.FeedOfferDefectIds.NO_IMAGES)
            .registerWithDefault(FeedOfferDefects.FeedOfferNumberDefectIds.OFFER_COUNT_IS_TOO_LARGE)
            .registerWithDefault(FeedOfferDefects.FeedOfferNumberDefectIds.IMAGE_COUNT_IS_TOO_LARGE)
            .registerWithDefault(FeedOfferDefects.FeedOfferNumberDefectIds.OLD_PRICE_LESS_OR_EQUAL_THAN_CURRENT)

            // multipart files
            .registerWithDefault(DefectIds.FILE_MIME_TYPE_IS_NOT_SUPPORTED)
            .registerWithDefault(DefectIds.NO_CONTENT_TYPE)

            .build();

    private DefaultApiPresentations() {
    }

    private static void registerCommon(DefectPresentationsHolder.Builder builder) {
        builder
                .register(DefectIds.MUST_BE_NULL, t -> invalidValue())
                .register(DefectIds.MUST_BE_EMPTY, t -> invalidValue())
                .register(DefectIds.MUST_BE_WHOLE_NUMBER, t -> invalidValue())
                .register(DefectIds.CANNOT_BE_NULL, t -> invalidValue())
                .register(DefectIds.CANNOT_BE_EMPTY, t -> DefectTypes.emptyValue())
                .register(DefectIds.ABSENT_REQUIRED_FIELD, t -> DefectTypes.absent())
                .register(DefectIds.INVALID_VALUE, t -> invalidValue())
                .register(DefectIds.INVALID_FORMAT, t -> invalidFormat())
                .register(DefectIds.MUST_BE_VALID_ID, t -> DefectTypes.invalidId())
                .register(DefectIds.MUST_BE_VALID_LOGIN, t -> invalidValue())
                .register(DefectIds.LOGIN_CANNOT_BE_PDD, t -> invalidValue())
                .register(DefectIds.OBJECT_NOT_FOUND,
                        t -> DefectTypes.notFound()
                                /* suppress detailed message
                                https://st.yandex-team.ru/DIRECT-69374 */
                                .withDetailedMessage((Translatable) null))
                .register(DefectIds.UNABLE_TO_DELETE, t -> DefectTypes.unableToDelete())
                .register(DefectIds.FORBIDDEN_TO_CHANGE, t -> DefectTypes.forbiddenToChange())
                .register(DefectIds.NO_RIGHTS_CANT_WRITE, t -> DefectTypes.noRightsCantWrite())
                .register(DefectIds.INCONSISTENT_STATE,
                        t -> inconsistentState())
                .register(DefectIds.INCONSISTENT_STATE_ALREADY_EXISTS,
                        t -> DefectTypes.inconsistentStateAlreadyExists())
                .register(DefectIds.REQUIRED_BUT_EMPTY, t -> requiredButEmpty())
                .register(DefectIds.NO_RIGHTS, t -> DefectTypes.noRights())
                .register(DefectIds.MUST_CONTAIN_LETTERS, t -> DefectTypes.mustContainLetters())
                .register(DefectIds.MUST_CONTAIN_LETTERS_OR_DIGITS_OR_PUNCTUATIONS,
                        t -> DefectTypes.mustContainLettersOrDigitsOrPunctuations())
                .register(DefectIds.CAMPAIGN_STATUS_ARCHIVED,
                        t -> DefectTypes.badStatusCampaignArchived())
                .register(DefectIds.UNKNOWN_PARAMETER,
                        t -> DefectTypes.unknownParameter())
                .register(DefectIds.ONE_OF_HREF_OR_TURBOLANDING_ID_MUST_BE_NOT_NULL,
                        t -> DefectTypes.hrefOrTurboPageIdMustBeNotNull())
                .register(DefectIds.METRIKA_RETURNS_RESULT_WITH_ERRORS,
                        t -> invalidValue())
                .register(DefectIds.FAILED_TO_ACQUIRE_LOCK,
                        t -> invalidValue());
    }

    private static void registerBaseTypes(DefectPresentationsHolder.Builder builder) {
        builder
                //collections
                .register(CollectionDefectIds.Size.MAX_ELEMENTS_PER_REQUEST,
                        t -> maxElementsPerRequest(t.getMaxSize()))
                .register(CollectionDefectIds.Size.MAX_ELEMENTS_EXCEEDED,
                        t -> DefectTypes.maxElementsExceeded(t.getMaxSize()))
                .register(CollectionDefectIds.Gen.MUST_NOT_CONTAIN_DUPLICATED_OBJECTS,
                        t -> duplicatedObject())
                .register(CollectionDefectIds.Size.SIZE_CANNOT_BE_MORE_THAN_MAX,
                        t -> DefectTypes.maxCollectionSize(t.getMaxSize()))
                .register(CollectionDefectIds.Size.SIZE_CANNOT_BE_LESS_THAN_MIN,
                        t -> DefectTypes.minCollectionSize(t.getMinSize()))
                .register(CollectionDefectIds.Size.SIZE_MUST_BE_IN_INTERVAL,
                        t -> invalidCollectionSize(t.getMinSize(), t.getMaxSize()))
                .register(CollectionDefectIds.Size.INVALID_COLLECTION_SIZE,
                        t -> invalidCollectionSize(t.getMinSize(), t.getMaxSize()))
                .register(CollectionDefectIds.Gen.CANNOT_BE_EMPTY, t -> DefectTypes.emptyElementsList())
                .register(CollectionDefectIds.Gen.MUST_BE_EMPTY, t -> DefectTypes.emptyElementsList())
                .register(CollectionDefectIds.Gen.MUST_BE_IN_COLLECTION, t -> invalidValue())
                .register(CollectionDefectIds.Gen.MUST_NOT_BE_IN_COLLECTION, t -> invalidValue())
                .register(CollectionDefectIds.Gen.CANNOT_CONTAIN_NULLS, t -> DefectTypes.absentElementInArray())

                .register(AdDefectIds.AdIds.REQUIRED_IMPRESSION_RATE_DUE_TO_ADS_HAS_CLOSE_COUNTER,
                        t -> invalidValue())
                //strings
                .register(StringDefectIds.LENGTH_CANNOT_BE_MORE_THAN_MAX,
                        t -> DefectTypes.maxStringSize(t.getMaxLength()))
                .register(StringDefectIds.LENGTH_CANNOT_BE_LESS_THAN_MIN, t -> invalidValue())
                .register(StringDefectIds.LENGTH_MUST_BE_IN_THE_INTERVAL, t -> invalidValue())
                .register(StringDefectIds.CANNOT_BE_EMPTY, t -> DefectTypes.emptyValue())
                .register(StringDefectIds.CANNOT_CONTAIN_SYMBOLS, t -> DefectTypes.invalidChars())
                .register(StringDefectIds.MUST_CONTAIN_ONLY_SYMBOLS, t -> DefectTypes.invalidChars())
                .register(StringDefectIds.MAX_COUNT_WORDS_IN_KEYWORD,
                        t -> DefectTypes.keywordMaxLength(t.getMaxLength()))
                .register(StringDefectIds.REQUIRED_BUT_EMPTY, t -> requiredButEmpty())

                //numbers
                .register(NumberDefectIds.MUST_BE_LESS_THEN_MAX, t -> invalidValue())
                .register(NumberDefectIds.MUST_BE_GREATER_THAN_MIN, t -> invalidValue())
                .register(NumberDefectIds.MUST_BE_LESS_THEN_OR_EQUAL_TO_MAX, t -> invalidValue())
                .register(NumberDefectIds.MUST_BE_GREATER_THAN_OR_EQUAL_TO_MIN,
                        t -> invalidValueNotLessThan(t.getMin()))
                .register(NumberDefectIds.MUST_BE_IN_THE_INTERVAL_INCLUSIVE,
                        t -> fieldMustBeInRange(t.getMin(), t.getMax()))
                .register(NumberDefectIds.MUST_BE_IN_THE_INTERVAL_EXCLUDING_BORDERS, t -> invalidValue())
                .register(NumberDefectIds.MUST_BE_NOT_OLDER, t -> invalidValue())


                //dates
                .register(DateDefectIds.MUST_BE_LESS_THAN_MAX, t -> invalidValue())
                .register(DateDefectIds.MUST_BE_LESS_THAN_OR_EQUAL_TO_MAX, t -> invalidValue())
                .register(DateDefectIds.MUST_BE_GREATER_THAN_MIN, t -> invalidValue())
                .register(DateDefectIds.MUST_BE_GREATER_THAN_OR_EQUAL_TO_MIN, t -> invalidValue())
                .register(DateDefectIds.MUST_BE_IN_THE_INTERVAL_INCLUSIVE, t -> invalidValue())
                .register(DateDefectIds.MUST_BE_IN_THE_INTERVAL_EXCLUDING_BORDERS, t -> invalidValue())
                .register(DateDefectIds.END_DATE_MUST_BE_GREATER_THAN_OR_EQUAL_TO_START_DATE, t -> invalidValue())

                //times
                .register(DateTimeDefectIds.MUST_BE_GREATER_THAN_MIN, t -> invalidValue())
                .register(DateTimeDefectIds.BROAD_HISTORY_TIME_INTERVAL, t -> invalidValue());
    }

    private static void registerRetargetings(DefectPresentationsHolder.Builder builder) {
        builder
                //retargeting
                .register(RetargetingDefectIds.Gen.MAX_IDS_IN_SELECTION, t -> DefectTypes.maxIdsInSelection())
                .register(RetargetingDefectIds.Gen.ABSENT_IDS_IN_SELECTION, t -> DefectTypes.absentIdsInSelection())
                .register(RetargetingDefectIds.Gen.DUPLICATED_RETARGETING_CONDITION_ID,
                        t -> duplicatedObject()
                                .withDetailedMessage(
                                        CommonDefectTranslations.INSTANCE.duplicatedRetargetingConditionId()))
                .register(RetargetingDefectIds.Gen.CANNOT_CHANGE_RETARGETING_SCOPE, t -> DefectTypes.invalidUseOfField()
                        .withDetailedMessage(CommonDefectTranslations.INSTANCE.errorRetargetingScopeChange()))
                .register(RetargetingDefectIds.Gen.LIMIT_MUST_BE_GREATER_THAN_ZERO,
                        t -> DefectTypes.incorrectPageNonPositiveLimit())
                .register(RetargetingDefectIds.Nums.LIMIT_MUST_BE_LESS_THAN_VALUE,
                        t -> DefectTypes.incorrectPageLimitExceeded(t.getMax().intValue()))
                .register(RetargetingDefectIds.Gen.NO_NEEDED_PARAMS_IN_SELECTION,
                        t -> DefectTypes.noNeededParamsInSelection())
                .register(RetargetingDefectIds.Gen.OFFSET_MUST_BE_POSITIVE,
                        t -> DefectTypes.incorrectPageNegativeOffset())
                .register(RetargetingDefectIds.Gen.REQUIRED_TIME_FOR_GOAL_OR_SEGMENT,
                        t -> DefectTypes.requiredButEmptyTimeForGoalOrSegment())
                .register(RetargetingDefectIds.Gen.INVALID_USE_OF_FIELD_EXTRA_FIELD_FOR_GOAL_OR_SEGMENT,
                        t -> DefectTypes.invalidUseOfFieldExtraFieldForGoalOrSegment())
                .register(RetargetingDefectIds.Gen.INVALID_GOALS_FOR_TYPE, t -> inconsistentState()
                        .withDetailedMessage(CommonDefectTranslations.INSTANCE.invalidGoalsForTypeNoneDetailed()))
                .register(RetargetingDefectIds.Gen.DUPLICATED_OBJECT_WITH_NAME, t -> duplicatedObject()
                        .withDetailedMessage(CommonDefectTranslations.INSTANCE.duplicatedObjectNameDetailed()))
                .register(RetargetingDefectIds.Gen.DUPLICATED_OBJECT_WITH_RULES, t -> duplicatedObject()
                        .withDetailedMessage(CommonDefectTranslations.INSTANCE.duplicatedRetConditionRulesDetailed()))

                .register(RetargetingDefectIds.Gen.AUDIENCE_NOT_FOUND, t -> DefectTypes.audienceTargetNotFound())
                .register(RetargetingDefectIds.Gen.DUPLICATED_RETARGETING_ID, t -> duplicatedObject()
                        .withDetailedMessage(CommonDefectTranslations.INSTANCE.duplicatedRetargetingId()))
                .register(RetargetingDefectIds.Gen.NOT_FOUND, t -> DefectTypes.notFoundRetargeting())
                .register(RetargetingDefectIds.Gen.WARNING_NOT_SUSPENDED,
                        t -> DefectTypes.warningNotSuspendedRetargeting())
                .register(RetargetingDefectIds.Gen.WARNING_ALREADY_SUSPENDED,
                        t -> DefectTypes.warningAlreadySuspendedRetargeting())
                .register(RetargetingDefectIds.Gen.WARNING_DUPLICATED_RETARGETING_ID,
                        t -> DefectTypes.warningDuplicatedRetargetingId())

                .register(RetargetingDefectIds.Gen.RETARGETING_CONDITION_ALREADY_EXISTS,
                        t -> DefectTypes.alreadyExists()
                                .withDetailedMessage(
                                        CommonDefectTranslations.INSTANCE.retargetingConditionAlreadyExists()))
                .register(RetargetingDefectIds.Gen.INVALID_RETARGETING_CONDITION,
                        t -> inconsistentState().withDetailedMessage(
                                CommonDefectTranslations.INSTANCE.retargetingConditionIsInvalidForRetargeting()))
                .register(RetargetingDefectIds.Gen.INVALID_RETARGETING_CONDITION_BY_PRICE_PACKAGE,
                        t -> inconsistentState().withDetailedMessage(
                                CommonDefectTranslations.INSTANCE.retargetingConditionIsInvalidForPricePackage()))
                .register(RetargetingDefectIds.Gen.INCONSISTENT_RETARGETING_CONDITION_BY_DEFAULT_ADGROUP,
                        t -> inconsistentState().withDetailedMessage(
                                CommonDefectTranslations.INSTANCE.retargetingConditionIsInvalidForDefaultAdGroup()))
                .register(RetargetingDefectIds.Gen.RETARGETING_CONDITION_NOT_FOUND,
                        t -> DefectTypes.notFound().withDetailedMessage(
                                CommonDefectTranslations.INSTANCE.retargetingConditionNotFoundDetailed()))
                .register(RetargetingDefectIds.IdParametrized.RETARGETING_CONDITION_NOT_FOUND_WITH_ID,
                        t -> DefectTypes.notFound().withDetailedMessage(
                                CommonDefectTranslations.INSTANCE
                                        .retargetingConditionNotFoundDetailedWithId(new Identity(t.getId()))))
                .register(RetargetingDefectIds.Gen.INCONSISTENT_STATE_TARGETING_CATEGORY,
                        t -> DefectTypes.inconsistentStateTargetingCategoryUnavailable())
                .register(RetargetingDefectIds.Gen.NOT_ELIGABLE_ADGROUP,
                        t -> DefectTypes.notEligibleObject()
                                .withDetailedMessage(CommonDefectTranslations.INSTANCE.notEligibleAdGroupDetailed()))
                .register(RetargetingDefectIds.Gen.DUPLICATED_RETARGETING_CONDITION_ID_FOR_ADGROUP_ID,
                        t -> duplicatedObject().withDetailedMessage(
                                CommonDefectTranslations.INSTANCE.duplicatedRetargetingConditionIdForAdGroupId()))

                .register(RetargetingDefectIds.Gen.ALL_GOALS_MUST_BE_EITHER_FROM_METRIKA_OR_CRYPTA,
                        t -> inconsistentState().withDetailedMessage(
                                CommonDefectTranslations.INSTANCE.allGoalsAreEitherFromMetrikaOrCrypta()))
                .register(RetargetingDefectIds.Gen.CRYPTA_GOALS_ALLOWED_ONLY_FOR_OR_CONDITION,
                        t -> inconsistentState().withDetailedMessage(
                                CommonDefectTranslations.INSTANCE.cryptaGoalsAllowedOnlyForOrCondition()))
                .register(RetargetingDefectIds.Gen.INTERESTS_TYPE_IS_NOT_SPECIFIED,
                        t -> inconsistentState().withDetailedMessage(
                                CommonDefectTranslations.INSTANCE.interestsTypeIsNotSpecified()))
                .register(RetargetingDefectIds.Gen.CRYPTA_GOALS_ALLOWED_ONLY_FOR_INTERESTS_TYPE,
                        t -> inconsistentState().withDetailedMessage(
                                CommonDefectTranslations.INSTANCE.cryptaGoalsAllowedOnlyForInterestsType()))
                .register(RetargetingDefectIds.Gen.ALL_CRYPTA_GOALS_MUST_HAVE_SAME_TYPE,
                        t -> inconsistentState().withDetailedMessage(
                                CommonDefectTranslations.INSTANCE.allCryptaGoalsMustHaveSameType()))
                .register(RetargetingDefectIds.Gen.ALL_SOCIAL_DEMO_GOALS_MUST_HAVE_SAME_PARENT_ID,
                        t -> inconsistentState().withDetailedMessage(
                                CommonDefectTranslations.INSTANCE.allSocialDemoGoalsMustHaveSameParentId()))
                .register(RetargetingDefectIds.Gen.MUST_NOT_CONTAIN_ALL_ELEMENTS,
                        t -> inconsistentState().withDetailedMessage(
                                CommonDefectTranslations.INSTANCE.mustNotContainAllElements()))
                .register(RetargetingDefectIds.Gen.MUST_CONTAIN_POSITIVE_ELEMENT,
                        t -> inconsistentState().withDetailedMessage(
                                CommonDefectTranslations.INSTANCE.allElementsAreNegative()))
                .register(RetargetingDefectIds.Gen.UNSUPPORTED_GOAL_ID,
                        t -> inconsistentState().withDetailedMessage(
                                RetargetingDefectTranslations.INSTANCE.unsupportedGoalId()))
                .register(RetargetingDefectIds.Gen.INTEREST_LIMIT_EXCEEDED,
                        t -> inconsistentState().withDetailedMessage(
                                CommonDefectTranslations.INSTANCE
                                        .interestLimitExceeded(MAX_INTEREST_RULES_PER_CONDITION)))
                .register(RetargetingDefectIds.Gen.CPM_YNDX_FRONTPAGE_RETARGETINGS_NOT_ALLOWED,
                        t -> DefectTypes.notEligibleObject().withDetailedMessage(
                                RetargetingDefectTranslations.INSTANCE.cpmYndxFrontpageRetargetingsNotAllowed()))
                .register(RetargetingDefectIds.Gen.INVALID_RETARGETING_CONDITION_IN_USER_PROFILE_FOR_TGO,
                        t -> inconsistentState().withDetailedMessage(
                                CommonDefectTranslations.INSTANCE.invalidRetargetingConditionInUserProfileInTgo()))
                .register(RetargetingDefectIds.Gen.DUPLICATED_GOAL,
                        t -> inconsistentState().withDetailedMessage(
                                CommonDefectTranslations.INSTANCE.duplicatedGoal()))

                .register(RetargetingDefectIds.Nums.MAX_SIZE_IN_ADGROUP,
                        t -> DefectTypes.maxCollectionSizeAdGroup(t.getMax().intValue()))
                .register(RetargetingDefectIds.Nums.MAX_SIZE_IN_CPM_ADGROUP,
                        t -> DefectTypes.maxCollectionSizeCpmAdGroup(t.getMax().intValue()))
                .register(RetargetingDefectIds.Nums.MAX_SIZE_USER_PROFILE_IN_CPM_ADGROUP,
                        t -> DefectTypes.maxCollectionSizeAdGroupUserProfile(t.getMax().intValue()))
                .register(RetargetingDefectIds.FieldRequirements.MUTUALLY_EXCLUSIVE_PARAMETERS,
                        t -> DefectTypes.mutuallyExclusiveParameters(t.getPath1(), t.getPath2()))
                .register(RetargetingDefectIds.FieldRequirements.LEAST_ONE_FIELD_REQUIRED,
                        t -> DefectTypes.requiredAtLeastOneOfFields(t.getPath1(), t.getPath2()))

                .register(RetargetingDefectIds.IdParametrized.ADGROUP_NOT_FOUND,
                        t -> DefectTypes.notFound().withDetailedMessage(
                                CommonDefectTranslations.INSTANCE.adGroupNotFoundDetailed(new Identity(t.getId()))))
                .register(RetargetingDefectIds.Gen.NO_RIGHTS_IN_ARCHIVED_ADGROUP,
                        t -> DefectTypes.noRights().withDetailedMessage(
                                RetargetingDefectTranslations.INSTANCE.retargetingModificationInArchivedAdGroup()))
                .register(RetargetingDefectIds.Gen.AUDIENCE_TARGET_ALLOWED_IN_MOBILE_CONTENT_CAMPAIGN,
                        t -> DefectTypes.notEligibleObject().withDetailedMessage(
                                RetargetingDefectTranslations.INSTANCE.audienceTargetAllowedInMobileContentCampaign()))
                .register(RetargetingDefectIds.IdParametrized.CAMPAIGN_STATUS_ARCHIVED_ON_ADD,
                        t -> DefectTypes.badStatusCampaignArchivedOnAddRetargeting(t.getId()))
                .register(RetargetingDefectIds.IdParametrized.CAMPAIGN_STATUS_ARCHIVED_ON_DELETE,
                        t -> DefectTypes.cantRemoveAudienceTargetFromArchivedCampaign(t.getId()))
                .register(RetargetingDefectIds.IdParametrized.CAMPAIGN_STATUS_ARCHIVED_ON_SUSPEND,
                        t -> DefectTypes.badStatus().withDetailedMessage(
                                CommonDefectTranslations.INSTANCE
                                        .badCampaignStatusArchivedOnSuspend(new Identity(t.getId()))))
                .register(RetargetingDefectIds.IdParametrized.CAMPAIGN_STATUS_ARCHIVED_ON_RESUME,
                        t -> DefectTypes.badStatus().withDetailedMessage(
                                CommonDefectTranslations.INSTANCE
                                        .badCampaignStatusArchivedOnResume(new Identity(t.getId()))));
    }

    private static void registerInternalAds(DefectPresentationsHolder.Builder builder) {
        builder
                .register(InternalAdRestrictionDefects.Url.URL_NOT_VALID, t -> invalidValue())
                .register(InternalAdRestrictionDefects.UrlWithSpaces.URL_HAS_SPACES, t -> invalidValue())
                .register(InternalAdRestrictionDefects.Length.TEXT_TOO_LONG, t -> invalidValue())
                .register(InternalAdRestrictionDefects.Length.TEXT_TOO_SHORT, t -> invalidValue())
                .register(InternalAdRestrictionDefects.Text.TEXT_HAS_SPACES_AROUND, t -> invalidValue())
                .register(InternalAdRestrictionDefects.ImageSize.IMAGE_SIZE_KB_TOO_BIG, t -> invalidValue())
                .register(InternalAdRestrictionDefects.ImageFormat.IMAGE_FORMAT_INVALID, t -> invalidValue())
                .register(InternalAdRestrictionDefects.ImageDimension.IMAGE_DIMENSION_NOT_EQUAL, t -> invalidValue())
                .register(InternalAdRestrictionDefects.ImageDimension.IMAGE_DIMENSION_NOT_SQUARE, t -> invalidValue())
                .register(InternalAdRestrictionDefects.ImageDimension.IMAGE_DIMENSION_TOO_BIG, t -> invalidValue())
                .register(InternalAdRestrictionDefects.ImageDimension.IMAGE_DIMENSION_TOO_SMALL, t -> invalidValue())
                .register(InternalAdRestrictionDefects.Gen.FORMAT_INVALID, t -> invalidValue());
    }

    private static void registerVcards(DefectPresentationsHolder.Builder builder) {
        builder
                // отдельная ошибка создана из-за текста детализации ошибки, ожидаемой в автотестах
                .register(ApiDefectIds.Gen.MAX_IDS_IN_SELECTION_VCARD,
                        t -> DefectTypes.maxElementsInSelection(DEFAULT_MAX_IDS_COUNT))

                .register(VcardDefectIds.Gen.VCARD_IS_IN_USE, t -> VCardDefectTypes.vcardIsInUse())

                .register(VcardDefectIds.Gen.BANNERS_WITH_VCARD_ID_NOT_FOUND, t -> invalidValue())
                .register(VcardDefectIds.Gen.VCARD_HAS_VALIDATION_ERRORS, t -> invalidValue())
                .register(VcardDefectIds.Gen.INCONSISTENT_VCARD_CID_AND_CAMPAIGN_ID, t -> invalidValue())

                .register(InstantMessengerValidator.VoidDefectIds.TYPE_IS_NULL, t -> invalidValue())
                .register(InstantMessengerValidator.VoidDefectIds.UNSUPPORTED_TYPE, t -> invalidValue())

                .register(InstantMessengerValidator.VoidDefectIds.LOGIN_IS_NULL,
                        t -> invalidValue())
                .register(InstantMessengerValidator.StringDefectIds.LOGIN_IS_TOO_LONG,
                        t -> invalidValue())

                .register(InstantMessengerValidator.VoidDefectIds.INVALID_ICQ_LOGIN_FORMAT,
                        t -> VCardDefectTypes.invalidIcqLoginFormat())
                .register(InstantMessengerValidator.VoidDefectIds.INVALID_MAIL_AGENT_LOGIN_FORMAT,
                        t -> VCardDefectTypes.invalidMailAgentLoginFormat())
                .register(InstantMessengerValidator.VoidDefectIds.INVALID_JABBER_LOGIN_FORMAT,
                        t -> VCardDefectTypes.invalidJabberLoginFormat())
                .register(InstantMessengerValidator.VoidDefectIds.INVALID_SKYPE_OR_MSN_LOGIN_FORMAT,
                        t -> VCardDefectTypes.invalidSkypeOrMsnLoginFormat())

                .register(OgrnConstraint.VoidDefectIds.INVALID_OGRN, t -> VCardDefectTypes.invalidValue())

                .register(PhoneValidator.VoidDefectIds.COUNTRY_CODE_IS_NULL,
                        t -> VCardDefectTypes.phoneCountryCodeIsNullOrEmpty())
                .register(PhoneValidator.StringLengthDefectIds.COUNTRY_CODE_IS_EMPTY,
                        t -> VCardDefectTypes.phoneCountryCodeIsNullOrEmpty())
                .register(PhoneValidator.StringLengthDefectIds.COUNTRY_CODE_IS_TOO_LONG,
                        t -> VCardDefectTypes.invalidCountryCodeFormat())
                .register(PhoneValidator.VoidDefectIds.COUNTRY_CODE_MUST_START_WITH_PLUS,
                        t -> VCardDefectTypes.countryCodeMustStartWithPlus())
                .register(PhoneValidator.CityCodeDefectIds.COUNTRY_CODE_MUST_NOT_START_WITH_PLUS,
                        VCardDefectTypes::countryCodeMustNotStartWithPlus)
                .register(PhoneValidator.VoidDefectIds.COUNTRY_CODE_FORMAT_IS_INVALID,
                        t -> VCardDefectTypes.invalidCountryCodeFormat())

                .register(PhoneValidator.VoidDefectIds.CITY_CODE_IS_NULL,
                        t -> VCardDefectTypes.phoneCityCodeIsNullOrEmpty())
                .register(PhoneValidator.StringLengthDefectIds.CITY_CODE_IS_EMPTY,
                        t -> VCardDefectTypes.phoneCityCodeIsNullOrEmpty())
                .register(PhoneValidator.StringLengthDefectIds.CITY_CODE_IS_TOO_LONG,
                        t -> VCardDefectTypes.invalidPhoneCityCodeFormat())
                .register(PhoneValidator.VoidDefectIds.CITY_CODE_FORMAT_IS_INVALID,
                        t -> VCardDefectTypes.invalidPhoneCityCodeFormat())

                .register(PhoneValidator.VoidDefectIds.PHONE_NUMBER_IS_NULL,
                        t -> VCardDefectTypes.phoneNumberIsNullOrEmpty())
                .register(PhoneValidator.StringLengthDefectIds.PHONE_NUMBER_IS_EMPTY,
                        t -> VCardDefectTypes.phoneNumberIsNullOrEmpty())
                .register(PhoneValidator.StringLengthDefectIds.PHONE_NUMBER_IS_TOO_SHORT,
                        t -> VCardDefectTypes.invalidPhoneFormat())
                .register(PhoneValidator.StringLengthDefectIds.PHONE_NUMBER_IS_TOO_LONG,
                        t -> VCardDefectTypes.invalidPhoneFormat())
                .register(PhoneValidator.VoidDefectIds.PHONE_NUMBER_FORMAT_IS_INVALID,
                        t -> VCardDefectTypes.invalidPhoneFormat())

                .register(PhoneValidator.StringLengthDefectIds.EXTENSION_IS_TOO_LONG,
                        t -> VCardDefectTypes.invalidPhoneExtensionFormat())
                .register(PhoneValidator.VoidDefectIds.EXTENSION_FORMAT_IS_INVALID,
                        t -> VCardDefectTypes.invalidPhoneExtensionFormat())

                .register(PhoneValidator.StringLengthDefectIds.ENTIRE_PHONE_LENGTH_IS_INVALID,
                        t -> VCardDefectTypes.invalidPhoneFormat())
                .register(PhoneValidator.StringLengthDefectIds.ENTIRE_PHONE_WITH_EXTENSION_IS_TOO_LONG,
                        t -> VCardDefectTypes.invalidPhoneFormat())

                .register(AddVcardValidationService.VoidDefectIds.CONTACT_EMAIL_IS_EMPTY,
                        t -> DefectTypes.absentValueInField())
                .register(AddVcardValidationService.StringLengthDefectIds.CONTACT_EMAIL_TOO_LONG,
                        t -> VCardDefectTypes.invalidContactEmailFormat())
                .register(AddVcardValidationService.VoidDefectIds.CONTACT_EMAIL_INVALID_FORMAT,
                        t -> VCardDefectTypes.invalidContactEmailFormat())


                .register(MetroIdValidator.DefectIds.METRO_CITY_IS_REQUIRED,
                        t -> VCardDefectTypes.metroCityIsRequired())
                .register(MetroIdValidator.DefectIds.INVALID_METRO,
                        t -> VCardDefectTypes.invalidMetro())

                .register(WorkTimeConstraint.VoidDefectIds.WORKTIME_IS_EMPTY, t -> DefectTypes.absentValueInField())
                .register(WorkTimeConstraint.StringDefectIds.WORKTIME_IS_TOO_LONG, t -> invalidFormat())
                .register(WorkTimeConstraint.VoidDefectIds.WORKTIME_FORMAT_IS_INVALID, t -> invalidFormat())
                .register(WorkTimeConstraint.VoidDefectIds.WORKTIME_TIME_FORMAT_IS_INVALID,
                        t -> VCardDefectTypes.invalidWorktimeTimeFormat())
                .register(WorkTimeConstraint.VoidDefectIds.WORKTIME_MINUTE_NOT_DIVISIBLE_BY_15,
                        t -> VCardDefectTypes.worktimeMinuteNotDivisibleBy15())
                .register(WorkTimeConstraint.VoidDefectIds.WORKTIME_DAYS_DUPLICATED,
                        t -> VCardDefectTypes.worktimeDaysDuplicated())

                .register(VcardDefectIds.Gen.VCARD_IS_DUPLICATED, t -> VCardDefectTypes.vcardIsDuplicated());
    }

    private static void registerBanners(DefectPresentationsHolder.Builder builder) {
        builder
                .register(BannerDefectIds.Gen.ILLEGAL_COMMA, t -> AdsDefectTypes.illegalComma())
                .register(BannerDefectIds.Gen.SITELINK_DOMAIN_IS_NOT_FIT_TO_BANNER, t -> invalidValue())
                .register(BannerDefectIds.Gen.INSUFFICIENT_RIGHTS, t -> AdsDefectTypes.insufficientRights())
                .register(BannerDefectIds.Gen.INVALID_HREF, t -> AdsDefectTypes.invalidHref())
                .register(BannerDefectIds.Gen.INVALID_DOMAIN, t -> AdsDefectTypes.invalidHref())
                .register(BannerDefectIds.String.RESTRICTED_CHARS_IN_DISPLAY_HREF,
                        t -> AdsDefectTypes.invalidCharsInDisplayHref(t.getAllInvalidSubstrings()))
                .register(BannerDefectIds.Gen.DUPLICATE_SPECIAL_CHARS_IN_DISPLAY_HREF,
                        t -> AdsDefectTypes.duplicatedSpecCharsInDisplayHref())
                .register(BannerDefectIds.Gen.INVALID_TEMPLATE_QUERY, t -> AdsDefectTypes.invalidTemplateQuery())
                .register(BannerDefectIds.Gen.CANNOT_HAVE_TEMPLATE, t -> AdsDefectTypes.cannotHaveTemplate())
                .register(BannerDefectIds.Gen.INVALID_DISPLAY_HREF_USAGE,
                        t -> AdsDefectTypes.invalidDisplayHrefUsage())
                .register(BannerDefectIds.String.DISPLAY_HREF_LENGTH_CANNOT_BE_MORE_THAN_MAX,
                        AdsDefectTypes::displayHrefLengthExceeded)
                .register(BannerDefectIds.Gen.INVALID_SITELINK_SET_USAGE,
                        t -> AdsDefectTypes.invalidSitelinkSetIdUsage())
                .register(BannerDefectIds.Gen.REQUIRED_HREF_OR_VCARD_ID,
                        t -> AdsDefectTypes.requiredButEmptyHrefOrVcardId())
                .register(BannerDefectIds.Gen.REQUIRED_HREF_OR_TURBOLANDING_ID,
                        t -> AdsDefectTypes.requiredButEmptyHrefOrTurbolandingId())
                .register(BannerDefectIds.Gen.REQUIRED_IMAGE_HASH_OR_CREATIVE_ID,
                        t -> invalidValue())
                .register(BannerDefectIds.Gen.REQUIRED_ONLY_IMAGE_OR_CREATIVE_ID,
                        t -> invalidValue())
                .register(BannerDefectIds.Gen.CANNOT_CHANGE_IMAGE_TO_CREATIVE_ID,
                        t -> invalidValue())
                .register(BannerDefectIds.Gen.CANNOT_CHANGE_CREATIVE_ID_TO_IMAGE,
                        t -> invalidValue())
                .register(BannerDefectIds.Gen.BANNER_HREF_IS_INCOMPATIBLE_WITH_PAY_FOR_CONVERSION_STRATEGY,
                        t -> AdsDefectTypes.cannotUnarchiveBannerWhenParamsIncompatibleWithPayForConversionStrategy())
                .register(BannerDefectIds.Gen.BANNER_SITELINKS_HREF_IS_INCOMPATIBLE_WITH_PAY_FOR_CONVERSION_STRATEGY,
                        t -> AdsDefectTypes.cannotUnarchiveBannerWhenSitelinksParamsIncompatibleWithPayForConversionStrategy())
                .register(BannerDefectIds.Gen.INCONSISTENT_STATE_BANNER_TYPE_AND_ADGROUP_TYPE,
                        t -> AdsDefectTypes.inconsistentBannerTypeAndAdgroupType())
                .register(BannerDefectIds.Gen.INCONSISTENT_STATE_BANNER_TYPE_AND_IMAGE_TYPE,
                        t -> AdsDefectTypes.inconsistentStateBannerTypeAndImageType())
                .register(BannerDefectIds.Gen.INCONSISTENT_STATE_BANNER_TYPE_AND_TURBOLANDING_TYPE,
                        t -> AdsDefectTypes.inconsistentStateBannerTypeAndTurbolandingType())
                .register(BannerDefectIds.Gen.BANNER_MODERATE_WITH_EMPTY_GROUP,
                        t -> invalidValue())
                .register(BannerDefectIds.Gen.FORBIDDEN_MOBILE_BANNER,
                        t -> invalidValue())
                .register(BannerDefectIds.Gen.REQUIRED_VIDEO_ADDITION_TYPE_ONLY,
                        t -> invalidValue())
                .register(BannerDefectIds.Gen.REQUIRED_CPM_VIDEO_TYPE_ONLY,
                        t -> invalidValue())
                .register(BannerDefectIds.Gen.INCONSISTENT_CREATIVE_AND_CPM_VIDEO_AD_GROUP_SKIPPABILITY,
                        t -> invalidValue())
                .register(BannerDefectIds.Gen.REQUIRED_CPM_AUDIO_TYPE_ONLY,
                        t -> invalidValue())
                .register(BannerDefectIds.Gen.REQUIRED_HTML5_TYPE_ONLY,
                        t -> invalidValue())
                .register(BannerDefectIds.Gen.REQUIRED_CANVAS_OR_HTML5_TYPES,
                        t -> invalidValue())
                .register(BannerDefectIds.Gen.REQUIRED_CANVAS_TYPE_ONLY,
                        t -> invalidValue())
                .register(BannerDefectIds.Gen.INCONSISTENT_CREATIVE_TYPE_TO_BANNER_TYPE,
                        t -> invalidValue())
                .register(BannerDefectIds.Gen.INCONSISTENT_CREATIVE_BUSINESS_TYPE_TO_FEED_BUSINESS_TYPE,
                        t -> invalidValue())
                .register(BannerDefectIds.Gen.INCONSISTENT_CREATIVE_GEO_TO_ADGROUP_GEO,
                        t -> invalidValue())
                .register(BannerDefectIds.Gen.INCONSISTENT_CREATIVE_FORMAT,
                        t -> invalidValue())
                .register(BannerDefectIds.Gen.ACTION_IN_ARCHIVED_CAMPAIGN,
                        t -> AdsDefectTypes.actionInArchivedCampaign())
                .register(BannerDefectIds.Gen.ADD_TO_ARCHIVED_CAMPAIGN_NOT_ALLOWED,
                        t -> AdsDefectTypes.addToArchivedAdGroupNotAllowed())
                .register(BannerDefectIds.Gen.INVALID_PIXEL_FORMAT,
                        t -> AdsDefectTypes.invalidPixelFormat())
                .register(BannerDefectIds.String.HREF_LENGTH_WITHOUT_TEMPLATE_MARKER_CANNOT_BE_MORE_THAN_MAX,
                        t -> AdsDefectTypes.maxHrefLength(t.getMaxLength()))
                .register(BannerDefectIds.String.TEXT_LENGTH_WITHOUT_TEMPLATE_MARKER_CANNOT_BE_MORE_THAN_MAX,
                        t -> DefectTypes.lengthOfFieldValueMustNotExceed(t.getMaxLength()))
                .register(BannerDefectIds.String.LENGTH_WORD_WITHOUT_TEMPLATE_MARKER_CANNOT_BE_MORE_THAN_MAX,
                        t -> AdsDefectTypes.maxLengthWord(t.getMaxLength()))
                .register(BannerDefectIds.Num.MAX_BANNERS_IN_ADGROUP,
                        t -> AdsDefectTypes.maxBannersInAdgroup(t.getMax().intValue()))
                .register(BannerDefectIds.Num.MAX_BANNERS_IN_INTERNAL_CAMPAIGN,
                        t -> AdsDefectTypes.maxBannersInInternalCampaign(t.getMax().intValue()))
                .register(BannerDefectIds.Num.MAX_BANNERS_IN_UNIVERSAL_APP_CAMPAIGN,
                        t -> AdsDefectTypes.maxBannersInUniversalAppCampaign(t.getMax().intValue()))
                .register(BannerDefectIds.LanguageDefect.INCONSISTENT_LANGUAGE_WITH_GEO,
                        AdsDefectTypes::inconsistentLanguageWithGeo)
                .register(BannerDefectIds.String.MAX_NUMBER_OF_NARROW_CHARACTERS_CANNOT_BE_MORE_THAN_MAX,
                        t -> AdsDefectTypes.maxNumberOfNarrowCharacters(t.getMaxLength()))
                .register(BannerDefectIds.String.NO_RIGHTS_TO_AUDIENCE_PIXEL,
                        t -> AdsDefectTypes.noRightsToAudiencePixel(t.getAllInvalidSubstrings()))
                .register(BannerDefectIds.String.INVALID_SPEC_SYMBOL, t -> invalidValue())
                .register(BannerDefectIds.PixelWithMeasurer.INVALID_PIXEL_WITH_MEASURER,
                        t -> AdsDefectTypes.invalidPixelWithMeasurer(t.getPixelUrl(), t.getMeasurerSystemName()))
                .register(BannerDefectIds.PixelPermissions.NO_RIGHTS_TO_PIXEL,
                        t -> AdsDefectTypes.noRightsToPixel(t.getPixelUrl()))
                .register(BannerDefectIds.PixelProviderLimits.EQUAL_PIXEL_PROVIDERS,
                        t -> AdsDefectTypes.equalPixelProviders(t.getExceededClientPixelProviderNamesJoined()))
                .register(BannerDefectIds.Gen.CLIENT_HAS_NOT_CREATIVES, t -> AdsDefectTypes.creativeNotFound())
                .register(BannerDefectIds.Gen.UNSUPPORTED_BANNER_TYPE, t -> AdsDefectTypes.unsupportedBannerType())
                .register(BannerDefectIds.Gen.UNSUPPORTED_BUTTON_ACTION, t -> AdsDefectTypes.unsupportedButtonAction())
                .register(BannerDefectIds.Gen.ARCHIVED_BANNER_MODIFICATION,
                        t -> AdsDefectTypes.cannotUpdateArchivedAd())
                .register(BannerDefectIds.Gen.INCONSISTENT_BANNER_TYPE, t -> AdsDefectTypes.inconsistentBannerType())
                .register(BannerDefectIds.Gen.BANNER_TYPE_MODIFICATION, t -> invalidValue())
                .register(BannerDefectIds.Gen.IMAGE_NOT_FOUND, t -> AdsDefectTypes.imageNotFound())
                .register(BannerDefectIds.Gen.EMPTY_HREF, t -> AdsDefectTypes.emptyHref())
                .register(BannerDefectIds.Gen.THIS_TRACKING_SYSTEM_DOMAIN_NOT_SUPPORTED,
                        t -> AdsDefectTypes.trackingSystemDomainNotSupported())
                .register(BannerDefectIds.Gen.THIS_TRACKING_SYSTEM_DOMAIN_ONLY_SUPPORTS_HTTPS,
                        t -> AdsDefectTypes.trackingSystemDomainSupportsHttpsOnly())
                .register(BannerDefectIds.Gen.INCONSISTENT_BANNER_CID_AND_CAMPAIGN_ID,
                        t -> invalidValue())
                .register(BannerDefectIds.Gen.SITELINKS_SET_NOT_FOUND, t -> AdsDefectTypes.sitelinksSetNotFound())
                .register(BannerDefectIds.Gen.TURBO_PAGE_NOT_FOUND, t -> AdsDefectTypes.turboPageNotFound())
                .register(BannerDefectIds.Gen.VCARD_NOT_FOUND, t -> AdsDefectTypes.vcardNotFound())
                .register(BannerDefectIds.Gen.VIDEO_EXTENSION_NOT_FOUND, t -> AdsDefectTypes.videoExtNotFound())
                .register(BannerDefectIds.Gen.CPC_VIDEO_NOT_FOUND, t -> AdsDefectTypes.cpcVideoNotFound())
                .register(BannerDefectIds.Gen.AD_GROUP_NOT_FOUND, t -> AdsDefectTypes.adGroupNotFound())
                .register(BannerDefectIds.Id.AD_EXTENSION_NOT_FOUND, t -> AdsDefectTypes.adExtensionNotFound(t.getId()))
                .register(BannerDefectIds.Gen.AD_GROUP_TYPE_NOT_SUPPORTED,
                        t -> AdsDefectTypes.notSupportedAdGroupType())
                .register(BannerDefectIds.Gen.ARRAY_ELEMENT_INVALID_ID, t -> AdsDefectTypes.invalidIdInArrayElement())
                .register(BannerDefectIds.Gen.VCARD_OF_ANOTHER_CAMPAIGN, t -> AdsDefectTypes.vcardOfAnotherCampaign())
                .register(BannerDefectIds.Id.DUPLICATED_AD_EXTENSION_ID,
                        t -> AdsDefectTypes.duplicatedAdExtensionId(t.getId()))
                .register(BannerDefectIds.Size.MAX_CALLOUTS_ON_BANNER_ADD,
                        t -> AdsDefectTypes.maxAdExtensionsExceeded(t.getMaxSize()))
                .register(BannerDefectIds.Size.MAX_CALLOUTS_PER_BANNER,
                        t -> AdsDefectTypes.maxAdExtensionsOnBannerExceeded(t.getMaxSize()))
                .register(BannerDefectIds.Size.MAX_YA_AUD_PIXELS_ON_BANNER,
                        t -> AdsDefectTypes.maxYaAudiencePixelNumberOnBannerExceeded())
                .register(BannerDefectIds.Size.MAX_FOREIGN_PIXELS_ON_BANNER,
                        t -> AdsDefectTypes.maxNonYaAudiencePixelNumberOnBannerExceeded())
                .register(BannerDefectIds.Gen.EMPTY_DISPLAY_HREF, t -> AdsDefectTypes.emptyDisplayHref())
                .register(BannerDefectIds.String.SHOULD_NOT_BE_BLANK, t -> DefectTypes.absentValueInField())
                .register(BannerDefectIds.Gen.EMPTY_VALUE, t -> AdsDefectTypes.emptyValueInField())
                .register(BannerDefectIds.Gen.RESTRICTED_CHARS_IN_FIELD,
                        t -> DefectTypes.mustContainLettersOrDigitsOrPunctuations())
                .register(BannerDefectIds.Gen.CREATIVE_NOT_FOUND, t -> AdsDefectTypes.creativeNotFound())
                .register(BannerDefectIds.Gen.CANNOT_UPDATE_ARCHIVED_AD, t -> AdsDefectTypes.cannotUpdateArchivedAd())
                .register(BannerDefectIds.Gen.AD_NOT_FOUND, t -> AdsDefectTypes.adNotFound())
                .register(BannerDefectIds.Gen.IMAGE_SIZE_MODIFICATION, t -> AdsDefectTypes.cannotUpdateImageSize())
                .register(BannerDefectIds.Gen.IMAGE_SIZE_NOT_FOUND, t -> invalidValue())
                .register(BannerDefectIds.Gen.IMAGE_SIZE_INVALID, t -> invalidValue())
                .register(BannerDefectIds.Id.SUSPEND_IN_ARCHIVED_CAMPAIGN,
                        t -> AdsDefectTypes.suspendInArchivedCampaign(t.getId()))
                .register(BannerDefectIds.Id.RESUME_IN_ARCHIVED_CAMPAIGN,
                        t -> AdsDefectTypes.resumeInArchivedCampaign(t.getId()))
                .register(BannerDefectIds.Gen.SUSPEND_ARCHIVED_BANNER,
                        t -> AdsDefectTypes.cannotSuspendArchivedBanner())
                .register(BannerDefectIds.Gen.RESUME_ARCHIVED_BANNER, t -> AdsDefectTypes.cannotResumeArchivedBanner())
                .register(BannerDefectIds.Gen.SUSPEND_DRAFT_BANNER, t -> AdsDefectTypes.cannotSuspendDraftBanner())
                .register(BannerDefectIds.Gen.RESUME_DRAFT_BANNER, t -> AdsDefectTypes.cannotResumeDraftBanner())
                .register(BannerDefectIds.Gen.ALREADY_SUSPENDED, t -> AdsDefectTypes.warningAdAlreadySuspended())
                .register(BannerDefectIds.Gen.IS_NOT_SUSPENDED, t -> AdsDefectTypes.warningAdNotSuspended())
                .register(BannerDefectIds.Gen.ALREADY_ARCHIVED, t -> AdsDefectTypes.warningAdAlreadyArchived())
                .register(BannerDefectIds.Gen.IS_NOT_ARCHIVED, t -> AdsDefectTypes.warningAdNotArchived())
                .register(BannerDefectIds.Gen.ARCHIVE_BANNER_SHOWN_IN_BS,
                        t -> AdsDefectTypes.cannotArchiveBannerShownInBs())
                .register(BannerDefectIds.Gen.ARCHIVE_DRAFT_BANNER, t -> AdsDefectTypes.cannotArchiveDraftBanner())
                .register(BannerDefectIds.Id.ARCHIVE_IN_ARCHIVED_CAMPAIGN,
                        t -> AdsDefectTypes.cannotArchiveInArchivedCampaign(t.getId()))
                .register(BannerDefectIds.Id.UNARCHIVE_IN_ARCHIVED_CAMPAIGN,
                        t -> AdsDefectTypes.cannotUnarchiveInArchivedCampaign(t.getId()))
                .register(BannerDefectIds.Gen.CANNOT_CHANGE_BANNER_FLAGS_FROM_BABY_FOOD_TO_OTHER_TYPES,
                        t -> AdsDefectTypes.cannotChangeBannerFlagsFromBabyFoodToOtherTypes())
                .register(BannerDefectIds.Gen.CANNOT_CHANGE_BANNER_FLAGS_FROM_AGE_TO_OTHER_TYPES,
                        t -> AdsDefectTypes.cannotChangeBannerFlagsFromAgeToOtherTypes())
                .register(BannerDefectIds.Gen.CLIENT_CANNOT_SET_BANNER_FLAGS,
                        t -> AdsDefectTypes.clientCannotSetBannerFlags())
                .register(BannerDefectIds.Gen.AD_MORE_THAN_ONCE_IN_REQUEST,
                        t -> AdsDefectTypes.adMoreThanOnceInRequest())
                .register(BannerDefectIds.Gen.UNABLE_TO_DELETE,
                        t -> AdsDefectTypes.unableToDelete())
                .register(BannerDefectIds.Gen.TRACKING_URL_DOESNT_CONTAIN_MACROS,
                        t -> AdsDefectTypes.warningTrackingUrlDoesntContainLogid())
                .register(BannerDefectIds.Gen.MODERATE_BANNER_IN_GROUP_WITHOUT_SHOW_CONDITIONS,
                        t -> AdsDefectTypes.moderateBannerInAdGroupWithoutShowConditions())
                .register(BannerDefectIds.Gen.MODERATE_ARCHIVED_BANNER,
                        t -> AdsDefectTypes.moderateArchivedBanner())
                .register(BannerDefectIds.Gen.MODERATE_NON_DRAFT_BANNER,
                        t -> AdsDefectTypes.moderateNonDraftBanner())
                .register(BannerDefectIds.Gen.REMODERATE_DRAFT_BANNER,
                        t -> AdsDefectTypes.remoderateDraftBanner())
                .register(BannerDefectIds.Id.MODERATE_BANNER_IN_ARCHIVED_CAMPAIGN,
                        t -> AdsDefectTypes.moderateBannerInArchivedCampaign(t.getId()))
                .register(BannerDefectIds.Id.REMODERATE_BANNER_IN_DRAFT_CAMPAIGN,
                        t -> AdsDefectTypes.remoderateBannerInDraftCampaign(t.getId()))
                .register(BannerDefectIds.Gen.REMODERATE_BANNER_IS_NOT_ALLOWED,
                        t -> AdsDefectTypes.remoderateBannerIsNotAllowed())
                .register(BannerDefectIds.ModReasons.REMODERATE_BANNER_WITH_NOT_ALLOWED_MOD_REASONS,
                        t -> AdsDefectTypes.remoderateBannerWithNotAllowedModReasons())
                .register(BannerDefectIds.Gen.REMODERATE_BANNER_WITH_NO_MOD_REASONS,
                        t -> AdsDefectTypes.remoderateBannerWithNoModReasons())
                .register(BannerDefectIds.Gen.FORBIDDEN_TO_CHANGE,
                        t -> AdsDefectTypes.updatingCpmOutdoorBannerIsForbidden())
                .register(BannerDefectIds.Gen.CANNOT_HAVE_TURBOLANDINGS,
                        t -> AdsDefectTypes.updatingCpmOutdoorBannerIsForbidden())
                .register(BannerDefectIds.Gen.INTERNAL_TEMPLATE_NOT_ALLOWED,
                        t -> invalidValue())
                .register(BannerDefectIds.Gen.INTERNAL_TEMPLATE_VARIABLES_MISMATCH,
                        t -> invalidValue())
                .register(BannerDefectIds.Gen.REQUIRED_CAMPAIGNS_IMPRESSION_RATE_BUT_EMPTY,
                        t -> invalidValue())
                .register(BannerDefectIds.Gen.REQUIRED_AD_GROUPS_IMPRESSION_RATE_BUT_EMPTY,
                        t -> invalidValue())
                .register(BannerDefectIds.Gen.REQUIRED_CAMPAIGN_OR_AD_GROUP_MAX_STOPS_COUNT_BUT_EMPTY,
                        t -> invalidValue())
                .register(BannerDefectIds.Gen.BANNER_PRICE_MISSING,
                        t -> AdsDefectTypes.bannerPriceMissing())
                .register(BannerDefectIds.Gen.BANNER_PRICE_CURRENCY_MISSING,
                        t -> AdsDefectTypes.bannerPriceCurrencyMissing())
                .register(BannerDefectIds.Gen.BANNER_PRICE_GREATER_THAN_OLD,
                        t -> AdsDefectTypes.bannerPriceGreaterThanOld())
                .register(BannerDefectIds.Gen.BANNER_CANNOT_HAVE_TURBO_GALLERY_HREF,
                        t -> invalidValue())
                .register(BannerDefectIds.Gen.CONTENT_TYPE_NOT_MATCHES_ADGROUP_CONTENT_TYPE,
                        t -> AdsDefectTypes.contentTypeNotMatchesAdGroupContentType())
                .register(BannerDefectIds.Gen.CONTENT_PROMOTION_VIDEO_IS_INACCESSIBLE,
                        t -> AdsDefectTypes.contentPromotionVideoIsInaccessible())
                .register(BannerDefectIds.Gen.CONTENT_PROMOTION_COLLECTION_IS_INACCESSIBLE,
                        t -> AdsDefectTypes.contentPromotionCollectionIsInaccessible())
                .register(BannerDefectIds.Price.MUST_BE_LESS_THEN_OR_EQUAL_TO_MAX,
                        t -> invalidValueNotGreaterThan(
                                convertToMicros(new BigDecimal(t.getMax().longValue()))))
                .register(BannerDefectIds.Price.MUST_BE_GREATER_THAN_MIN,
                        t -> DefectTypes.invalidValueShouldBeGreaterThan(
                                convertToMicros(new BigDecimal(t.getMin().longValue()))))
                .register(BannerDefectIds.Gen.PRICE_SALES_FULLNESS_VIOLATED,
                        t -> invalidValue())
                .register(BannerDefectIds.Gen.PRICE_SALES_CAMPAIGN_GEO_OVERLAPS_BANNER_MINUS_GEO,
                        t -> invalidValue())
                .register(BannerDefectIds.Gen.PRICE_SALES_DISALLOWED_CREATIVE_TEMPLATE,
                        t -> invalidValue())
                .register(BannerDefectIds.Gen.ERRORS_WHILE_COPYING_BANNERS, t -> invalidValue())
                .register(BannerDefectIds.Gen.INCONSISTENT_LEADFORM_HREF_AND_BUTTON_TEXT,
                        t -> AdsDefectTypes.inconsistentLeadformHrefAndButtonText())
                .register(BannerDefectIds.Gen.DIFFERENT_TEMPLATES_NOT_ALLOWED,
                        t -> invalidValue())
                .register(BannerDefectIds.Gen.TEMPLATE_RESOURCE_ID_NOT_FOUND,
                        t -> invalidValue())
                .register(BannerDefectIds.Gen.TEMPLATE_MUST_BE_MODERATED,
                        t -> invalidValue())
                .register(BannerDefectIds.Gen.INCORRECT_IMPRESSION_URL_TRACKING_SYSTEM,
                        t -> AdsDefectTypes.incorrectImpressionUrlTrackingSystem())
                .register(BannerDefectIds.Gen.INCORRECT_IMPRESSION_URL_TRACKER_ID,
                        t -> AdsDefectTypes.incorrectImpressionUrlTrackerId());
    }

    private static void registerAdgroups(DefectPresentationsHolder.Builder builder) {
        builder
                .register(AdGroupDefectIds.Gen.ARCHIVED_AD_GROUP_MODIFICATION,
                        t -> AdGroupDefectTypes.archivedAdGroupModification())
                .register(AdGroupDefectIds.Gen.AD_GROUP_DOES_NOT_CONTAIN_THIS_BANNER,
                        t -> invalidValue())
                .register(AdGroupDefectIds.Gen.AD_GROUP_DOES_NOT_CONTAIN_THIS_KEYWORD,
                        t -> invalidValue())
                .register(AdGroupDefectIds.Gen.UNSUPPORTED_GROUP_TYPE,
                        t -> invalidValue())
                .register(AdGroupDefectIds.Gen.MUST_BE_MUTUALLY_EXCLUSIVE,
                        t -> invalidValue())
                .register(AdGroupDefectIds.Gen.AD_GROUP_DOES_NOT_CONTAIN_THIS_RELEVANCE_MATCH,
                        t -> invalidValue())
                .register(AdGroupDefectIds.Number.TOO_MANY_BANNERS_IN_AD_GROUP,
                        t -> invalidValue())
                .register(RelevanceMatchDefects.Number.TOO_MANY_RELEVANCE_MATCH_IN_AD_GROUP,
                        t -> KeywordsDefectTypes.maxAutotargetingsInAdGroup())
                .register(OfferRetargetingDefects.Number.TOO_MANY_OFFER_RETARGETINGS_IN_AD_GROUP,
                        t -> KeywordsDefectTypes.maxOfferRetargetingsInAdGroup())
                .register(AdGroupDefectIds.Number.MAX_ADGROUPS_IN_CAMPAIGN,
                        t -> AdGroupDefectTypes.campaignAdGroupsLimitReached(t.getMax().intValue()))
                .register(AdGroupDefectIds.Geo.BAD_GEO,
                        t -> AdGroupDefectTypes.inconsistentGeoWithBannerLanguages(t.getLanguage(), t.getBannerId()))
                .register(AdGroupDefectIds.Gen.INCONSISTENT_AD_GROUP_TYPE_TO_CAMPAIGN_TYPE,
                        t -> AdGroupDefectTypes.inconsistentAdGroupTypeToCampaign())
                .register(AdGroupDefectIds.Gen.AD_GROUP_NAME_IS_NOT_SET,
                        t -> AdGroupDefectTypes.adGroupNameIsNotSet())
                .register(AdGroupDefectIds.Gen.AD_GROUP_NAME_CANT_BE_EMPTY,
                        t -> AdGroupDefectTypes.adGroupNameCantBeEmpty())
                .register(AdGroupDefectIds.String.AD_GROUP_NAME_TOO_LONG,
                        t -> AdGroupDefectTypes.adGroupNameTooLong(t.getMaxLength()))
                .register(AdGroupDefectIds.Gen.ADVERTISED_APP_LINK_IS_NOT_SET,
                        t -> AdGroupDefectTypes.advertisedAppLinkIsNotSet())
                .register(AdGroupDefectIds.ModelId.FEED_NOT_EXIST,
                        t -> AdGroupDefectTypes.feedNotExist(t.getId()))
                .register(AdGroupDefectIds.Gen.INVALID_APP_LINK_FORMAT,
                        t -> AdGroupDefectTypes.invalidAppLinkFormat())
                .register(AdGroupDefectIds.AppStoreDomain.APP_STORE_IS_NOT_SUPPORTED,
                        t -> AdGroupDefectTypes.appStoreIsNotSupported(t.getAllowedAppStoreDomains()))
                .register(AdGroupDefectIds.Gen.INVALID_APP_STORE_URL,
                        t -> AdGroupDefectTypes.invalidAppStoreUrl())
                .register(AdGroupDefectIds.Gen.MIN_OS_VERSION_IS_NOT_SET,
                        t -> AdGroupDefectTypes.minOsVersionIsNotSet())
                .register(AdGroupDefectIds.Gen.INVALID_MIN_OS_VERSION,
                        t -> AdGroupDefectTypes.invalidMinOsVersion())
                .register(AdGroupDefectIds.Gen.DEVICE_TARGETING_IS_NOT_SET,
                        t -> AdGroupDefectTypes.deviceTargetingIsNotSet())
                .register(AdGroupDefectIds.Gen.NETWORK_TARGETING_IS_NOT_SET,
                        t -> AdGroupDefectTypes.networkTargetingIsNotSet())
                .register(AdGroupDefectIds.Gen.DYNAMIC_TEXT_DOMAIN_IS_NOT_SET,
                        t -> AdGroupDefectTypes.dynamicTextDomainIsNotSet())
                .register(AdGroupDefectIds.Gen.INVALID_DYNAMIC_TEXT_DOMAIN,
                        t -> AdGroupDefectTypes.invalidDynamicTextDomain())
                .register(AdGroupDefectIds.Gen.NOT_FOUND,
                        t -> AdGroupDefectTypes.notFound())
                .register(AdGroupDefectIds.Gen.UNABLE_TO_DELETE,
                        t -> AdGroupDefectTypes.unableToDelete())
                .register(AdGroupDefectIds.Gen.MUST_NOT_CONTAIN_DUPLICATED_OBJECTS,
                        t -> AdGroupDefectTypes.duplicatedObject())
                .register(CollectionDefectIds.Gen.MUST_NOT_CONTAIN_DUPLICATED_ELEMENTS,
                        t -> DefectTypes.duplicatedElement())
                .register(AdGroupDefectIds.Gen.AD_GROUP_TYPE_NOT_SUPPORTED,
                        t -> AdGroupDefectTypes.adGroupTypeNotSupported())
                .register(AdGroupDefectIds.Gen.INCONSISTENT_AD_GROUP_TYPE,
                        t -> AdGroupDefectTypes.inconsistentAdGroupType())
                .register(AdGroupDefectIds.Gen.INCONSISTENT_DYNAMIC_AD_GROUP_TYPE,
                        t -> AdGroupDefectTypes.inconsistentDynamicAdGroupSubType())
                .registerWithDefault(AdGroupDefectIds.Gen.EITHER_KEYWORDS_OR_RETARGETINGS_ALLOWED)
                .registerWithDefault(AdGroupDefectIds.Gen.EMPTY_CONTENT_CATEGORIES_NOT_ALLOWED)
                .registerWithDefault(AdGroupDefectIds.Gen.KEYWORDS_NOT_ALLOWED)
                .register(AdGroupDefectIds.Gen.BID_MODIFIERS_NOT_ALLOWED,
                        t -> BidModifiersDefectTypes.notSupportedMultiplier())
                .register(AdGroupDefectIds.Gen.MINUS_KEYWORDS_NOT_ALLOWED,
                        t -> AdGroupDefectTypes.minusKeywordsNotAllowed())
                .register(AdGroupDefectIds.Gen.RESTRICTED_REGIONS,
                        t -> AdGroupDefectTypes.restrictedRegions())
                .register(AdGroupDefectIds.Gen.CONTENT_PROMOTION_SEVERAL_TYPES_NOT_ALLOWED,
                        t -> AdGroupDefectTypes.contentPromotionSeveralTypesNotAllowed())
                .register(AdGroupDefectIds.Gen.CONTENT_PROMOTION_DISTINCT_TYPE_FROM_EXISTING,
                        t -> AdGroupDefectTypes.contentPromotionDistinctTypeFromExisting())
                .register(AdGroupDefectIds.Gen.CONTENT_PROMOTION_ADGROUP_TYPE_CHANGED,
                        t -> AdGroupDefectTypes.contentPromotionAdGroupTypeChanged())
                .register(AdGroupDefectIds.Gen.STORE_URL_MUST_BE_SAME_FOR_ALL_GROUPS_IN_MOBILE_CONTENT_CAMPAIGN,
                        t -> AdGroupDefectTypes.storeUrlMustBeTheSameForAllGroupsInMobileContentCampaign())
                .register(AdGroupDefectIds.Gen.STORE_URL_MUST_BE_SAME_AS_URL_IN_MOBILE_CONTENT_CAMPAIGN,
                        t -> AdGroupDefectTypes.storeUrlMustBeTheSameAsUrlInMobileContentCampaign())
                .registerWithDefault(AdGroupDefectIds.Gen.NOT_ALLOWED_VALUE)
                .registerWithDefault(AdGroupDefectIds.Gen.BS_TAG_NOT_ALLOWED)
                .registerWithDefault(AdGroupDefectIds.Gen.FINISH_TIME_SHOULD_BE_GREATER_THAN_START_TIME)
                .registerWithDefault(AdGroupDefectIds.Gen.ONLY_ONE_DEFAULT_AD_GROUP_ALLOWED)
                .registerWithDefault(AdGroupDefectIds.Gen.ERRORS_WHILE_COPYING_ADGROUPS)
                .registerWithDefault(AdGroupDefectIds.Gen.PRICE_SALES_DISALLOWED_ADGROUP_TYPE)
                .registerWithDefault(AdGroupDefectIds.Gen.PRICE_SALES_DISALLOWED_METRIKA_SEGMENTS)
                .registerWithDefault(AdGroupDefectIds.Gen.PRICE_SALES_DISALLOWED_AUDIENCE_SEGMENTS)
                .registerWithDefault(AdGroupDefectIds.Gen.PRICE_SALES_AD_GROUP_TYPE_NOT_ALLOWED)
                .registerWithDefault(AdGroupDefectIds.Gen.PRICE_SALES_INVALID_PRIORITY)
                .registerWithDefault(AdGroupDefectIds.Gen.PRICE_SALES_AD_GROUP_USE_NOT_ALLOWED_BID_MODIFIERS)
                .registerWithDefault(AdGroupDefectIds.Gen.PRICE_SALES_AD_GROUP_NOT_ALLOWED_MOBILE_PLATFORMS_COMBINATION)
                .registerWithDefault(AdGroupDefectIds.Gen.AD_GROUP_STATUS_ARCHIVED)
                .registerWithDefault(AdGroupDefectIds.Gen.AD_GROUP_STATUS_STOPPED)
                .registerWithDefault(AdGroupDefectIds.PriceSalesTargetingAmount.TOO_FEW_TARGETINGS)
                .registerWithDefault(AdGroupDefectIds.PriceSalesTargetingAmount.TOO_MANY_TARGETINGS)
                .registerWithDefault(AdGroupDefectIds.Banners.REQUIRED_AGE_VARIABLE);
    }

    private static void registerFeed(DefectPresentationsHolder.Builder builder) {
        builder
                .register(FeedDefectIds.Gen.FEED_IS_NOT_SET,
                        t -> FeedDefectTypes.feedIsNotSet())
                .register(FeedDefectIds.Gen.FEED_ID_IS_NOT_VALID,
                        t -> FeedDefectTypes.feedIdIsNotValid())
                .register(FeedDefectIds.Gen.FEED_USED_IN_AD_GROUP,
                        t -> FeedDefectTypes.feedUsedInAdGroup())
                .register(FeedDefectIds.Gen.FEED_INVALID_HREF,
                        t -> FeedDefectTypes.feedInvalidHref())
                .register(FeedDefectIds.Gen.FEED_NAME_CANNOT_BE_EMPTY,
                        t -> FeedDefectTypes.feedNameCannotBeEmpty())
                .register(FeedDefectIds.Gen.FEED_LOGIN_CANNOT_BE_EMPTY,
                        t -> FeedDefectTypes.feedLoginCannotBeEmpty())
                .register(FeedDefectIds.Gen.FEED_PASSWORD_CANNOT_BE_EMPTY,
                        t -> FeedDefectTypes.feedPasswordCannotBeEmpty())
                .register(FeedDefectIds.Gen.FEED_INVALID_FILENAME,
                        t -> FeedDefectTypes.feedInvalidFilename())
                .register(FeedDefectIds.Gen.FEED_INCONSISTENT_TYPE_FOR_UPDATE,
                        t -> FeedDefectTypes.feedInconsistentType())
                .register(FeedDefectIds.Gen.FEED_NOT_EXIST,
                        t -> FeedDefectTypes.feedNotExist())
                .register(FeedDefectIds.Gen.FEED_LOGIN_IS_NOT_SET,
                        t -> FeedDefectTypes.feedLoginIsNotSet())
                .register(FeedDefectIds.Gen.FEED_PASSWORD_IS_NOT_SET,
                        t -> FeedDefectTypes.feedPasswordIsNotSet())
                .register(FeedDefectIds.Gen.FEED_APART_RESET_LOGIN_AND_PASSWORD,
                        t -> FeedDefectTypes.feedApartResetLoginAnPassword())
                .register(FeedDefectIds.String.FEED_STATUS_WRONG,
                        t -> FeedDefectTypes.feedStatusWrong(t.getAllInvalidSubstrings()))
                .register(FeedDefectIds.String.FEED_NAME_FIELD_IS_TOO_LONG,
                        t -> FeedDefectTypes.feedNameFieldIsTooLong(t.getMaxLength()))
                .register(FeedDefectIds.String.FEED_BODY_FIELD_IS_TOO_LONG,
                        t -> FeedDefectTypes.feedBodyFieldIsTooLong(t.getMaxLength()))
                .register(FeedDefectIds.String.FEED_BY_SITE_CONTAINS_DUPLICATED_URL,
                        t -> FeedDefectTypes.feedBySiteContainsDuplicatedUrl(t.getAllInvalidSubstrings(", ")))
                .register(FeedDefectIds.String.FEED_BY_SITE_FOR_NOT_ALLOWED_URL,
                        t -> FeedDefectTypes.feedBySiteForNotAllowedUrl(t.getAllInvalidSubstrings(", ")))
                .register(FeedDefectIds.String.FEED_BY_SITE_FOR_NOT_DOMAIN_ONLY_URL,
                        t -> FeedDefectTypes.feedBySiteForNotAllowedUrl(t.getAllInvalidSubstrings(", ")))
                .register(FeedDefectIds.ModelId.FEED_BY_SITE_WITH_SAME_DOMAIN_ALREADY_EXISTS,
                        t -> FeedDefectTypes.feedBySiteWithSameDomainAlreadyExists(t.getId()))
                .register(FeedDefectIds.Number.FEED_CANNOT_BE_REFRESHED_MORE_OFTEN_THAN_REFRESH_HOURS_PERIOD,
                        t -> FeedDefectTypes.feedCannotBeRefreshedMoreOftenThanRefreshHoursPeriod(t.getMin().longValue()))
                .register(FeedDefectIds.Gen.FEED_WITHOUT_URL_SOURCE_CANNOT_BE_REFRESHED,
                        t -> FeedDefectTypes.feedWithoutUrlSourceCannotBeRefreshed())
                .register(FeedDefectIds.Gen.FEED_WITH_STATUS_NEW_CANNOT_BE_REFRESHED,
                        t -> FeedDefectTypes.feedWithStatusNewCannotBeRefreshed())
                .register(FeedDefectIds.Gen.FEED_IS_USED_IN_CAMPAIGN_BRIEF,
                        t -> FeedDefectTypes.feedIsUsedInCampaignBrief());
    }

    private static void registerKeywordsAdvq(DefectPresentationsHolder.Builder builder) {
        builder
                .register(AdvqPhraseDefectIds.Gen.CANNOT_CONTAIN_LONE_DOT,
                        t -> DefectTypes.invalidChars().withDetailedMessage(
                                (path, value) -> translations().invalidCharsKeywordLoneDotDetailed(value.toString())))
                .register(AdvqPhraseDefectIds.Gen.UNPAIRED_QUOTES,
                        t -> DefectTypes.invalidChars().withDetailedMessage(
                                (path, value) -> translations().invalidCharsUnpairedQuotesDetailed(value.toString())))
                .register(AdvqPhraseDefectIds.Gen.CONTAINS_ONLY_STOP_WORDS,
                        t -> DefectTypes.containsOnlyStopWords())
                .register(AdvqPhraseDefectIds.Gen.CANNOT_CONTAIN_ONLY_MINUS_WORDS,
                        t -> DefectTypes.minusWords())
                .register(AdvqPhraseDefectIds.String.TOO_MANY_WORDS,
                        t -> DefectTypes.maxWords(t.getMaxWords()))
                .register(AdvqPhraseDefectIds.String.TOO_LONG_KEYWORD,
                        t -> DefectTypes.keywordMaxLength(t.getMaxLength()))
                .register(AdvqPhraseDefectIds.Gen.UNPAIRED_SQUARE_BRACKETS,
                        t -> DefectTypes.invalidChars().withDetailedMessage(
                                (path, value) -> translations().invalidCharsUnpairedSquareBracketsDetailed(value.toString())))
                .register(AdvqPhraseDefectIds.Gen.EMPTY_OR_NESTED_SQUARE_BRACKETS,
                        t -> DefectTypes.invalidChars().withDetailedMessage(
                                (path, value) -> translations().invalidCharsEmptyOrNestedSquareBrackets(value.toString())))
                .register(AdvqPhraseDefectIds.Gen.MODIFIERS_INSIDE_SQUARE_BRACKETS,
                        t -> DefectTypes.invalidChars().withDetailedMessage(
                                (path, value) -> translations().invalidCharsModifiersInsideSquareBrackets(value.toString())))
                .register(AdvqPhraseDefectIds.Gen.INCORRECT_USE_OF_EXCLAMATION_MARK,
                        t -> DefectTypes.invalidChars().withDetailedMessage(
                                (path, value) -> translations().invalidCharsIncorrectUseOfExclamationMarks(value.toString())))
                .register(AdvqPhraseDefectIds.Gen.INCORRECT_USE_OF_MINUS_SIGN,
                        t -> DefectTypes.invalidChars().withDetailedMessage(
                                (path, value) -> translations().invalidCharsIncorrectUseOfMinusSign(value.toString())))
                .register(AdvqPhraseDefectIds.Gen.INCORRECT_USE_OF_PLUS_SIGN,
                        t -> DefectTypes.invalidChars().withDetailedMessage(
                                (path, value) -> translations().invalidCharsIncorrectUseOfPlusSign(value.toString())))
                .register(AdvqPhraseDefectIds.Gen.NO_MINUS_PHRASES_ONLY_WORDS,
                        t -> DefectTypes.minusWords().withDetailedMessage(
                                (path, value) -> translations().minusWordsNoMinusPhrasesDetailed(path)))
                .register(AdvqPhraseDefectIds.Gen.MINUS_WORDS_NO_PHRASE_WITH_DOT,
                        t -> DefectTypes.minusWords().withDetailedMessage(
                                (path, value) -> translations().minusWordsPhraseWithDot(path)))
                .register(AdvqPhraseDefectIds.Gen.INCORRECT_COMBINATION_OF_SPECIAL_SYMBOLS,
                        t -> DefectTypes.minusWords().withDetailedMessage(
                                (path, value) -> translations().minusWordsIncorrectCombinationOfSpecialSymbols(path)))
                .register(AdvqPhraseDefectIds.Gen.MINUS_WORD_CANNOT_START_FROM_DOT_OR_APOSTROPHE,
                        t -> DefectTypes.minusWords().withDetailedMessage(
                                (path, value) -> translations().minusWordsCantStartWithDotOrApostroph(path)))
                .register(AdvqPhraseDefectIds.Gen.MINUS_WORD_NOT_IN_QUOTED_PHRASE,
                        t -> DefectTypes.minusWords().withDetailedMessage(
                                (path, value) -> translations().minusWordsNotInQuotedPhrase(path)))
                .register(AdvqPhraseDefectIds.Gen.ONLY_SINGLE_DOT_BETWEEN_NUMBERS,
                        t -> DefectTypes.minusWords().withDetailedMessage(
                                (path, value) -> translations().minusWordsSingleDotOnly(path)))
                .register(AdvqPhraseDefectIds.String.MINUS_WORDS_CANNOT_SUBTRACT_PLUS_WORDS,
                        t -> DefectTypes.minusWords().withDetailedMessage(
                                (path, value) -> translations().minusWordsCantSubtractPlusWords(path)));
    }

    private static void registerSitelinks(DefectPresentationsHolder.Builder builder) {
        builder
                .register(SitelinkDefectIds.Strings.MAX_SITELINKS_TITLES_LENGTH,
                        SitelinksDefectTypes::titlesTogetherTooLong)
                .register(SitelinkDefectIds.Strings.MAX_SITELINKS_FIRST_BLOCK_TITLES_LENGTH,
                        SitelinksDefectTypes::titlesTogetherTooLongFirstBlock)
                .register(SitelinkDefectIds.Strings.MAX_SITELINKS_SECOND_BLOCK_TITLES_LENGTH,
                        SitelinksDefectTypes::titlesTogetherTooLongSecondBlock)
                .register(SitelinkDefectIds.Strings.SITELINK_TITLE_LENGTH_CANNOT_BE_MORE_THAN_MAX,
                        SitelinksDefectTypes::titleTooLong)
                .register(SitelinkDefectIds.Strings.SITELINK_DESCRIPTION_LENGTH_CANNOT_BE_MORE_THAN_MAX,
                        SitelinksDefectTypes::descriptionTooLong)
                .register(SitelinkDefectIds.Strings.SITELINK_HREF_LENGTH_CANNOT_BE_MORE_THAN_MAX,
                        SitelinksDefectTypes::hrefTooLong)
                .register(SitelinkDefectIds.Strings.ALLOWED_SYMBOLS_SITELINK_TITLE,
                        SitelinksDefectTypes::disallowedSymbolsInTitle)
                .register(SitelinkDefectIds.Strings.ALLOWED_SYMBOLS_SITELINK_DESC,
                        SitelinksDefectTypes::disallowedSymbolsInDescription)
                .register(SitelinkDefectIds.Gen.SITELINK_TITLE_CANNOT_BE_EMPTY,
                        SitelinksDefectTypes::emptyTitle)
                .register(SitelinkDefectIds.Gen.SITELINK_DESCRIPTION_CANNOT_BE_EMPTY,
                        SitelinksDefectTypes::emptyDescription)
                .register(SitelinkDefectIds.Gen.INVALID_SITELINK_HREF,
                        SitelinksDefectTypes::invalidHref)
                .register(SitelinkDefectIds.Gen.REQUIRED_SITELINK_WITH_TURBO_HREF_OR_TURBOLANDING_ID,
                        SitelinksDefectTypes::invalidHref)

                //sitelinkSets
                .register(SitelinkSetDefectIds.Gen.SITELINKS_SET_USED_AND_CANT_BE_DELETED,
                        t -> DefectTypes.inconsistentStateSitelinkSetCannotBeDeleted())

                .register(SitelinkDefectIds.Gen.DUPLICATE_SITELINK_TITLES,
                        SitelinksDefectTypes::duplicateTitles)
                .register(SitelinkDefectIds.Gen.DUPLICATE_SITELINK_DESCS,
                        SitelinksDefectTypes::duplicateDescriptions)
                .register(ApiDefectIds.Gen.MAX_IDS_IN_SELECTION, t -> DefectTypes.maxIdsInSelection())
                .register(SitelinkDefectIds.Gen.MAX_ELEMENTS_PER_DELETE_REQUEST,
                        t -> maxElementsPerRequest(Constants.MAX_IDS_PER_DELETE))
                .register(SitelinkDefectIds.Gen.OBJECT_CANNOT_BE_MORE_THAN_ONCE_IN_REQUEST,
                        SitelinksDefectTypes::duplicateObjectsInRequest)
                .register(ApiDefectIds.Gen.LIMIT_MUST_BE_GREATER_THAN_ZERO,
                        t -> DefectTypes.incorrectPageNonPositiveLimit())
                .register(ApiDefectIds.Nums.LIMIT_MUST_BE_LESS_THAN_VALUE,
                        t -> DefectTypes.incorrectPageLimitExceeded(t.getMax().intValue()))
                .register(ApiDefectIds.Gen.OFFSET_MUST_BE_POSITIVE,
                        t -> DefectTypes.incorrectPageNegativeOffset())
                .register(SitelinkSetDefectIds.Gen.DUPLICATE_SITELINK_SET,
                        t -> DefectTypes.warningDuplicateSitelinkSet())
                .register(SitelinkSetDefectIds.Collections.SITELINKS_COUNT_MUST_BE_BETWEEN,
                        SitelinksDefectTypes::invalidSubobjectCount);
    }

    private static void registerBids(DefectPresentationsHolder.Builder builder) {
        builder
                .registerWithDefault(BidsDefects.Bids.BAD_STATUS_CAMPAIGN_ARCHIVED_ON_UPDATE_BIDS)
                .registerWithDefault(BidsDefects.Bids.FIELD_DOES_NOT_MATCH_STRATEGY)
                .registerWithDefault(BidsDefects.Bids.FIELD_REQUIRED_FOR_CONTEXT_STRATEGY)
                .registerWithDefault(BidsDefects.Bids.FIELD_REQUIRED_FOR_SEARCH_STRATEGY)
                .registerWithDefault(BidsDefects.Bids.NOT_FOUND_SHOW_CONDITION_BY_PARAMETERS)
                .registerWithDefault(BidsDefects.Bids.RELEVANCE_MATCH_CANT_BE_USED_IN_SET_AUTO)
                .registerWithDefault(BidsDefects.BidsDefects2Fields.DEPENDENT_FIELD_MISSING)
                .registerWithDefault(ApiDefectIds.CollectionIds.MAX_AD_GROUP_IDS_PER_REQUEST)
                .registerWithDefault(ApiDefectIds.CollectionIds.MAX_CAMPAIGN_IDS_PER_REQUEST)
                .registerWithDefault(ApiDefectIds.CollectionIds.MAX_SHOW_CONDITIONS_PER_REQUEST)
                .registerWithDefault(BidsDefects.CurrencyAmountDefects.SEARCH_PRICE_IS_NOT_GREATER_THAN_MIN)
                .registerWithDefault(BidsDefects.CurrencyAmountDefects.SEARCH_PRICE_IS_NOT_SMALLER_THAN_MAX)
                .registerWithDefault(BidsDefects.CurrencyAmountDefects.CPM_PRICE_IS_NOT_GREATER_THAN_MIN)
                .registerWithDefault(BidsDefects.CurrencyAmountDefects.CPM_PRICE_IS_NOT_SMALLER_THAN_MAX)
                .registerWithDefault(BidsDefects.Ids.BID_FOR_CONTEXT_NOT_ALLOWED_NET_IS_SWITCHED_OFF)
                .registerWithDefault(BidsDefects.Ids.BID_FOR_CONTEXT_NOT_ALLOWED_NOT_DIFFERENT_PLACES)
                .registerWithDefault(BidsDefects.Ids.BID_FOR_CONTEXT_WONT_BE_ACCEPTED_NET_IS_SWITCHED_OFF)
                .registerWithDefault(BidsDefects.Ids.BID_FOR_CONTEXT_WONT_BE_ACCEPTED_NOT_DIFFERENT_PLACES)
                .registerWithDefault(BidsDefects.Ids.BID_FOR_SEARCH_NOT_ALLOWED_SEARCH_IS_SWITCHED_OFF)
                .registerWithDefault(BidsDefects.Ids.BID_NOT_ALLOWED_FOR_AUTOBUDGET_STRATEGY)
                .registerWithDefault(BidsDefects.Ids.BID_NOT_ALLOWED_FOR_BS_RARELY_LOADED_ADGROUP)
                .registerWithDefault(BidsDefects.Ids.CONTEXT_PRICE_IS_NOT_SET_FOR_MANUAL_STRATEGY)
                .registerWithDefault(
                        BidsDefects.Ids.BID_FOR_CONTEXT_WONT_BE_ACCEPTED_IN_CASE_OF_AUTOBUDGET_STRATEGY)
                .registerWithDefault(BidsDefects.Ids.MIXED_TYPES)
                .registerWithDefault(
                        BidsDefects.Ids.BID_FOR_SEARCH_WONT_BE_ACCEPTED_IN_CASE_OF_AUTOBUDGET_STRATEGY)
                .registerWithDefault(BidsDefects.Ids.BID_FOR_SEARCH_WONT_BE_ACCEPTED_SEARCH_IS_SWITCHED_OFF)
                .registerWithDefault(BidsDefects.Ids.PRIORITY_IS_NOT_SET_FOR_AUTO_STRATEGY)
                .registerWithDefault(
                        BidsDefects.Ids.PRIORITY_WONT_BE_ACCEPTED_IN_CASE_OF_NOT_AUTO_BUDGET_STRATEGY)
                .registerWithDefault(BidsDefects.Ids.PRIORITY_HAS_WRONG_VALUE)
                .registerWithDefault(BidsDefects.Ids.SEARCH_PRICE_IS_NOT_SET_FOR_MANUAL_STRATEGY)
                .registerWithDefault(BidsDefects.Ids.STRATEGY_IS_NOT_SET)
                .registerWithDefault(BidsDefects.ModelDefects.POSSIBLE_ONLY_ONE_FIELD)
                .registerWithDefault(BidsDefects.ModelDefects.ONE_OF_FIELDS_SHOULD_BE_SPECIFIED)
                .registerWithDefault(BidsDefects.ModelDefects.REQUIRED_AT_LEAST_ONE_OF_FIELDS)
                .registerWithDefault(BidsDefects.ModelDefects.REQUIRED_AT_LEAST_ONE_OF_FIELDS_FOR_MANUAL_STRATEGY)
                .registerWithDefault(
                        BidsDefects.ModelDefects.REQUIRED_AT_LEAST_ONE_OF_FIELDS_FOR_AUTOBUDGET_STRATEGY);
    }

    private static void registerMinuswords(DefectPresentationsHolder.Builder builder) {
        builder
                .register(MinusPhraseDefectIds.Gen.MINUS_KEYWORD_IS_INCLUDED_IN_KEYWORD,
                        t -> DefectTypes.minusWords())
                .register(MinusPhraseDefectIds.MinusPhrase.ILLEGAL_MINUS_KEYWORD_CHARS,
                        t -> MinusPhraseDefectTypes.illegalMinusKeywordCharsDetailed(t.getSubset()))
                .register(MinusPhraseDefectIds.MinusPhrase.INVALID_COMBINATION_SPECIAL_SYMBOLS,
                        t -> MinusPhraseDefectTypes.invalidCombinationOfSpecialSymbolsDetailed(t.getSubset()))
                .register(MinusPhraseDefectIds.MinusPhrase.INVALID_DOT,
                        t -> MinusPhraseDefectTypes.invalidDotDetailed(t.getSubset()))
                .register(MinusPhraseDefectIds.MinusPhrase.SEPARATE_DOT,
                        t -> MinusPhraseDefectTypes.separateDotDetailed(t.getSubset()))
                .register(MinusPhraseDefectIds.MinusPhrase.INVALID_WORD_FIRST_CHARACTER,
                        t -> MinusPhraseDefectTypes.invalidWordFirstCharacter(t.getSubset()))
                .register(MinusPhraseDefectIds.MinusPhrase.INVALID_EXCLAMATION_MARK,
                        t -> MinusPhraseDefectTypes.invalidExclamationMarkDetailed(t.getSubset()))
                .register(MinusPhraseDefectIds.MinusPhrase.INVALID_MINUS_MARK,
                        t -> MinusPhraseDefectTypes.invalidMinusMarkDetailed(t.getSubset()))
                .register(MinusPhraseDefectIds.MinusPhrase.INVALID_OPERATORS_INSIDE_SQUARE_BRACKETS,
                        t -> MinusPhraseDefectTypes.invalidOperatorsInsideSquareBracketsDetailed(t.getSubset()))
                .register(MinusPhraseDefectIds.MinusPhrase.INVALID_PLUS_MARK,
                        t -> MinusPhraseDefectTypes.invalidPlusMarkDetailed(t.getSubset()))
                .register(MinusPhraseDefectIds.MinusPhrase.WRONG_QUOTES,
                        t -> MinusPhraseDefectTypes.wrongQuotesDetailed(t.getSubset()))
                .register(MinusPhraseDefectIds.MinusPhrase.IMBALANCED_SQUARE_BRACKETS,
                        t -> MinusPhraseDefectTypes.imbalancedSquareBracketsDetailed(t.getSubset()))
                .register(MinusPhraseDefectIds.MinusPhrase.NESTED_OR_EMPTY_SQUARE_BRACKETS,
                        t -> MinusPhraseDefectTypes.nestedOrEmptySquareBracketsDetailed(t.getSubset()))
                .register(MinusPhraseDefectIds.IndividualKeywordLength.MAX_COUNT_WORDS_IN_KEYWORD,
                        t -> MinusPhraseDefectTypes.maxCountWordsInKeywordDetailed(t.getMaxWords(), t.getSubset()))
                .register(MinusPhraseDefectIds.StringLength.MAX_LENGTH_MINUS_KEYWORDS,
                        t -> MinusPhraseDefectTypes.maxLengthMinusKeywords(t.getMaxLength()))
                .register(MinusPhraseDefectIds.IndividualKeywordLength.MAX_LENGTH_MINUS_WORD,
                        t -> MinusPhraseDefectTypes.maxLengthMinusWordDetailed(t.getMaxLength(), t.getSubset()))
                .register(MinusPhraseDefectIds.Gen.MINUS_WORDS_PACK_NOT_FOUND,
                        t -> MinusPhraseDefectTypes.minusWordsPackNotFound())
                .register(MinusPhraseDefectIds.Number.NEGATIVE_KEYWORD_SETS_LIMIT_EXCEEDED,
                        t -> MinusPhraseDefectTypes.negativeKeywordSetsLimitExceeded(t.getMax()));
    }
}
