package ru.yandex.direct.api.v5.common.validation;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.validation.result.DefectId;
import ru.yandex.direct.validation.result.Path;

import static com.google.common.base.Preconditions.checkArgument;

@Component
@ParametersAreNonnullByDefault
public class DefectPresentationService {
    private DefectPresentationsHolder defectPresentationsHolder;

    public DefectPresentationService(DefectPresentationsHolder defectPresentationsHolder) {
        this.defectPresentationsHolder = defectPresentationsHolder;
    }

    public ApiDefectPresentation getPresentationFor(DefectId defectId, @Nullable DefectPresentationsHolder override) {
        if (override != null && override.contains(defectId)) {
            return override.get(defectId);
        }
        return getPresentationFor(defectId);
    }

    public ApiDefectPresentation getPresentationFor(DefectId defectId,
                                                    @Nullable DefectPresentationsHolderRespectingPath override,
                                                    Path path) {
        if (override != null && override.contains(defectId, path)) {
            return override.get(defectId, path);
        }
        return getPresentationFor(defectId);
    }

    public ApiDefectPresentation getPresentationFor(DefectId defectId) {
        checkArgument(defectPresentationsHolder.contains(defectId), "Cannot find defect presentations for %s",
                defectId);
        return defectPresentationsHolder.get(defectId);
    }
}
