package ru.yandex.direct.api.v5.configuration;

import java.util.HashMap;
import java.util.Map;

import one.util.streamex.StreamEx;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.FilterType;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;

import ru.yandex.direct.api.v5.common.validation.DefaultApiPresentations;
import ru.yandex.direct.api.v5.common.validation.DefectPresentationService;
import ru.yandex.direct.api.v5.security.ApiAuthenticationSource;
import ru.yandex.direct.api.v5.validation.validators.RegionIdsApiValidator;
import ru.yandex.direct.common.configuration.CommonConfiguration;
import ru.yandex.direct.config.DirectConfig;
import ru.yandex.direct.core.configuration.CoreConfiguration;
import ru.yandex.direct.core.entity.campaign.model.RequestSource;
import ru.yandex.direct.ytcomponents.spring.YtComponentsConfiguration;
import ru.yandex.direct.ytcore.spring.YtCoreConfiguration;

@Configuration
@Import({
        CommonConfiguration.class,
        CoreConfiguration.class,
        MessageMapperConfiguration.class,
        YtComponentsConfiguration.class,
        YtCoreConfiguration.class
})
@ComponentScan(
        basePackages = "ru.yandex.direct.api.v5",
        excludeFilters = {
                @ComponentScan.Filter(value = Configuration.class, type = FilterType.ANNOTATION),
                // исключаем классы из подпакетов security и ws
                @ComponentScan.Filter(type = FilterType.REGEX, pattern = "ru\\.yandex\\.direct\\.api\\.v5\\.(security|ws)\\..*")
        }
)
public class ApiConfiguration {

    public static final String API_AUTHENTICATION_SOURCE = "apiAuthenticationSource";

    @Bean(name = API_AUTHENTICATION_SOURCE)
    ApiAuthenticationSource apiAuthenticationSource(DirectConfig cfg) {
        Map<String, RequestSource> requestSourceByAppId = new HashMap<>();
        DirectConfig requestSourcesConfig = cfg.getBranch("request_sources");
        for (String requestSource : requestSourcesConfig.asMap().keySet()) {
            StreamEx.of(requestSourcesConfig.getStringList(requestSource))
                    .forEach(appId -> requestSourceByAppId.put(appId, RequestSource.valueOf(requestSource)));
        }

        return new ApiAuthenticationSource(
                cfg.getStringList("services_application_ids"),
                cfg.getStringList("display_url_texts_allowed_application_ids"),
                cfg.getStringList("leadform_attributes_allowed_application_ids"),
                requestSourceByAppId
        );
    }

    @Bean
    public DefectPresentationService defectPresentationService() {
        return new DefectPresentationService(DefaultApiPresentations.HOLDER);
    }

    @Bean
    @Lazy
    public RegionIdsApiValidator regionIdsApiValidator() {
        return new RegionIdsApiValidator();
    }
}
