package ru.yandex.direct.api.v5.configuration;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ClassPathResource;
import org.springframework.ws.wsdl.wsdl11.SimpleWsdl11Definition;
import org.springframework.xml.xsd.SimpleXsdSchema;

/**
 * Конфигурационный класс для настройки расположения wsdl-файлов для сервисов
 * <p>
 * Wsdl-файл выдается по нестандартному пути, оканчивающемуся на ?wsdl.
 * Соответствующая логика расположена в {@link ru.yandex.direct.api.v5.ws.ApiWsDispatcherServlet}
 * Желательно поддерживать список в алфавитном порядке
 */
@Configuration
public class WsdlConfiguration {
    /**
     * Xsd-ка общих типов для всех сервисов
     */
    @Bean(name = "general")
    public SimpleXsdSchema generalXsd() {
        return new SimpleXsdSchema(new ClassPathResource("wsdl/general.xsd"));
    }

    @Bean(name = "agencyclients")
    public SimpleWsdl11Definition agencyWsdl() {
        return new SimpleWsdl11Definition(new ClassPathResource("wsdl/AgencyClients.wsdl"));
    }

    @Bean(name = "audiencetargets")
    public SimpleWsdl11Definition audienceTargetsWsdl() {
        return new SimpleWsdl11Definition(new ClassPathResource("wsdl/AudienceTargets.wsdl"));
    }

    @Bean(name = "businesses")
    public SimpleWsdl11Definition businessesWsdl() {
        return new SimpleWsdl11Definition(new ClassPathResource("wsdl/Businesses.wsdl"));
    }

    @Bean(name = "clients")
    public SimpleWsdl11Definition clientsWsdl() {
        return new SimpleWsdl11Definition(new ClassPathResource("wsdl/Clients.wsdl"));
    }

    @Bean(name = "features")
    public SimpleWsdl11Definition featuresWsdl() {
        return new SimpleWsdl11Definition(new ClassPathResource("wsdl/Features.wsdl"));
    }

    @Bean(name = "keywordsresearch")
    public SimpleWsdl11Definition keywordsResearchWsdl() {
        return new SimpleWsdl11Definition(new ClassPathResource("wsdl/KeywordsResearch.wsdl"));
    }

    @Bean(name = "keywords")
    public SimpleWsdl11Definition keywordsWsdl() {
        return new SimpleWsdl11Definition(new ClassPathResource("wsdl/Keywords.wsdl"));
    }

    @Bean(name = "retargetinglists")
    public SimpleWsdl11Definition retargetingListsWsdl() {
        return new SimpleWsdl11Definition(new ClassPathResource("wsdl/RetargetingLists.wsdl"));
    }

    @Bean(name = "sitelinks")
    public SimpleWsdl11Definition sitelinksWsdl() {
        return new SimpleWsdl11Definition(new ClassPathResource("wsdl/Sitelinks.wsdl"));
    }

    @Bean(name = "vcards")
    public SimpleWsdl11Definition vcardsWsdl() {
        return new SimpleWsdl11Definition(new ClassPathResource("wsdl/VCards.wsdl"));
    }

    @Bean(name = "adgroups")
    public SimpleWsdl11Definition adGroupsWsdl() {
        return new SimpleWsdl11Definition(new ClassPathResource("wsdl/AdGroups.wsdl"));
    }

    @Bean(name = "bidmodifiers")
    public SimpleWsdl11Definition bidModifiersWsdl() {
        return new SimpleWsdl11Definition(new ClassPathResource("wsdl/BidModifiers.wsdl"));
    }

    @Bean(name = "creatives")
    public SimpleWsdl11Definition creativesWsdl() {
        return new SimpleWsdl11Definition(new ClassPathResource("wsdl/Creatives.wsdl"));
    }

    @Bean(name = "dictionaries")
    public SimpleWsdl11Definition dictionariesWsdl() {
        return new SimpleWsdl11Definition(new ClassPathResource("wsdl/Dictionaries.wsdl"));
    }

    @Bean(name = "dynamictextadtargets")
    public SimpleWsdl11Definition dynamicTextAdTargetsWsdl() {
        return new SimpleWsdl11Definition(new ClassPathResource("wsdl/DynamicTextAdTargets.wsdl"));
    }

    @Bean(name = "dynamicfeedadtargets")
    public SimpleWsdl11Definition dynamicFeedAdTargetsWsdl() {
        return new SimpleWsdl11Definition(new ClassPathResource("wsdl/DynamicFeedAdTargets.wsdl"));
    }

    @Bean(name = "negativekeywordsharedsets")
    public SimpleWsdl11Definition negativekeywordsharedsetsWsdl() {
        return new SimpleWsdl11Definition(new ClassPathResource("wsdl/NegativeKeywordSharedSets.wsdl"));
    }

    @Bean(name = "smartadtargets")
    public SimpleWsdl11Definition smartadtargetsWsdl() {
        return new SimpleWsdl11Definition(new ClassPathResource("wsdl/SmartAdTargets.wsdl"));
    }

    @Bean(name = "promotedcontent")
    public SimpleWsdl11Definition promotedcontentWsdl() {
        return new SimpleWsdl11Definition(new ClassPathResource("wsdl/PromotedContent.wsdl"));
    }

    @Bean(name = "feeds")
    public SimpleWsdl11Definition feedsWsdl() {
        return new SimpleWsdl11Definition(new ClassPathResource("wsdl/Feeds.wsdl"));
    }

    @Bean(name = "changes")
    public SimpleWsdl11Definition changesWsdl() {
        return new SimpleWsdl11Definition(new ClassPathResource("wsdl/Changes.wsdl"));
    }

    @Bean(name = "advideos")
    public SimpleWsdl11Definition adVideosWsdl() {
        return new SimpleWsdl11Definition(new ClassPathResource("wsdl/AdVideos.wsdl"));
    }
}
