package ru.yandex.direct.api.v5.context;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * Создание и сохранение объекта {@link ApiContext}, относящегося к текущему запросу
 */
@Component
public class ApiContextFilter implements Filter {
    private final ApiContextHolder apiContextHolder;

    @Autowired
    public ApiContextFilter(ApiContextHolder apiContextHolder) {
        this.apiContextHolder = apiContextHolder;
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        // no initialization
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain)
            throws IOException, ServletException {
        apiContextHolder.set(new ApiContext());
        chain.doFilter(request, response);
    }

    @Override
    public void destroy() {
        // no finalization
    }
}
