package ru.yandex.direct.api.v5.context.units;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;

import ru.yandex.direct.rbac.RbacRole;

@ParametersAreNonnullByDefault
public class OperatorClientData {

    private Long operatorClientId;
    private String operatorClientLogin;
    private RbacRole operatorClientRole;
    private Integer operatorClientUnitsDaily;
    private Integer operatorClientUnitsManual;

    public Long getOperatorClientId() {
        return operatorClientId;
    }

    public String getOperatorClientLogin() {
        return operatorClientLogin;
    }

    @JsonGetter("operator_client_role")
    public String getOperatorClientRoleString() {
        return operatorClientRole == null ? null : operatorClientRole.name().toLowerCase();
    }

    @JsonIgnore
    public RbacRole getOperatorClientRole() {
        return operatorClientRole;
    }

    public Integer getOperatorClientUnitsDaily() {
        return operatorClientUnitsDaily;
    }

    public Integer getOperatorClientUnitsManual() {
        return operatorClientUnitsManual;
    }

    public OperatorClientData withOperatorClientId(Long operatorClientId) {
        this.operatorClientId = operatorClientId;
        return this;
    }

    public OperatorClientData withOperatorClientLogin(String operatorClientLogin) {
        this.operatorClientLogin = operatorClientLogin;
        return this;
    }

    public OperatorClientData withOperatorClientRole(RbacRole operatorClientRole) {
        this.operatorClientRole = operatorClientRole;
        return this;
    }

    public OperatorClientData withOperatorClientUnitsDaily(Integer operatorClientUnitsDaily) {
        this.operatorClientUnitsDaily = operatorClientUnitsDaily;
        return this;
    }

    public OperatorClientData withOperatorClientUnitsManual(Integer operatorClientUnitsManual) {
        this.operatorClientUnitsManual = operatorClientUnitsManual;
        return this;
    }

}
