package ru.yandex.direct.api.v5.context.units;

import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class OperatorData {

    private OperatorBrandData brand;

    private OperatorClientData client;

    private String operatorLogin;

    private long operatorUid;

    public OperatorBrandData getBrand() {
        return brand;
    }

    public OperatorClientData getClient() {
        return client;
    }

    public String getOperatorLogin() {
        return operatorLogin;
    }

    public long getOperatorUid() {
        return operatorUid;
    }

    public OperatorData withBrand(OperatorBrandData brand) {
        this.brand = brand;
        return this;
    }

    public OperatorData withClient(OperatorClientData client) {
        this.client = client;
        return this;
    }

    public OperatorData withOperatorLogin(String login) {
        this.operatorLogin = login;
        return this;
    }

    public OperatorData withOperatorUid(long uid) {
        this.operatorUid = uid;
        return this;
    }
}
