package ru.yandex.direct.api.v5.context.units;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;

@ParametersAreNonnullByDefault
public class UnitsBucket {

    public enum Type {
        OPERATOR,
        OPERATOR_BRAND,
        SUBCLIENT,
        SUBCLIENT_BRAND
    }

    private Long bucketClientId;
    private String bucketLogin;
    private Type bucketType;
    private Integer bucketUnitsBalance;
    private Integer bucketUnitsLimit;
    private Integer bucketUnitsSpent;

    public Long getBucketClientId() {
        return bucketClientId;
    }

    public String getBucketLogin() {
        return bucketLogin;
    }

    @JsonGetter("bucket_type")
    public String getBucketTypeString() {
        return bucketType == null ? null : bucketType.name().toLowerCase();
    }

    @JsonIgnore
    public Type getBucketType() {
        return bucketType;
    }

    public Integer getBucketUnitsBalance() {
        return bucketUnitsBalance;
    }

    public Integer getBucketUnitsLimit() {
        return bucketUnitsLimit;
    }

    public Integer getBucketUnitsSpent() {
        return bucketUnitsSpent;
    }

    public UnitsBucket withBucketClientId(Long bucketClientId) {
        this.bucketClientId = bucketClientId;
        return this;
    }

    public UnitsBucket withBucketLogin(@Nullable String bucketLogin) {
        this.bucketLogin = bucketLogin;
        return this;
    }

    public UnitsBucket withBucketType(Type bucketType) {
        this.bucketType = bucketType;
        return this;
    }

    public UnitsBucket withBucketUnitsBalance(Integer bucketUnitsBalance) {
        this.bucketUnitsBalance = bucketUnitsBalance;
        return this;
    }

    public UnitsBucket withBucketUnitsLimit(Integer bucketUnitsLimit) {
        this.bucketUnitsLimit = bucketUnitsLimit;
        return this;
    }

    public UnitsBucket withBucketUnitsSpent(Integer bucketUnitsSpent) {
        this.bucketUnitsSpent = bucketUnitsSpent;
        return this;
    }

}
