package ru.yandex.direct.api.v5.context.units;

import java.util.Optional;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.api.v5.units.UseOperatorUnitsMode;

import static ru.yandex.direct.api.v5.units.UseOperatorUnitsMode.FALSE;

@ParametersAreNonnullByDefault
public class UnitsLogData {

    private OperatorData operator;
    private SubclientData subcilent;

    private String clientLogin;
    private String unitsUsedLogin;

    @JsonProperty("reqid")
    private Long requestId;
    private UseOperatorUnitsMode useOperatorUnitsMode = FALSE;

    private boolean isOperatorFailure;
    private boolean isServerFault;

    private UnitsBucket bucket;

    @JsonIgnore
    @Nullable
    public Long getOperatorBrandClientId() {
        return getOperatorBrand().map(OperatorBrandData::getOperatorBrandClientId).orElse(null);
    }

    @JsonIgnore
    @Nullable
    public Long getOperatorClientId() {
        return getOperatorClient().map(OperatorClientData::getOperatorClientId).orElse(null);
    }

    @JsonIgnore
    @Nullable
    public String getOperatorBrandLogin() {
        return getOperatorBrand().map(OperatorBrandData::getOperatorBrandLogin).orElse(null);
    }

    @JsonIgnore
    @Nullable
    public String getOperatorClientLogin() {
        return getOperatorClient().map(OperatorClientData::getOperatorClientLogin).orElse(null);
    }

    @JsonIgnore
    @Nullable
    public Long getSubclientBrandClientId() {
        return getSubclientBrand().map(SubclientBrandData::getSubclientBrandClientId).orElse(null);
    }

    @JsonIgnore
    @Nullable
    public Long getSubclientClientId() {
        return getSubclientClient().map(SubclientClientData::getSubclientClientId).orElse(null);
    }

    @JsonIgnore
    @Nullable
    public String getSubclientBrandLogin() {
        return getSubclientBrand().map(SubclientBrandData::getSubclientBrandLogin).orElse(null);
    }

    @JsonIgnore
    @Nullable
    public String getSubclientClientLogin() {
        return getSubclientClient().map(SubclientClientData::getSubclientLogin).orElse(null);
    }

    @JsonIgnore
    private Optional<OperatorBrandData> getOperatorBrand() {
        return Optional.ofNullable(getOperator()).map(OperatorData::getBrand);
    }

    @JsonIgnore
    private Optional<OperatorClientData> getOperatorClient() {
        return Optional.ofNullable(getOperator()).map(OperatorData::getClient);
    }

    @JsonIgnore
    private Optional<SubclientBrandData> getSubclientBrand() {
        return Optional.ofNullable(getSubcilent()).map(SubclientData::getBrand);
    }

    @JsonIgnore
    private Optional<SubclientClientData> getSubclientClient() {
        return Optional.ofNullable(getSubcilent()).map(SubclientData::getClient);
    }

    @JsonGetter("use_operator_units")
    public String getUseOperatorUnitsMode() {
        return useOperatorUnitsMode.toString();
    }

    @JsonGetter("is_operator_failure")
    public int getIsOperatorFailure() {
        return isOperatorFailure ? 1 : 0;
    }

    @JsonGetter("is_server_fault")
    public int getIsServerFault() {
        return isServerFault ? 1 : 0;
    }

    @JsonGetter("reqid")
    public Long getRequestId() {
        return requestId;
    }

    public UnitsBucket getBucket() {
        return bucket;
    }

    @Nullable
    public String getClientLogin() {
        return clientLogin;
    }

    public String getUnitsUsedLogin() {
        return unitsUsedLogin;
    }

    @JsonIgnore
    public boolean getOperatorFailure() {
        return isOperatorFailure;
    }

    @JsonIgnore
    public boolean getServerFault() {
        return isServerFault;
    }

    public OperatorData getOperator() {
        return operator;
    }

    public SubclientData getSubcilent() {
        return subcilent;
    }

    @JsonIgnore
    public UseOperatorUnitsMode useOperatorUnitsMode() {
        return useOperatorUnitsMode;
    }

    public UnitsLogData withBucket(UnitsBucket bucket) {
        this.bucket = bucket;
        return this;
    }

    public UnitsLogData withClientLogin(@Nullable String clientLogin) {
        this.clientLogin = clientLogin;
        return this;
    }

    public UnitsLogData withUnitsUsedLogin(@Nullable String unitsUsedLogin) {
        this.unitsUsedLogin = unitsUsedLogin;
        return this;
    }

    public UnitsLogData withOperator(OperatorData operator) {
        this.operator = operator;
        return this;
    }

    public UnitsLogData withSubcilent(SubclientData subcilent) {
        this.subcilent = subcilent;
        return this;
    }

    public UnitsLogData withRequestId(Long requestId) {
        this.requestId = requestId;
        return this;
    }

    public UnitsLogData withUseOperatorUnitsMode(UseOperatorUnitsMode useOperatorUnitsMode) {
        this.useOperatorUnitsMode = useOperatorUnitsMode;
        return this;
    }

    public UnitsLogData withIsOperatorFailure(boolean isOperatorFailure) {
        this.isOperatorFailure = isOperatorFailure;
        return this;
    }

    public UnitsLogData withIsServerFault(boolean isServerFault) {
        this.isServerFault = isServerFault;
        return this;
    }

}
