package ru.yandex.direct.api.v5.converter;

import java.util.function.Function;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;

public class PropertyConverter<C extends Model, X, Y> {
    private Function<X, Y> converter;
    private ModelProperty<? super C, Y> property;

    public PropertyConverter(Function<X, Y> converter, ModelProperty<? super C, Y> property) {
        this.converter = converter;
        this.property = property;
    }

    public Y apply(X x) {
        return converter.apply(x);
    }

    public ModelProperty<? super C, Y> getProperty() {
        return property;
    }
}
