package ru.yandex.direct.api.v5.converter;

import java.util.function.Function;

import com.yandex.direct.api.v5.general.YesNoEnum;

import ru.yandex.direct.model.Model;
import ru.yandex.direct.model.ModelProperty;

import static java.util.function.Function.identity;

public class PropertyConverterFactory {

    public static <C extends Model, X, Y> PropertyConverter<C, X, Y> of(Function<X, Y> converter,
                                                                        ModelProperty<? super C, Y> property) {
        return new PropertyConverter<>(converter, property);
    }

    public static <C extends Model, X> PropertyConverter<C, X, X> of(ModelProperty<C, X> property) {
        return PropertyConverterFactory.of(identity(), property);
    }

    public static <C extends Model> PropertyConverter<C, YesNoEnum, Boolean> yesToTrue(
            ModelProperty<? super C, Boolean> property) {
        return PropertyConverterFactory.of(e -> e == YesNoEnum.YES, property);
    }

    public static <C extends Model> PropertyConverter<C, YesNoEnum, Boolean> yesToFalse(
            ModelProperty<? super C, Boolean> property) {
        return PropertyConverterFactory.of(e -> e != YesNoEnum.YES, property);
    }
}
