package ru.yandex.direct.api.v5.entity;

import ru.yandex.direct.api.v5.validation.ApiDefect;
import ru.yandex.direct.api.v5.validation.ValidationException;

/**
 * Специальный тип исключения для обработки ошибок валидации в endpoint-ах
 * api. Выбрасывается для того чтобы сообщить вышележащим уровням о наличии
 * ошибок валидации и необходимости формировать в ответ пользователю fault-ответ.
 * Также позволяет контроллировать необходимо ли списывать баллы на уровне запроса в
 * случае выбрасывания исключения заданного типа. Правильное использование данного
 * класса предполагает, что он по возможности не должен выбрасываться вне кода
 * нашего framework-а
 */
public class ApiValidationException extends ValidationException {
    private final boolean unitsSpent;

    public ApiValidationException(ApiDefect apiDefect, boolean unitsSpent) {
        super(apiDefect);
        this.unitsSpent = unitsSpent;
    }

    public boolean isUnitsSpent() {
        return unitsSpent;
    }
}
