package ru.yandex.direct.api.v5.entity;

import java.util.Set;

import ru.yandex.direct.multitype.entity.LimitOffset;

/**
 * Обобщенное представление get-запроса.
 * Смотреть {@link GetApiServiceDelegate}.
 *
 * @param <F> тип перечисления требуемых в ответе полей
 * @param <S> тип условия выборки
 */
public class GenericGetRequest<F extends Enum<F>, S> {

    private final Set<F> requestedFields;
    private final S selectionCriteria;
    private final LimitOffset limitOffset;

    public GenericGetRequest(Set<F> requestedFields, S selectionCriteria, LimitOffset limitOffset) {
        this.requestedFields = requestedFields;
        this.selectionCriteria = selectionCriteria;
        this.limitOffset = limitOffset;
    }

    static <F extends Enum<F>, S> GenericGetRequest<F, S> copyAndIncrementLimit(
            GenericGetRequest<F, S> genericGetRequest) {
        return new GenericGetRequest<>(genericGetRequest.requestedFields, genericGetRequest.selectionCriteria,
                copyAndIncrementLimit(genericGetRequest.limitOffset));
    }

    public Set<F> getRequestedFields() {
        return requestedFields;
    }

    public S getSelectionCriteria() {
        return selectionCriteria;
    }

    public LimitOffset getLimitOffset() {
        return limitOffset;
    }

    private static LimitOffset copyAndIncrementLimit(LimitOffset limitOffset) {
        return new LimitOffset(limitOffset.limit() + 1, limitOffset.offset());
    }
}
