package ru.yandex.direct.api.v5.entity;

import java.util.List;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.api.v5.result.ApiMassResult;
import ru.yandex.direct.api.v5.security.ApiAuthenticationSource;
import ru.yandex.direct.api.v5.validation.DefectType;
import ru.yandex.direct.common.db.PpcPropertiesSupport;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.validation.result.PathConverter;
import ru.yandex.direct.validation.result.ValidationResult;

/**
 * OperationOnListDelegateWithContainer, но без контейнера (контейнер = null)
 */
@ParametersAreNonnullByDefault
public abstract class OperationOnListDelegate<Req, Resp, IntReqEl, IntRespEl>
        extends OperationOnListDelegateWithContainer<Req, Resp, IntReqEl, IntRespEl, Object> {

    public OperationOnListDelegate(PathConverter apiPathConverter,
                                   ApiAuthenticationSource apiAuthenticationSource,
                                   PpcPropertiesSupport ppcPropertiesSupport,
                                   @Nullable FeatureService featureService) {
        super(apiPathConverter, apiAuthenticationSource);
    }

    public OperationOnListDelegate(PathConverter apiPathConverter,
                                   ApiAuthenticationSource apiAuthenticationSource) {
        this(apiPathConverter, apiAuthenticationSource, null, null);
    }

    @Override
    protected final Object createContainer() {
        return null;
    }

    @Nonnull
    @Override
    public final ValidationResult<List<IntReqEl>, DefectType> validateInternalRequest(
            List<IntReqEl> internalRequest,
            @Nullable Object container) {
        return validateInternalRequest(internalRequest);
    }

    public ValidationResult<List<IntReqEl>, DefectType> validateInternalRequest(
            List<IntReqEl> internalRequest) {
        return new ValidationResult<>(internalRequest);
    }

    @Override
    public final ApiMassResult<IntRespEl> processList(List<IntReqEl> validItems, Object container) {
        return processList(validItems);
    }

    public abstract ApiMassResult<IntRespEl> processList(List<IntReqEl> validItems);
}
