package ru.yandex.direct.api.v5.entity.adextensions;

import ru.yandex.direct.api.v5.validation.DefectType;
import ru.yandex.direct.api.v5.validation.DefectTypes;
import ru.yandex.direct.core.entity.addition.callout.service.validation.CalloutDefectTranslations;
import ru.yandex.direct.core.validation.CommonDefectTranslations;

public class AdExtensionsDefectTypes {
    private AdExtensionsDefectTypes() {
    }

    private static CommonDefectTranslations commonTranslations() {
        return CommonDefectTranslations.INSTANCE;
    }

    private static CalloutDefectTranslations translations() {
        return CalloutDefectTranslations.INSTANCE;
    }

    public static DefectType adExtensionsIsDuplicatedDelete() {
        return DefectTypes.duplicatedObject()
                .withDetailedMessage((path, value) -> translations().duplicateCalloutId());
    }

    public static DefectType adExtensionNotFound() {
        return DefectTypes.notFound().withDetailedMessage(translations().adExtensionNotFound());
    }
}
