package ru.yandex.direct.api.v5.entity.adextensions;


import com.yandex.direct.api.v5.adextensions.AdExtensionsPort;
import com.yandex.direct.api.v5.adextensions.AddRequest;
import com.yandex.direct.api.v5.adextensions.AddResponse;
import com.yandex.direct.api.v5.adextensions.ApiException;
import com.yandex.direct.api.v5.adextensions.DeleteRequest;
import com.yandex.direct.api.v5.adextensions.DeleteResponse;
import com.yandex.direct.api.v5.adextensions.GetRequest;
import com.yandex.direct.api.v5.adextensions.GetResponse;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.api.v5.common.ApiPathConverter;
import ru.yandex.direct.api.v5.entity.GenericApiService;
import ru.yandex.direct.api.v5.entity.adextensions.delegate.AddAdExtensionsDelegate;
import ru.yandex.direct.api.v5.entity.adextensions.delegate.DeleteAdExtensionsDelegate;
import ru.yandex.direct.api.v5.entity.adextensions.delegate.GetAdExtensionsDelegate;
import ru.yandex.direct.api.v5.ws.annotation.ApiMethod;
import ru.yandex.direct.api.v5.ws.annotation.ApiRequest;
import ru.yandex.direct.api.v5.ws.annotation.ApiResponse;
import ru.yandex.direct.api.v5.ws.annotation.ApiServiceEndpoint;
import ru.yandex.direct.api.v5.ws.annotation.ApiServiceType;
import ru.yandex.direct.api.v5.ws.annotation.ServiceType;
import ru.yandex.direct.core.security.authorization.PreAuthorizeRead;
import ru.yandex.direct.core.security.authorization.PreAuthorizeWrite;
import ru.yandex.direct.validation.result.MappingPathConverter;
import ru.yandex.direct.validation.result.PathConverter;

/**
 * Сервис по работе с расширениями рекламных объявлений.
 *
 * @see <a href=https://tech.yandex.ru/direct/doc/ref-v5/adextensions/adextensions-docpage/>AdExtensions API tech docs</a>
 */
@ApiServiceEndpoint
@ApiServiceType(type = ServiceType.CLIENT)
public class AdExtensionsEndpoint implements AdExtensionsPort {

    private static final String SERVICE_NAME = "adextensions";

    public static final PathConverter PATH_CONVERTER =
            MappingPathConverter.builder(AdExtensionsEndpoint.class, "capitalize")
                    .add(ApiPathConverter.getCommonDict())
                    .build();

    private final AddAdExtensionsDelegate addAdExtensionsDelegate;
    private final DeleteAdExtensionsDelegate deleteAdExtensionsDelegate;
    private final GetAdExtensionsDelegate getAdExtensionsDelegate;
    private final GenericApiService genericApiService;

    @Autowired
    public AdExtensionsEndpoint(
            AddAdExtensionsDelegate addAdExtensionsDelegate,
            DeleteAdExtensionsDelegate deleteAdExtensionsDelegate,
            GetAdExtensionsDelegate getAdExtensionsDelegate,
            GenericApiService genericApiService) {
        this.addAdExtensionsDelegate = addAdExtensionsDelegate;
        this.deleteAdExtensionsDelegate = deleteAdExtensionsDelegate;
        this.getAdExtensionsDelegate = getAdExtensionsDelegate;
        this.genericApiService = genericApiService;
    }

    @PreAuthorizeWrite
    @ApiMethod(service = SERVICE_NAME, operation = "add")
    @ApiResponse
    @Override
    public AddResponse add(@ApiRequest AddRequest parameters) throws ApiException {
        return genericApiService.doAction(addAdExtensionsDelegate, parameters);
    }

    @PreAuthorizeRead
    @ApiMethod(service = SERVICE_NAME, operation = "get")
    @ApiResponse
    @Override
    public GetResponse get(@ApiRequest GetRequest parameters) throws ApiException {
        return genericApiService.doAction(getAdExtensionsDelegate, parameters);
    }

    @PreAuthorizeWrite
    @ApiMethod(service = SERVICE_NAME, operation = "delete")
    @ApiResponse
    @Override
    public DeleteResponse delete(@ApiRequest DeleteRequest deleteRequest) throws ApiException {
        return genericApiService.doAction(deleteAdExtensionsDelegate, deleteRequest);
    }

    private static RuntimeException notImplementedYet() {
        return new UnsupportedOperationException("Not implemented yet.");
    }

}
