package ru.yandex.direct.api.v5.entity.adextensions;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.api.v5.validation.DefectType;
import ru.yandex.direct.core.entity.addition.callout.service.validation.CalloutConstants;
import ru.yandex.direct.core.entity.addition.callout.service.validation.CalloutDefectTranslations;

import static ru.yandex.direct.api.v5.validation.DefectTypes.MAX_STRING_SIZE_CODE;
import static ru.yandex.direct.api.v5.validation.DefectTypes.translations;

@ParametersAreNonnullByDefault
public class CalloutDefectTypes {

    private CalloutDefectTypes() {
    }

    public static DefectType maxCalloutTextSize() {
        return new DefectType(MAX_STRING_SIZE_CODE,
                translations().maxStringSizeShort(),
                (path, value) -> CalloutDefectTranslations.INSTANCE
                        .calloutTextLengthExceeded(String.valueOf(value), CalloutConstants.MAX_CALLOUT_TEXT_LENGTH));
    }

}
