package ru.yandex.direct.api.v5.entity.adextensions.converter;

import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.adextensions.AdExtensionGetItem;
import com.yandex.direct.api.v5.adextensiontypes.AdExtensionTypeEnum;
import com.yandex.direct.api.v5.adextensiontypes.Callout;
import com.yandex.direct.api.v5.general.StateEnum;
import com.yandex.direct.api.v5.general.StatusEnum;

import ru.yandex.direct.api.v5.common.GeneralUtil;
import ru.yandex.direct.api.v5.entity.adextensions.container.InternalGetResponse;
import ru.yandex.direct.core.entity.addition.callout.model.CalloutsStatusModerate;

import static com.google.common.base.Preconditions.checkState;

@ParametersAreNonnullByDefault
public class InternalGetResponseConverter {
    public static AdExtensionGetItem convert(InternalGetResponse responseItem) {
        ru.yandex.direct.core.entity.addition.callout.model.Callout callout = responseItem.getCallout();
        checkState(callout != null);

        AdExtensionGetItem getItem = new AdExtensionGetItem()
                .withId(callout.getId())
                .withType(AdExtensionTypeEnum.CALLOUT)
                .withState(callout.getDeleted() == null ?
                        StateEnum.UNKNOWN : (callout.getDeleted() ? StateEnum.DELETED : StateEnum.ON))
                .withStatus(convertStatusModerate(callout.getStatusModerate()))
                .withCallout(new Callout().withCalloutText(callout.getText()));
        if (responseItem.getAssociated() != null) {
            getItem.setAssociated(GeneralUtil.yesNoFromBool(responseItem.getAssociated()));
        }
        getItem.setStatusClarification(responseItem.getStatusClarification());
        return getItem;
    }

    private static StatusEnum convertStatusModerate(CalloutsStatusModerate status) {
        switch (status) {
            case NEW:
                return StatusEnum.DRAFT;
            case SENT:
            case SENDING:
            case READY:
                return StatusEnum.MODERATION;
            case YES:
                return StatusEnum.ACCEPTED;
            case NO:
                return StatusEnum.REJECTED;
            default:
                throw new IllegalArgumentException("unknown status");
        }
    }

}
