package ru.yandex.direct.api.v5.entity.adextensions.delegate;

import java.util.List;

import com.yandex.direct.api.v5.adextensions.DeleteRequest;
import com.yandex.direct.api.v5.adextensions.DeleteResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.api.v5.common.validation.DefectPresentationsHolder;
import ru.yandex.direct.api.v5.converter.ResultConverter;
import ru.yandex.direct.api.v5.entity.BaseApiServiceDelegate;
import ru.yandex.direct.api.v5.entity.adextensions.AdExtensionsDefectTypes;
import ru.yandex.direct.api.v5.entity.adextensions.AdExtensionsEndpoint;
import ru.yandex.direct.api.v5.entity.adextensions.validation.DeleteAdExtensionsRequestValidator;
import ru.yandex.direct.api.v5.result.ApiMassResult;
import ru.yandex.direct.api.v5.result.ApiResult;
import ru.yandex.direct.api.v5.security.ApiAuthenticationSource;
import ru.yandex.direct.api.v5.validation.DefectType;
import ru.yandex.direct.core.entity.addition.callout.service.CalloutService;
import ru.yandex.direct.result.MassResult;
import ru.yandex.direct.validation.defect.ids.CollectionDefectIds;
import ru.yandex.direct.validation.result.DefectIds;
import ru.yandex.direct.validation.result.ValidationResult;


/**
 * Удалить расширения
 * <p>
 * https://tech.yandex.ru/direct/doc/ref-v5/adextensions/delete-docpage/
 */
@Component
public class DeleteAdExtensionsDelegate
        extends BaseApiServiceDelegate<DeleteRequest, DeleteResponse, List<Long>, ApiResult<Long>> {
    private static final DefectPresentationsHolder DELETE_ADEXTENSIONS_DEFECT_PRESENTATIONS =
            DefectPresentationsHolder.builder()
                    .register(CollectionDefectIds.Gen.MUST_NOT_CONTAIN_DUPLICATED_ELEMENTS,
                            AdExtensionsDefectTypes.adExtensionsIsDuplicatedDelete())
                    .register(DefectIds.OBJECT_NOT_FOUND,
                            AdExtensionsDefectTypes.adExtensionNotFound())
                    .build();

    private final DeleteAdExtensionsRequestValidator deleteRequestValidator;
    private final ResultConverter resultConverter;
    private final CalloutService calloutService;

    @Autowired
    public DeleteAdExtensionsDelegate(ApiAuthenticationSource apiAuthenticationSource,
                                      DeleteAdExtensionsRequestValidator deleteRequestValidator,
                                      ResultConverter resultConverter, CalloutService calloutService) {
        super(AdExtensionsEndpoint.PATH_CONVERTER, apiAuthenticationSource);
        this.deleteRequestValidator = deleteRequestValidator;
        this.resultConverter = resultConverter;
        this.calloutService = calloutService;
    }

    @Override
    public ValidationResult<DeleteRequest, DefectType> validateRequest(DeleteRequest externalRequest) {
        return deleteRequestValidator.validateRequest(externalRequest);
    }

    @Override
    public List<Long> convertRequest(DeleteRequest externalRequest) {
        return externalRequest.getSelectionCriteria().getIds();
    }

    @Override
    public ApiMassResult<Long> processRequest(List<Long> internalRequest) {
        MassResult<Long> result = calloutService.deleteCallouts(
                internalRequest, auth.getSubclient().getClientId());
        return resultConverter.toApiMassResult(result, DELETE_ADEXTENSIONS_DEFECT_PRESENTATIONS);
    }

    @Override
    public DeleteResponse convertResponse(ApiResult<List<ApiResult<Long>>> result) {
        return new DeleteResponse()
                .withDeleteResults(resultConverter.toActionResults(result, apiPathConverter));
    }
}
